<?php

if (defined('FMP_PLUGIN_PATH')) {
    class FastMicroPayDownload
    {
        public function __construct($fast_micro_pay_content)
        {
            $this->fast_micro_pay_content = $fast_micro_pay_content;
            if ($this->fast_micro_pay_content->core->is_license_active()) {
                add_filter('the_content', array($this, 'content'));
            }
        }

        public function content($content)
        {
            global $post;
            $content_normal = $content;
            $content_normal = str_replace('&#8221;', '"', $content_normal);
            $content_normal = str_replace('&#8243;', '"', $content_normal);
//            $service_id = get_post_meta($post->ID, 'fmp_service_id', true);
	        $unlocked=false;

	        $allowed_services_id=$this->fast_micro_pay_content->core->get_post_services($post->ID);
	        foreach($allowed_services_id AS $service_id)
	        {
		        if($this->fast_micro_pay_content->is_service_unlocked($service_id, @(int) $this->fast_micro_pay_content->core->options['services'][(int) $service_id]['expiration_time'])) {
			        $unlocked=true;
			        break;
		        }
	        }

		        if (preg_match_all('/\[DOWNLOAD file="([^"]+)" name="([^"]+)"\]/i', $content_normal, $match) and ($unlocked or
		            $this->fast_micro_pay_content->is_post_unlocked($post->ID, @(int) $this->fast_micro_pay_content->core->options['services'][(int) $service_id]['expiration_time']))) {
			        foreach ($match[0] as $k => $v) {
				        $content = preg_replace('/\[DOWNLOAD file=&#82[0-9]{2,2};'.preg_quote($match[1][$k],'/').'&#82[0-9]{2,2}; name=&#82[0-9]{2,2};'.preg_quote($match[2][$k],'/').'&#82[0-9]{2,2};\]/', '<a class="fmp-download" href="'.FMP_PLUGIN_URL.'addons/fast-micro-pay-download.php?post_id='.$post->ID.'&amp;service_id='.$service_id.'&amp;file='.urlencode($this->fast_micro_pay_content->core->encrypt(base64_encode($match[1][$k]), AUTH_SALT)).'">'.$match[2][$k].'</a>', $content);
			        }

		        }
            return $content;
        }

        public function download($file)
        {
            // @apache_setenv('no-gzip', 1);
            @ini_set('zlib.output_compression', 'Off');

            $path_parts = pathinfo($file);
            $file_name = $path_parts['basename'];
            $file = ltrim($file, '/');
            header('Pragma: public');
            header('Expires: -1');
            header('Cache-Control: public, must-revalidate, post-check=0, pre-check=0');
            header("Content-Disposition: attachment; filename=\"$file_name\"");
            header('Content-Type: application/octet-stream');
            readfile('../../../../'.$file);
        }
    }
} else {
	$unlocked=false;
    define('WP_USE_THEMES', false);
    include '../../../../wp-load.php';
    ob_end_clean();
    $license_status = $fast_micro_pay->is_license_active();
    if (empty($fast_micro_pay) or empty($license_status) or empty($fast_micro_pay_download)) {
        die('Nieprawidlowa licencja');
    }

    if (empty($_GET['post_id']) or empty($_GET['service_id']) or empty($_GET['file'])) {
        die('Nie podano informacji o pliku');
    }
    $post_id = $_GET['post_id'];
    $service_id=(int)$_GET['service_id'];

	$allowed_services_id=$fast_micro_pay->get_post_services($post_id);
	$filename = trim(base64_decode(trim($fast_micro_pay->decrypt($_GET['file'], AUTH_SALT))));
    if (empty($service_id) or ! in_array($service_id, $allowed_services_id) or $service_id != $_GET['service_id']) {
        die('Nieprawidlowe informacje o pliku');
    }
	foreach($allowed_services_id AS $service_id)
	{
		if($fast_micro_pay_content->is_service_unlocked($service_id, @(int) $fast_micro_pay->options['services'][(int) $service_id]['expiration_time'])) {
			$unlocked=true;
			break;
		}
	}

    if ( !$unlocked AND ! $fast_micro_pay_content->is_post_unlocked($post_id, @(int) $fast_micro_pay->options['services'][(int) $service_id]['expiration_time'])) {
        die('Nie masz dostepu do pliku');
    }

    $content = get_post_field('post_content', $post_id);
    $content_normal = $content;
    $content_normal = str_replace('&#8221;', '"', $content_normal);
    $content_normal = str_replace('&#8243;', '"', $content_normal);

    preg_match_all('/\[DOWNLOAD file="([^"]+)" name="([^"]+)"\]/i', $content_normal, $match);

    if (!in_array($filename, $match[1])) {
        die('Nie mozna odblokowac pliku');
    }
    $filename = ltrim($filename, '/');
    // die($filename);
    if (!file_exists('../../../../'.$filename)) {
        die('Plik nie istnieje');
    }
    $fast_micro_pay_download->download($filename);
}
