<?php
include_once(FMP_PLUGIN_PATH . 'vendor/ClickMeetingRestClient.php');

class FastMicroPayGetResponse
{

    private $room=null;
    public function __construct($fast_micro_pay_content)
    {
		$this->fast_micro_pay_content=$fast_micro_pay_content;
        if($this->fast_micro_pay_content->core->is_license_active())
        {
            add_filter('the_content', array($this, 'content'));
        }
    }



	public function content($content)
	{

		global $post;
        $content_normal=$content;
        $content_normal=str_replace('&#8221;','"', $content_normal);
        $content_normal=str_replace('&#8243;','"', $content_normal);
		$unlocked=false;
//var_dump(preg_match('/\[GETRESPONSE api_key="([0-9a-z]+)" campaign_id="([0-9a-z]+)"\]/i', $content_normal, $match));exit;
//		$service_id = get_post_meta($post->ID, 'fmp_service_id', true);

		$allowed_services_id=$this->fast_micro_pay_content->core->get_post_services($post->ID);
		foreach($allowed_services_id AS $service_id)
		{
			if($this->fast_micro_pay_content->is_service_unlocked($service_id, @(int) $this->fast_micro_pay_content->core->options['services'][(int) $service_id]['expiration_time'])) {
				$unlocked=true;
				break;
			}
		}
		if (preg_match('/\[GETRESPONSE api_key="([0-9a-z]+)" token="([0-9a-z]+)"\]/i', $content_normal, $match) AND ($unlocked OR $this->fast_micro_pay_content->is_post_unlocked($post->ID, @(int) $this->fast_micro_pay_content->core->options['services'][(int) $service_id]['expiration_time']))) {
			$service=$this->fast_micro_pay_content->core->options['services'][(int)$service_id];
			$api_key=$match[1];
            $token=$match[2];

            //$this->room=array('url'=>$url, 'name'=>$name, 'time'=>$time);

			$code=false;
			if( ! empty($_COOKIE['fast_micro_pay_post_'.$post->ID]))
			{
				$cookie=$this->fast_micro_pay_content->sms_decrypt_cookie($_COOKIE['fast_micro_pay_post_'.$post->ID]);
				$cookie = explode('//', $cookie);
				if( ! empty($cookie[2]))
				{
					$code=$cookie[2];
				}
			}

			if($code AND substr_count($code,'@')>0)
			{
				$log_info=' ['.$token.'] ('.$code.')';
				$submit=$this->subscribe($code, $api_key, $token);
				$submitData=json_decode((string)@$submit, true);
				if($submit === true)
				{
					FastMicroPayLog::save($service_id, $post->ID, 'gr-success', 'Zapisano do kampanii' . $log_info);
				}
				elseif(empty($submitData['code']))
				{
					FastMicroPayLog::save($service_id, $post->ID, 'gr-error', 'Nieznany błąd' . $log_info);
				}
				elseif((int)$submitData['code']==1001)
				{
					FastMicroPayLog::save($service_id, $post->ID, 'gr-error', 'Nieprawidłowy token kampanii' . $log_info);
				}
				elseif((int)$submitData['code']==1014)
				{
					FastMicroPayLog::save($service_id, $post->ID, 'gr-error', 'Nieprawidłowy klucz API' . $log_info);
				}
				elseif((int)$submitData['code']!=1008)
				{
					FastMicroPayLog::save($service_id, $post->ID, 'gr-error', 'Nieznany status' . $log_info. ' ' . (string)@$submitData['message']);
				}
			}

			$content=preg_replace('/\[GETRESPONSE([^\]]+)\]/i',$replace, $content);
		}
		return $content;
	}

	private function subscribe($code, $api_key, $token)
	{
		$headers=array(
			'Content-Type: application/json',
			'X-Auth-Token: api-key ' . $api_key
		);
		$body=array(
			'email'=>$code,
			'campaign'=>array(
				"campaignId"=>$token
			)
		);
		$body=json_encode($body);
		$ch = curl_init("https://api.getresponse.com/v3/contacts");
		curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$output = @curl_exec($ch);
		$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
//		var_dump($httpcode);
		if($httpcode==202 or $httpcode==200)
		{
			return true;
		}
		curl_close($ch);
		return $output;
	}
}
?>
