<?php

class FastMicroPayContent
{
    protected $provider = null;

    public function __construct($core)
    {
        $this->core = $core;
        add_action('wp_enqueue_scripts', array($this, 'enqueue_media'));
        add_action('wp_head', array($this, 'content_js'));
    }

    public function is_cache_enable()
    {
        if (constant('WP_CACHE') == true or function_exists('w3tc_pgcache_flush_post') or function_exists('clear_post_supercache') or !empty($GLOBALS['zencache']->options['enable'])) {
            return true;
        }

        return false;
    }

    public function generate_url($post_id)
    {
        if ($this->is_cache_enable()) {
            $link = get_permalink($post_id);
            $link = $link.((substr_count($link, '?') > 0) ? '&' : '?').'fast_micro_pay_cache='.md5(rand(1, 99999999999999));

            return $link;
        }

        return get_permalink($post_id);
    }

    public static function sms_encrypt_cookie($value)
    {
        $fast_micro_pay=new FastMicroPay();
        return base64_encode($fast_micro_pay->encrypt($value, AUTH_SALT));
    }

    public static function sms_decrypt_cookie($value)
    {
        $fast_micro_pay=new FastMicroPay();
        return trim($fast_micro_pay->decrypt(@base64_decode($value), AUTH_SALT));
    }

    public function demo_notification($content)
    {
        if ($this->core->check_type('demo')) {
            $content = preg_replace('/\[FMP\]/Us', '<span style="display:block; width:100%;padding:10px; border:1px solid red; background-color:white; color:#1a1a1a; font-size:12px; text-align:center;">Demo wtyczki <a style="font-size:12px; font-weight:bold" target="_blank" href="http://pracabezszefa.pl/szkolenia/fast-miropay-wtyczka-wordpress-do-platnosci-online-i-sms-premium">Fast Micro Pay</a></span>[FMP]', $content);
        }

        return $content;
    }

    public function premium($content)
    {
        global $post;
        $mode='single';
        if ($this->core->is_license_active() == true) {
            $service_id = get_post_meta($post->ID, 'fmp_service_id', true);
            $set_id = get_post_meta($post->ID, 'fmp_set_id', true);
            $service_id_array=array();
            $multiple_info_box=array();

            if (!empty($service_id) and !empty($this->core->options['services'][(int) $service_id]['status'])) {
                $service_id_array[]=(int) $service_id;
            }

            if (!empty($set_id) and !empty($this->core->options['sets'][(int) $set_id]['status']) and !empty($this->core->options['sets'][(int) $set_id]['service_id'])) {
                $service_id_array=array();
                foreach ($this->core->options['sets'][(int) $set_id]['service_id'] as $service_id_temp) {
                    if (! empty($this->core->options['services'][(int) $service_id_temp]['status'])) {
                        $service_id_array[]=(int) $service_id_temp;
                    }
                }
                $mode='multiple';
            }


            if (! empty($service_id_array)) {
                foreach ($service_id_array as $service_id) {
                    $service = $this->core->options['services'][(int) $service_id];
                    if ((empty($service['collective']) and self::is_post_unlocked($post->ID, @(int) $service['expiration_time']) == true) or (!empty($service['collective']) and self::is_service_unlocked($service_id, @(int) $service['expiration_time']) == true)) {
                        if (function_exists('w3tc_pgcache_flush_post')) {
                            w3tc_pgcache_flush_post($post->ID);
                        }
                        if (function_exists('clear_post_supercache')) {
                            clear_post_supercache($post->ID);
                        }

                        return self::show_protected_content($content);
                    }
                    $provider = new $this->core->providers[$service['provider']]['class']();
                    if (count($service_id_array)==1) {
                        return self::show_info_box($content, $provider->generate_info_box($post->ID, $service_id, $service), $post->ID, $service_id, $service);
                    } else {
                        $multiple_info_box[]=array('service_id' => $service_id ,'header'=>@$service['service_header'],'provider'=>@$service['provider'], 'content' =>  self::generate_info_box($provider->generate_info_box($post->ID, $service_id, $service), $post->ID, $service_id));
                    }
                }
                return self::show_multiple_info_box($content, $multiple_info_box, $post->ID, $set_id, $this->core->options['sets'][(int) $set_id]);
            } else {
                return self::remove_tags($content);
            }
        } else {
            return self::remove_tags($content);
        }

        return $content;
    }


    public function render_post_protect_box($content)
    {
        if ($this->core->is_license_active() == true and preg_match('/\[FMP ID=([0-9]+)\]/i', $content, $m)) {
            $post_id=$m[1];
            $service_id = get_post_meta($post_id, 'fmp_service_id', true);
            $set_id = get_post_meta($post_id, 'fmp_set_id', true);
            $service_id_array=array();
            $multiple_info_box=array();

            if (!empty($service_id) and !empty($this->core->options['services'][(int) $service_id]['status'])) {
                $service_id_array[]=(int) $service_id;
            }
            if (!empty($set_id) and !empty($this->core->options['sets'][(int) $set_id]['status']) and !empty($this->core->options['sets'][(int) $set_id]['service_id'])) {
                $service_id_array=array();
                foreach ($this->core->options['sets'][(int) $set_id]['service_id'] as $service_id_temp) {
                    if (! empty($this->core->options['services'][(int) $service_id_temp]['status'])) {
                        $service_id_array[]=(int) $service_id_temp;
                    }
                }
            }
            if (! empty($service_id_array)) {
                foreach ($service_id_array as $service_id) {
                    $service = $this->core->options['services'][(int) $service_id];
                    $provider = new $this->core->providers[$service['provider']]['class']();
                    // var_dump($provider);
                    if (count($service_id_array)==1) {
                        $content = self::show_info_box($content, $provider->generate_info_box($post_id, $service_id, $service), $post_id, $service_id, $service);
                    } else {
                        $multiple_info_box[]=array('service_id' => $service_id ,'header'=>@$service['service_header'], 'content' =>  self::generate_info_box($provider->generate_info_box($post_id, $service_id, $service), $post_id, $service_id));
                    }
                }
                if (!empty($multiple_info_box)) {
                    $content = self::show_multiple_info_box($content, $multiple_info_box, $post_id, $set_id, $this->core->options['sets'][(int) $set_id]);
                }
            }
        } else {
            $content = preg_replace('/\[FMP ID=[0-9]+\]/i', '', $content);
        }

        if (preg_match('/\[FMP ID=[0-9]+\]/i', $content)) {
            return self::render_post_protect_box($content);
        }

        return $content;
    }

    public static function is_post_unlocked($post_id, $expiration_time)
    {
        $cookie = self::check_cookie('post', $post_id);
        if (is_array($cookie)) {
            $used_code = self::check_used_code_db('post', $cookie[2], $post_id, $expiration_time);
            if (!empty($used_code)) {
                return true;
            }

            return false;
        }

        return false;
    }

    public static function is_service_unlocked($service_id, $expiration_time)
    {
        $cookie = self::check_cookie('service', $service_id);
        if (is_array($cookie)) {
            $used_code = self::check_used_code_db('service', $cookie[2], $service_id, $expiration_time);
            if (!empty($used_code)) {
                return true;
            }

            return false;
        }

        return false;
    }

    public static function check_cookie($type, $id)
    {
        if (!isset($_COOKIE['fast_micro_pay_'.$type.'_'.$id])) {
            return false;
        }
        $cookie = self::sms_decrypt_cookie($_COOKIE['fast_micro_pay_'.$type.'_'.$id]);
        $cookie = explode('//', $cookie);

        if (count($cookie) == 3 and $cookie[0] == $id and $cookie[1] == 'OK' and ((strlen($cookie[2]) <= 8 and strlen($cookie[2])>=4) or filter_var($cookie[2], FILTER_VALIDATE_EMAIL) !== false)) {
            return $cookie;
        }

        return false;
    }

    public function unlock_post_cookie($code, $post_id, $expiration_time)
    {
        setcookie('fast_micro_pay_post_'.$post_id, self::sms_encrypt_cookie($post_id.'//OK//'.$code), time() + $expiration_time * 24 * 60 * 60, '/');
    }

    public function unlock_service_cookie($code, $service_id, $expiration_time)
    {
        setcookie('fast_micro_pay_service_'.$service_id, self::sms_encrypt_cookie($service_id.'//OK//'.$code), time() + $expiration_time * 24 * 60 * 60, '/');
    }

    public static function show_protected_content($content)
    {
        if (!defined('DONOTCACHEPAGE')) {
            define('DONOTCACHEPAGE', 1);
        }

        return preg_replace('/\[FMP\](.*)\[\/FMP\]/Us', '<span id="fmp-premium-content"></span>$1', $content);
    }

    public static function generate_info_box($info_box, $post_id, $service_id)
    {
        $box = '<div class="fmp-protect-box" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'"><div class="fmp-loader"></div><div class="fmp-status" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'"></div>'.$info_box.'</div>';
        return $box;
    }

    public static function show_info_box($content, $info_box, $post_id, $service_id, $service)
    {
        $content = preg_replace('/\[FMP\](.*)\[\/FMP\]/Us', self::generate_info_box($info_box, $post_id, $service_id), $content, 1);
        $content = preg_replace('/\[FMP\](.*)\[\/FMP\]/Us', @$service['info_box_second'], $content);

        $content = preg_replace('/\[FMP ID='.$post_id.'\]/i', self::generate_info_box($info_box, $post_id, $service_id), $content, 1);
        $content = preg_replace('/\[FMP ID='.$post_id.'\]/i', @$service['info_box_second'], $content);
        return $content;
    }

    public static function show_multiple_info_box($content, $multiple_info_box, $post_id, $set_id, $set)
    {
        $box_header='';
        $box_content='';
        foreach ($multiple_info_box as $v) {
//        	var_dump($v);
            $box_header.='<div class="fmp-label-item" data-post-id="'.$post_id.'" data-service-id="'.$v['service_id'].'" data-provider="'.$v['provider'].'">' . $v['header'] . '</div>';
            $box_content.='<div class="fmp-box-item" data-post-id="'.$post_id.'" data-service-id="'.$v['service_id'].'" data-provider="'.$v['provider'].'">' . $v['content'] . '</div>';
        }
        $html='
        <div id="fmp-set-container" class="fmp-set-container" data-set-id="'.$set_id.'" data-post-id="'.$post_id.'" data-mode="start">
            <div class="fmp-set-info">
            '. @$set['info_box'] .'
            </div>
            <div class="fmp-set-unlock-container">
                <div class="fmp-set-status"></div>
                <div class="fmp-set-question">
                    <span class="fmp-set-unlock">Zaloguj się</span>
                    lub
                    <span class="fmp-set-buy">Wykup</span>
                </div>
                <div class="fmp-set-code-container">
                    <input type="text" class="fmp-set-code" placeholder="Podaj email lub kod">
                    <span class="fmp-set-submit">Sprawdź</span>
                    <span class="fmp-set-buy">Wykup</span>
                </div>
                <div class="fmp-set-cancel-container">
                    <span class="fmp-set-cancel">Anuluj</span>
                </div>
            </div>
            <div class="fmp-set-buy-container">
                <div class="fmp-set-labels">
                ' . $box_header. '
                </div>
                <div class="fmp-set-box">
                ' . $box_content. '
                </div>
                <div class="fmp-set-cancel-container">
                    <span class="fmp-set-cancel">Anuluj</span>
                </div>
            </div>
        </div>
        ';
        $content = preg_replace('/\[FMP\](.*)\[\/FMP\]/Us', $html, $content, 1);
        $content = preg_replace('/\[FMP\](.*)\[\/FMP\]/Us', @$set['info_box_second'], $content);


        $content = preg_replace('/\[FMP ID='.$post_id.'\]/i', $html, $content, 1);
        $content = preg_replace('/\[FMP ID='.$post_id.'\]/i', @$set['info_box_second'], $content);






        $content = preg_replace('/\[FMP\](.*)\[\/FMP\]/Us', $html, $content, 1);

        return $content;
    }

    public static function show_blank_box($content)
    {
        return preg_replace('/\[FMP\](.*)\[\/FMP\]/Us', '', $content);
    }

    public static function remove_tags($content)
    {
        return preg_replace('/\[FMP\](.*)\[\/FMP\]/Us', '$1', $content);
    }

    public static function remove_deprecated_tags($content)
    {
        return preg_replace('/<divfmp class="premium-content">(.*)<\/divfmp>/Us', '$1', $content);
    }

    public static function check_used_code_db($type, $sms_code, $id, $expiration_time)
    {
        global $table_prefix;
        global $wpdb;

        $code = $wpdb->get_results($wpdb->prepare('SELECT * FROM ' . $wpdb->prefix . 'fast_micro_pay_codes WHERE code LIKE %s AND ' . $type. '_id = %d AND paid_at is not null AND created_at > "' . date('Y-m-d H:i:s', (current_time('timestamp') - (int) $expiration_time * 24 * 60 * 60)) . '"  ORDER BY created_at DESC LIMIT 1', array($sms_code, $id)), OBJECT);
        if (count($code) == 0) {
            return false;
        }
        return true;

        $code = (array) $code[0];
        if ($code['active'] == 0) {
            return false;
        }

        return true;
    }

    public function ajax_response($data)
    {
        wp_send_json($data);
        die();
    }

    public function ajax_dotpay_urlc()
    {
        if (empty($_POST) or empty($_GET['code_id'])) {
            FastMicroPayLog::save(null, null, 'no-data', 'Weryfikacja z Dotpay.pl');
            die('FAIL');
        }
        $code=FastMicroPayCodes::getOne($_GET['code_id']);
        if (empty($code)) {
            FastMicroPayLog::save(null, null, 'no-code', 'Weryfikacja z Dotpay.pl');
            die('FAIL');
        }

        $service_id = get_post_meta($code['post_id'], 'fmp_service_id', true);
        $set_id = get_post_meta($code['post_id'], 'fmp_set_id', true);
        if (!empty($set_id) and ! empty($this->core->options['sets'][$set_id]['status']) and ! empty($this->core->options['sets'][$set_id]['service_id']) and ! empty($code['service_id']) and in_array((int) $code['service_id'], $this->core->options['sets'][$set_id]['service_id'])) {
            $service_id=(int) $code['service_id'];
        }

        if (get_post_status((int) $code['post_id']) === false
        or empty($service_id)
        or $service_id != $code['service_id']
        or empty($this->core->options['services'][(int) $code['service_id']])
        or $this->core->options['services'][(int) $code['service_id']]['provider'] != 'dotpay-transfer') {
            FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'no-service', 'Weryfikacja z Dotpay.pl');
            die('FAIL');
        }

        $provider = new FastMicroPayProviderDotpayTransfer();
        $service = $this->core->options['services'][(int) $service_id];
        $signature = $provider->signature($_POST, (string) @$this->core->options['services'][(int) $service_id]['pin']);

        if (empty($_POST['signature']) or $signature != $_POST['signature'] or empty($_POST['control']) or $_POST['control']!=$code['id']) {
            FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'abnormal', 'Weryfikacja z Dotpay.pl - Błąd sygnatury');
            die('FAIL');
        }

        if ((float) $_POST['operation_amount'] != (float) $_POST['operation_original_amount'] or (float) $_POST['operation_amount'] != (float) $code['price']) {
            FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'abnormal', 'Weryfikacja z Dotpay.pl ['.$_POST['operation_number'].'] - Błąd kwoty ('.$_POST['operation_original_amount'].' - '.$_POST['operation_amount'].' - '.$code['price'].') ');
            die('FAIL');
        }


        if ($_POST['operation_status'] == 'completed' and empty($code['paid_at'])) {
            FastMicroPayCodes::update($code['id'], array('transaction'=>$_POST['operation_number']));
            FastMicroPayCodes::pay($code['id']);
            $paid=true;
        }

        if ($paid and !empty($code['promo_id'])) {
            FastMicroPayPromos::usePromo($code['promo_id']);
        }
        FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'dotpay-'.$_POST['operation_status'], 'Weryfikacja z Dotpay.pl ['.$_POST['operation_number'].'] ('.$code['code'].') ');

        $user_info=json_decode($code['user_info'], true);
        if (! empty($service['ga_id']) and ! empty($user_info['ga_client_id']) and ! empty($paid)) {
            $this->report_ga($service, (int)$code['post_id'], get_the_title((int)$code['post_id']), $code['id'] . '-' . $_POST['operation_number'], $user_info['ga_client_id'], (float)$code['price']);
        }

        if (!empty($service['email_title']) and !empty($service['email_body']) and $paid) {
            if ($this->send_email($service, $code['code'], $code['price'], get_permalink((int) @$code['post_id']))) {
                FastMicroPayLog::save((int) $code['service_id'], (int) $code['post_id'], 'email-sent', $code['code']);
            } else {
                FastMicroPayLog::save((int) $code['service_id'], (int) $code['post_id'], 'email-not-sent', $code['code']);
            }
        }
        die('OK');
    }

    public function ajax_payu()
    {
        $response = @file_get_contents('php://input');
        $response_json = @json_decode($response, true);

        if (empty($_GET['code_id']) or empty($_SERVER['HTTP_OPENPAYU_SIGNATURE']) or empty($response_json)) {
            FastMicroPayLog::save(null, null, 'no-data', 'Weryfikacja z PayU');
            http_response_code(404);
            die();
        }
        $code=FastMicroPayCodes::getOne($_GET['code_id']);
        if (empty($code)) {
            FastMicroPayLog::save(null, null, 'no-code', 'Weryfikacja z PayU');
            die('FAIL');
        }

        $service_id = get_post_meta($code['post_id'], 'fmp_service_id', true);
        $set_id = get_post_meta($code['post_id'], 'fmp_set_id', true);

        if (!empty($set_id) and ! empty($this->core->options['sets'][$set_id]['status']) and ! empty($this->core->options['sets'][$set_id]['service_id']) and ! empty($code['service_id']) and in_array((int) $code['service_id'], $this->core->options['sets'][$set_id]['service_id'])) {
            $service_id=(int) $code['service_id'];
        }

        if (get_post_status((int) $code['post_id']) === false
        or empty($service_id)
        or $service_id != $code['service_id']
        or empty($this->core->options['services'][(int) $code['service_id']])
        or $this->core->options['services'][(int) $code['service_id']]['provider'] != 'payu') {
            FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'no-service', 'Weryfikacja z PayU');
            http_response_code(404);
            die();
        }

        $signature = '';
        $algorithm = 'MD5';
        if (preg_match('/signature=([^;]+);/', $_SERVER['HTTP_OPENPAYU_SIGNATURE'], $m)) {
            $signature = $m[1];
        }
        if (preg_match('/algorithm=([^;]+);/', $_SERVER['HTTP_OPENPAYU_SIGNATURE'], $m)) {
            $algorithm = strtoupper($m[1]);
        }

        $service = $this->core->options['services'][(int) $code['service_id']];
        $provider = new FastMicroPayProviderPayU();
        $generated_signature = $provider->generate_hash($response.$service['pin'], $algorithm);

        if ($signature != $generated_signature) {
            FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'abnormal', 'Weryfikacja z PayU.pl - Błąd sygnatury');
            http_response_code(404);
            die();
        }

        if (empty($response_json['properties'][0]['value']) or empty($response_json['order']['status']) or empty($response_json['order']['extOrderId'])  or empty($response_json['order']['totalAmount'])) {
            FastMicroPayLog::save((int) $code['service_id'], (int) $code['post_id'], 'abnormal', 'Weryfikacja z PayU.pl - Błąd danych');
            http_response_code(404);
            die();
        }

        $payment_id = $response_json['properties'][0]['value'];
        if ($response_json['order']['totalAmount']<$code['price'] * 100) {
            FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'abnormal', 'Weryfikacja z PayU.pl - Błąd kwoty ['.$payment_id.'] ('.$code['price']);
            http_response_code(404);
            die();
        }

        $order_status = $response_json['order']['status'];

        if ($order_status == 'COMPLETED' and empty($code['paid_at'])) {
            FastMicroPayCodes::update($code['id'], array('transaction'=>$payment_id));
            FastMicroPayCodes::pay($code['id']);
            $paid=true;
        }

        if ($paid and !empty($code['promo_id'])) {
            FastMicroPayPromos::usePromo($code['promo_id']);
        }

        if (in_array($order_status, array('COMPLETED', 'CANCELED', 'REJECTED'))) {
            FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'payu-'.$order_status, 'Weryfikacja z PayU ['.$payment_id.'] ('.$code['code'].') ');
        }

        $user_info=json_decode($code['user_info'], true);
        if (! empty($service['ga_id']) and ! empty($user_info['ga_client_id']) and ! empty($paid)) {
            $this->report_ga($service, (int)$code['post_id'], get_the_title((int)$code['post_id']), $code['id'] . '-' . $payment_id, $user_info['ga_client_id'], (float)$code['price']);
        }

        if (!empty($service['email_title']) and !empty($service['email_body']) and $paid) {
            if ($this->send_email($service, $code['code'], $code['price'], get_permalink((int) @$code['post_id']))) {
                FastMicroPayLog::save((int) $code['service_id'], (int) $code['post_id'], 'email-sent', $code['code']);
            } else {
                FastMicroPayLog::save((int) $code['service_id'], (int) $code['post_id'], 'email-not-sent', $code['code']);
            }
        }
        die();
    }

    public function ajax_tpay()
    {
        $ip_table = array('195.149.229.109', '148.251.96.163', '178.32.201.77', '46.248.167.59', '46.29.19.106');
        if (in_array($ip_table, FastMicroPayProviderTpayOnline::user_ip())) {
            FastMicroPayLog::save((int) null, null, 'invalid-response-host', 'Weryfikacja z Tpay');
            die('FALSE');
        }

        if (empty($_GET['code_id']) or empty($_POST['id']) or empty($_POST['tr_id']) or empty($_POST['tr_crc']) or empty($_POST['tr_paid']) or empty($_POST['tr_amount']) or empty($_POST['tr_status']) or empty($_POST['tr_desc'])
            or empty($_POST['tr_email']) or empty($_POST['md5sum'])) {
            FastMicroPayLog::save(null, null, 'no-data', 'Weryfikacja z Tpay');
            die('FALSE');
        }

        $code=FastMicroPayCodes::getOne($_GET['code_id']);
        if (empty($code)) {
            FastMicroPayLog::save(null, null, 'no-code', 'Weryfikacja z PayU');
            die('FALSE');
        }

        $service_id = get_post_meta($code['post_id'], 'fmp_service_id', true);
        $set_id = get_post_meta($code['post_id'], 'fmp_set_id', true);

        if (!empty($set_id) and ! empty($this->core->options['sets'][$set_id]['status']) and ! empty($this->core->options['sets'][$set_id]['service_id']) and ! empty($code['service_id']) and in_array((int) $code['service_id'], $this->core->options['sets'][$set_id]['service_id'])) {
            $service_id=(int) $code['service_id'];
        }



        if (get_post_status((int) $code['post_id']) === false
            or empty($service_id)
            or $service_id != $code['service_id']
            or empty($this->core->options['services'][(int) $code['service_id']])
            or $this->core->options['services'][(int) $code['service_id']]['provider'] != 'tpay-online') {
            FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'no-service', 'Weryfikacja z TPay');
            die('TRUE');
        }


        $service = $this->core->options['services'][(int) $code['service_id']];
        $provider = new FastMicroPayProviderTpayOnline();

        $generated_md5sum = $provider->generate_md5sum_transaction($_POST, $service['key']);

        if ($_POST['md5sum'] != $generated_md5sum) {
            FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'abnormal', 'Weryfikacja z Tpay - Błąd sumy kontrolnej');
            die('TRUE');
        }

        if ($_POST['tr_amount']!=$code['price']) {
            FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'abnormal', 'Weryfikacja z Tpay ['.$_POST['tr_id'].'] - Błąd kwoty ('.$_POST['tr_amount'].' - '.$code['price'].') ');
            die('TRUE');
        }

        $order_crc=$_POST['tr_crc'];
        $payment_id = $_POST['tr_id'];
        $order_status = $_POST['tr_status'];


        if ($order_status == 'TRUE' and empty($code['paid_at'])) {
            FastMicroPayCodes::update($code['id'], array('transaction'=>$payment_id));
            FastMicroPayCodes::pay($code['id']);
            $paid=true;
        }

        if ($paid and !empty($code['promo_id'])) {
            FastMicroPayPromos::usePromo($code['promo_id']);
        }

        if (in_array($order_status, array('TRUE', 'FALSE'))) {
            FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'tpay-'.$order_status, 'Weryfikacja z Tpay ['.$payment_id.'] ('.$code['code'].') ');
        }


        if (!empty($service['email_title']) and !empty($service['email_body']) and $paid) {
            if ($this->send_email($service, $code['code'], $code['price'], get_permalink((int) @$code['post_id']))) {
                FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'email-sent', $code['code']);
            } else {
                FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'email-not-sent', $code['code']);
            }
        }
        die('TRUE');
    }

    public function ajax_przelewy24()
    {
        // $ip_table = array('91.216.191.181', '91.216.191.182', '91.216.191.183', '91.216.191.184', '91.216.191.185');
        // if (in_array($ip_table, FastMicroPayProviderPrzelewy24::user_ip())) {
        //     FastMicroPayLog::save((int) null, null, 'invalid-response-host', 'Weryfikacja z Przelewy24');
        //     die('FALSE');
        // }

        if (empty($_GET['code_id']) or empty($_POST['p24_pos_id']) or empty($_POST['p24_session_id']) or empty($_POST['p24_amount']) or empty($_POST['p24_currency']) or empty($_POST['p24_order_id']) or empty($_POST['p24_method']) or empty($_POST['p24_statement']) or empty($_POST['p24_sign'])) {
            FastMicroPayLog::save(null, null, 'no-data', 'Weryfikacja z Przelewy24');
            die('FALSE');
        }

        $code=FastMicroPayCodes::getOne($_GET['code_id']);
        if (empty($code)) {
            FastMicroPayLog::save(null, null, 'no-code', 'Weryfikacja z Przelewy24');
            die('FALSE');
        }

        $service_id = get_post_meta($code['post_id'], 'fmp_service_id', true);
        $set_id = get_post_meta($code['post_id'], 'fmp_set_id', true);

        if (!empty($set_id) and ! empty($this->core->options['sets'][$set_id]['status']) and ! empty($this->core->options['sets'][$set_id]['service_id']) and ! empty($code['service_id']) and in_array((int) $code['service_id'], $this->core->options['sets'][$set_id]['service_id'])) {
            $service_id=(int) $code['service_id'];
        }



        if (get_post_status((int) $code['post_id']) === false
            or empty($service_id)
            or $service_id != $code['service_id']
            or empty($this->core->options['services'][(int) $code['service_id']])
            or $this->core->options['services'][(int) $code['service_id']]['provider'] != 'przelewy24') {
            FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'no-service', 'Weryfikacja z Przelewy24');
            die('TRUE');
        }


        $service = $this->core->options['services'][(int) $code['service_id']];
        $provider = new FastMicroPayProviderPrzelewy24();

        $generated_sign = $provider->generate_verification_signature($_POST, $service['crc']);

        if ($_POST['p24_sign'] != $generated_sign) {
            FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'abnormal', 'Weryfikacja z Przelewy24 - Błąd sumy kontrolnej');
            die('FALSE');
        }

        if ((int)$_POST['p24_amount']!==(int)round((float) $code['price'] * 100)) {
            FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'abnormal', 'Weryfikacja z Przelewy24 ['.$_POST['p24_order_id'].'] - Błąd kwoty ('.(float)((int)$_POST['p24_amount'] / 100).' - '.(float)$code['price'].') ');
            die('FALSE');
        }

        $verification=$provider->verify($_POST, (($service['environment']=='test') ? true : false));
//        file_put_contents("dump2.txt", var_export($verification, true));
        if ($verification===null) {
            FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'przelewy24-verification', 'Błąd wysłania danych Przelewy24 ['.$_POST['p24_order_id'].' / '.$_POST['p24_statement'].']');
            die('FALSE');
        }
        if ($verification['error'] != '0') {
            FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'przelewy24-verification', 'Błąd wysłania danych Przelewy24 ('.$verification['error'].' '.$verification['message'].') ['.$_POST['p24_order_id'].' / '.$_POST['p24_statement'].']');
            die('FALSE');
        }


        $payment_id = (int)$_POST['p24_order_id'];


        if (empty($code['paid_at'])) {
            FastMicroPayCodes::update($code['id'], array('transaction'=>$payment_id));
            FastMicroPayCodes::pay($code['id']);
            $paid=true;
        }

        if ($paid and !empty($code['promo_id'])) {
            FastMicroPayPromos::usePromo($code['promo_id']);
        }
        FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'przelewy24-verified', 'Weryfikacja z Przelewy24 ['.$payment_id.' / '.$_POST['p24_statement'].'] ('.$code['code'].') ');



        if (!empty($service['email_title']) and !empty($service['email_body']) and $paid) {
            if ($this->send_email($service, $code['code'], $code['price'], get_permalink((int) @$code['post_id']))) {
                FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'email-sent', $code['code']);
            } else {
                FastMicroPayLog::save((int) @$code['service_id'], (int) @$code['post_id'], 'email-not-sent', $code['code']);
            }
        }
        die('TRUE');
    }

    public function ajax_unlock_post()
    {
        $user_info=array();
        $ga_client_id=((! empty($_COOKIE['fmp_ga_client_id'])) ? $_COOKIE['fmp_ga_client_id'] : 0);
        // var_dump($_POST);
        $confirm_message="Wykup dostęp do treści za";
        if (empty($_POST)) {
            FastMicroPayLog::save(null, null, 'no-data', '');
            self::ajax_response(array('status' => 'no-data', 'message' => 'Brak danych', 'type' => 'error'));
        }

        if (!preg_match('/[0-9]{1,10}/', $_POST['post_id'])) {
            FastMicroPayLog::save(null, @$_POST['post_id'], 'abnormal', '');
            self::ajax_response(array('status' => 'abnormal', 'message' => 'Nieprawidłowe dane', 'type' => 'error'));
        }

        $service_id = get_post_meta($_POST['post_id'], 'fmp_service_id', true);
        $set_id = get_post_meta($_POST['post_id'], 'fmp_set_id', true);
        if ($set_id and ! empty($this->core->options['sets'][$set_id]['status']) and ! empty($this->core->options['sets'][$set_id]['service_id']) and ! empty($_POST['service_id']) and in_array((int) $_POST['service_id'], $this->core->options['sets'][$set_id]['service_id'])) {
            $service_id=(int) $_POST['service_id'];
        }

        if (empty($service_id)) {
            FastMicroPayLog::save(null, $_POST['post_id'], 'no-content-service', @$_POST['code']);
            self::ajax_response(array('status' => 'no-content-service', 'message' => 'Treść nie wymaga płatności', 'type' => 'error'));
        }

        if (empty($this->core->options['services'][$service_id])) {
            FastMicroPayLog::save($service_id, $_POST['post_id'], 'no-service', @$_POST['code']);
            self::ajax_response(array('status' => 'no-service', 'message' => 'Brak zdefiniowanej usługi', 'type' => 'error'));
        }

        $service = $this->core->options['services'][$service_id];
        if (!empty($service['ga_id']) and ! empty($ga_client_id)) {
            $user_info['ga_client_id']=$ga_client_id;
        }
        
        if ($service['provider'] == 'dotpay-transfer' or $service['provider'] == 'payu' or $service['provider'] == 'tpay-online' or $service['provider'] == 'przelewy24') {
            if (filter_var($_POST['code'], FILTER_VALIDATE_EMAIL) === false) {
                FastMicroPayLog::save(((empty($service_id)) ? null : $service_id), @$_POST['post_id'], 'abnormal', '');
                self::ajax_response(array('status' => 'abnormal', 'message' => 'Nieprawidłowy adres e-mail', 'type' => 'error'));
            }
        } else {
            if (!preg_match('/^[0-9a-zA-Z]+$/', $_POST['code'])) {
                FastMicroPayLog::save(((empty($service_id)) ? null : $service_id), @$_POST['post_id'], 'abnormal', '');
                self::ajax_response(array('status' => 'abnormal', 'message' => 'Nieprawidłowe dane', 'type' => 'error'));
            }
        }



        $provider = new $this->core->providers[$service['provider']]['class']();
        // var_dump($provider);exit;
        if (empty($_POST['periodically']) or $_POST['periodically'] != 'true') {
            $confirm_message='Wykup dostęp do treści za <strong>'.number_format($service['price'], 2).' zł</strong>';
            if (! empty($service['donation'])) {
                $donation_price=floatval(str_replace(',', '.', $_POST['donation']));
                if ($donation_price <= 0) {
                    FastMicroPayLog::save($service_id, $_POST['post_id'], 'wrong-dotation-value', $donation_price);
                    self::ajax_response(array('status' => 'abnormal', 'message' => 'Nieprawidłowa kwota dotacji', 'type' => 'error'));
                } else {
                    $service['price']=$donation_price;
                    $confirm_message='Przekaż <strong>'.number_format($service['price'], 2).' zł</strong>';
                }
            }
            FastMicroPayLog::save($service_id, $_POST['post_id'], 'check-access-db', $_POST['code']);
        }
        if (empty($service['collective'])) {
            $code_db_status = self::check_used_code_db('post', $_POST['code'], $_POST['post_id'], (int) $service['expiration_time']);
        } else {
            $code_db_status = self::check_used_code_db('service', $_POST['code'], $service_id, (int) $service['expiration_time']);
        }

        if ((empty($_POST['periodically']) or $_POST['periodically'] != 'true') and ! empty($service['donation'])) {
            $code_db_status=false;
        }

        if (! $code_db_status) {
            $response          = array();
            $response['email'] = $_POST['code'];
            $response['show_invoice']=false;
            $response['type']='info';
            $response['show_promo']=false;
            $response['promo_valid']=false;
            $response['request_source']=(! empty($_POST['request_source'])) ? $_POST['request_source'] : false;

            $invoice_required_fields = array( 'firstname', 'lastname', 'street', 'street_n1', 'postcode', 'city' );
            $invoice_fields          = array_merge($invoice_required_fields, array( 'street_n2', 'nip' ));

            $details_required = false;
            $details_given    = false;

            if (!empty($service['ga_id']) and !empty($ga_client_id)) {
                $user_info['ga_client_id']=$ga_client_id;
            }

            if (substr_count($service['info_box'], '{promo}') > 0) {
                if (!empty($_POST['promo'])) {
                    $promo=FastMicroPayPromos::getPromo($_POST['promo'], $service_id);
                    if (!empty($promo)) {
                        $confirm_message='Wykup dostęp do treści za <strong>'.number_format($promo['price'], 2).' zł</strong> <strong class="fmp-old-price">'.number_format($service['price'], 2).' zł</strong>';
                        $service['price']=$promo['price'];
                        $response['promo_valid']=true;
                    } else {
                        usleep(600000);
                    }
                }
                $response['show_promo']=true;
            }

            if (substr_count($service['info_box'], '{invoice-info}') > 0) {
                $details_required     = true;
                $details_given        = false;
                $fields_filled        = true;
                $response['finalize'] = false;
                foreach ($invoice_fields as $field) {
                    $invoice_data[ $field ] = (string) @$_POST[ $field ];
                    if (empty($_POST[ $field ]) and in_array($field, $invoice_required_fields)) {
                        $fields_filled = false;
                        break;
                    }
                }
                if ($fields_filled) {
                    $details_given        = true;
                    $user_info            = array_merge($user_info, $invoice_data);
                    $response['redirection'] = true;
                    $response['message']  = 'Przekierowuję do serwisu płatności';
                } else {
                    //		                    $response['dotpay_transfer']=true;
                    $response['redirection'] = false;
                    $response['show_invoice'] = true;
                    $response['message']  = 'Wypełnij dane do przelewu';
                    if (empty($_POST['step']) or $_POST['step'] != 1) {
                        $response['status'] = 'incomplete';
                    }
                }
            } else {
                $response['finalize']=true;
            }
        }





        if ($code_db_status == false and $service['provider'] == 'dotpay-transfer') {
            $response['payment_data']=array(
                'api_version'=>'dev',
                'currency'=>'PLN',
                'lang'=>'pl',
                'id'=>$service['external_id'],
                'description'=>$service['description'],
                'amount'=>$service['price'],
                'URL'=>get_permalink($_POST['post_id']),
                'type'=>0,
                'buttontext'=>'Powrót do ' . $_SERVER['HTTP_HOST'],
                'channel_groups'=>$service['channel_groups'],
                'email'=>$_POST['code'],
            );
            $response['payment_data']['amount']=$service['price'];



            $response['dotpay_transfer']=true;
            usleep(400000);
            //	        var_dump($response);
            if ((empty($_POST['periodically']) or $_POST['periodically'] != 'true') and (! $details_required or $details_given)) {
                FastMicroPayLog::save($service_id, $_POST['post_id'], 'invalid-code-db', $_POST['code']);
                $code_id=FastMicroPayCodes::save((int) $service_id, (int) $_POST['post_id'], $_POST['code'], $service['price'], '', '', ((! empty($service['donation']) ? 1 : 0)));
                //	            $code_id=1;
                $response['payment_data']['URLC']=admin_url('admin-ajax.php?action=fmp_dotpay_urlc&code_id=' . $code_id);
                $response['payment_data']['chk']=$provider->chk($service_id, $_POST['post_id'], $service, $_POST['code'], $code_id);
                $response['payment_data']['control']=$code_id;



                $response['status']='invalid-code';
                $response['type']='info';
                $response['message'] = $confirm_message;
                //	            $response['control']=$code_id;
//	            $response['code_id']=$code_id;
//	            $response['amount']=$service['price'];
//	            $response['urlc']=admin_url('admin-ajax.php?action=fmp_dotpay_urlc&code_id=' . $code_id);
//	            $response['chk'] = $provider->chk($service_id, $_POST['post_id'], $service, $_POST['code'], $code_id);
                //$response=array('status' => 'invalid-code', 'message' => $confirm_message . ' <strong>'.number_format($service['price'], 2).' zł</strong>.', 'type' => 'info', 'dotpay_transfer' => true, 'email' => $_POST['code'], 'control' => $code_id, 'amount' => $service['price'], 'code_id' => $code_id, 'urlc'=>admin_url('admin-ajax.php?action=fmp_dotpay_urlc&code_id=' . $code_id), 'chk' => $provider->chk($service_id, $_POST['post_id'], $service, $_POST['code'], $code_id));
            }
            setcookie('fast_micro_pay_user_email', $_POST['code'], time() + 14 * 24 * 60 * 60, '/');
            setcookie('fast_micro_pay_service_id', $service_id, time() + 14 * 24 * 60 * 60, '/');
            //	        var_dump($response);
            //exit;





//            if(substr_count($service['info_box'], '{invoice-info}')>0)
//            {
//                $fields_filled=TRUE;
//                $response['dotpay_transfer_finalize']=false;
//                foreach($invoice_fields AS $field)
//                {
//                    $invoice_data[$field]=(string)@$_POST[$field];
//                    if(empty($_POST[$field]) AND in_array($field, $invoice_required_fields))
//                    {
//                        $fields_filled=FALSE;
//                        break;
//                    }
//                }
//                if($fields_filled)
//                {
//
            //	                if (empty($_POST['periodically']) or $_POST['periodically'] != 'true') {
            //		                FastMicroPayLog::save($service_id, $_POST['post_id'], 'invalid-code-db', $_POST['code']);
            //		                $code_id=FastMicroPayCodes::save((int) $service_id, (int) $_POST['post_id'], $_POST['code'], $service['price'], '', '', 0);
            //		                $response=array('status' => 'invalid-code', 'message' => $confirm_message . ' <strong>'.number_format($service['price'], 2).' zł</strong>.', 'type' => 'info', 'dotpay_transfer' => true, 'email' => $_POST['code'], 'control' => $code_id, 'amount' => $service['price'], 'code_id' => $code_id, 'urlc'=>admin_url('admin-ajax.php?action=fmp_dotpay_urlc&code_id=' . $code_id), 'chk' => $provider->chk($service_id, $_POST['post_id'], $service, $_POST['code'], $code_id));
            //	                }
//                    $user_info=array_merge($user_info, $invoice_data);
//                    $response['dotpay_transfer_redirect']=true;
//                    $response['message']='Przekierowuję do serwisu płatności';
//                }
//                else
//                {
            //	                $response['dotpay_transfer']=true;
            //	                $response['dotpay_transfer_redirect']=false;
//                    $response['message']='Wypełnij dane do przelewu';
//                    if(empty($_POST['step']) OR $_POST['step'] != 1)
//                    {
//                        $response['status']='incomplete';
//                    }
//                }
//            }
//            else
//            {
            //	            if (empty($_POST['periodically']) or $_POST['periodically'] != 'true') {
            //		            FastMicroPayLog::save($service_id, $_POST['post_id'], 'invalid-code-db', $_POST['code']);
            //		            $code_id=FastMicroPayCodes::save((int) $service_id, (int) $_POST['post_id'], $_POST['code'], $service['price'], '', '', 0);
            //		            $response=array('status' => 'invalid-code', 'message' => $confirm_message . ' <strong>'.number_format($service['price'], 2).' zł</strong>.', 'type' => 'info', 'dotpay_transfer' => true, 'email' => $_POST['code'], 'control' => $code_id, 'amount' => $service['price'], 'code_id' => $code_id, 'urlc'=>admin_url('admin-ajax.php?action=fmp_dotpay_urlc&code_id=' . $code_id), 'chk' => $provider->chk($service_id, $_POST['post_id'], $service, $_POST['code'], $code_id));
            //	            }
//                $response['dotpay_transfer_finalize']=true;
//            }


            if (!empty($user_info) and !empty($code_id)) {
                FastMicroPayCodes::update($code_id, array('user_info'=>json_encode($user_info)));
            }
            if (!empty($promo)) {
                FastMicroPayCodes::update($code_id, array('promo_id'=>$promo['id']));
            }

            self::ajax_response($response);
        } elseif ($code_db_status == false and $service['provider'] == 'payu') {
            $response['payu_transfer']=true;
            usleep(400000);
            if ((empty($_POST['periodically']) or $_POST['periodically'] != 'true') and (! $details_required or $details_given)) {
                FastMicroPayLog::save($service_id, $_POST['post_id'], 'invalid-code-db', $_POST['code']);
                $code_id=FastMicroPayCodes::save((int) $service_id, (int) $_POST['post_id'], $_POST['code'], $service['price'], '', '', ((! empty($service['donation']) ? 1 : 0)));
                //	            $code_id=1;
                $parameters = $provider->generate_parameters((int) $_POST['post_id'], $code_id, $service);
                $parameters['buyer.email'] = $_POST['code'];
                $parameters['extOrderId'] = $code_id . '-' . substr(rand(1000, 999999990), 0, 8);
                $response['payment_data'] = $parameters;
                $response['payment_data']['OpenPayu-Signature']='sender='.$service['external_id'].';algorithm=SHA-512;signature='.$provider->generate_signature($parameters, $service['pin']);
                $response['status']='invalid-code';
                $response['type']='info';
                $response['message'] = $confirm_message;
            }
            setcookie('fast_micro_pay_user_email', $_POST['code'], time() + 14 * 24 * 60 * 60, '/');
            setcookie('fast_micro_pay_service_id', $service_id, time() + 14 * 24 * 60 * 60, '/');

            if (!empty($user_info) and !empty($code_id)) {
                FastMicroPayCodes::update($code_id, array('user_info'=>json_encode($user_info)));
            }
            if (!empty($promo)) {
                FastMicroPayCodes::update($code_id, array('promo_id'=>$promo['id']));
            }

            self::ajax_response($response);
        } elseif ($code_db_status == false and $service['provider'] == 'przelewy24') {
            $response['przelewy24']=true;
//            var_dump($service);
//            var_dump($provider);
//            exit;
            usleep(400000);
            if ((empty($_POST['periodically']) or $_POST['periodically'] != 'true') and (! $details_required or $details_given)) {
                FastMicroPayLog::save($service_id, $_POST['post_id'], 'invalid-code-db', $_POST['code']);
                $code_id=FastMicroPayCodes::save((int) $service_id, (int) $_POST['post_id'], $_POST['code'], $service['price'], '', '', ((! empty($service['donation']) ? 1 : 0)));
                //	            $code_id=1;
                $parameters = $provider->generate_parameters((int) $_POST['post_id'], $code_id, $service);
//            var_dump($parameters);exit;

                $parameters['p24_email'] = $_POST['code'];
                $parameters['p24_sign']=$provider->generate_signature($parameters, $service['crc']);
//                $parameters['extOrderId'] = $code_id . '-' . substr(rand(1000,999999990),0, 8);
                $response['payment_data'] = $parameters;
//                $response['payment_data']['OpenPayu-Signature']='sender='.$service['external_id'].';algorithm=SHA-512;signature='.$provider->generate_signature($parameters, $service['pin']);
                $response['status']='invalid-code';
                $response['type']='info';
                $response['message'] = $confirm_message;
            }
            setcookie('fast_micro_pay_user_email', $_POST['code'], time() + 14 * 24 * 60 * 60, '/');
            setcookie('fast_micro_pay_service_id', $service_id, time() + 14 * 24 * 60 * 60, '/');

            if (!empty($user_info) and !empty($code_id)) {
                FastMicroPayCodes::update($code_id, array('user_info'=>json_encode($user_info)));
            }
            if (!empty($promo)) {
                FastMicroPayCodes::update($code_id, array('promo_id'=>$promo['id']));
            }

            self::ajax_response($response);
        } elseif ($code_db_status == false and $service['provider'] == 'tpay-online') {
            $response['tpay_online']=true;
            usleep(400000);
            if ((empty($_POST['periodically']) or $_POST['periodically'] != 'true') and (! $details_required or $details_given)) {
                FastMicroPayLog::save($service_id, $_POST['post_id'], 'invalid-code-db', $_POST['code']);
                $code_id=FastMicroPayCodes::save((int) $service_id, (int) $_POST['post_id'], $_POST['code'], $service['price'], '', '', ((! empty($service['donation']) ? 1 : 0)));
                //	            $code_id=1;
                $parameters = $provider->generate_parameters((int) $_POST['post_id'], $code_id, $service);
                $parameters = $provider->generate_parameters((int) $_POST['post_id'], $code_id, $service); //UWAGA
                $parameters['email'] = $_POST['code'];
                $parameters['crc'] = $code_id;
                $response['payment_data']=$parameters;
                $response['payment_data']['md5sum']=$provider->generate_md5sum($parameters, $service['key']);
                $response['status']='invalid-code';
                $response['type']='info';
                $response['message'] = $confirm_message;
            }
            setcookie('fast_micro_pay_user_email', $_POST['code'], time() + 14 * 24 * 60 * 60, '/');
            setcookie('fast_micro_pay_service_id', $service_id, time() + 14 * 24 * 60 * 60, '/');

            if (!empty($user_info) and !empty($code_id)) {
                FastMicroPayCodes::update($code_id, array('user_info'=>json_encode($user_info)));
            }
            if (!empty($promo)) {
                FastMicroPayCodes::update($code_id, array('promo_id'=>$promo['id']));
            }

            self::ajax_response($response);
        } elseif ($code_db_status == false and $service['provider'] == 'simpay-sms') {
            FastMicroPayLog::save($service_id, $_POST['post_id'], 'invalid-code-db', $_POST['code']);
            FastMicroPayLog::save($service_id, $_POST['post_id'], 'check-access-external', $_POST['code']);
            $provider->setApi($service['api_key'], $service['api_secret']);
            try {
                $status=$provider->getStatus(array(
                    'service_id' 	=>	$service['external_service'],
                    'number'	=>	$service['external_number'],
                    'code'		=>	trim($_POST['code']),
                ));
                if (empty($status['respond']['status']) or $status['respond']['status'] != 'OK') {
                    FastMicroPayLog::save($service_id, $_POST['post_id'], 'invalid-code-external', $_POST['code'] . ((!empty($status['error'][0]['error_name'])) ? ' - (' . $status['error'][0]['error_name'] . ')' : ''));
                    self::ajax_response(array('status' => 'invalid-code', 'message' => 'Nieprawidłowy kod', 'type' => 'error'));
                }
                $code_id=FastMicroPayCodes::save((int) $service_id, (int) $_POST['post_id'], $_POST['code'], $service['price']);
                FastMicroPayCodes::pay($code_id);
            } catch (Exception $e) {
                FastMicroPayLog::save($service_id, $_POST['post_id'], 'other', $_POST['code'].  ' - (' . $e->getMessage() . ')');
                self::ajax_response(array('status' => 'other', 'message' => 'Wystąpił nieoczekiwany błąd', 'type' => 'error'));
            }
            if (!empty($service['ga_id']) and ! empty($ga_client_id) and ! empty($code_id)) {
                $this->report_ga($service, (int)$_POST['post_id'], get_the_title((int)$_POST['post_id']), $code_id . '-' . $_POST['code'], $ga_client_id, (float)$service['price']);
            }
        } elseif ($code_db_status == false) {
            FastMicroPayLog::save($service_id, $_POST['post_id'], 'invalid-code-db', $_POST['code']);
            FastMicroPayLog::save($service_id, $_POST['post_id'], 'check-access-external', $_POST['code']);
            $external_status = $provider->check_access($service, $_POST['code']);
            //	        $external_status=true;
            if ($external_status == false) {
                FastMicroPayLog::save($service_id, $_POST['post_id'], 'invalid-code-external', $_POST['code']);
                self::ajax_response(array('status' => 'invalid-code', 'message' => 'Nieprawidłowy kod', 'type' => 'error'));
            }
            FastMicroPayLog::save((int) $service_id, (int) $_POST['post_id'], 'valid-code-external', $_POST['code']);
            $code_id=FastMicroPayCodes::save((int) $service_id, (int) $_POST['post_id'], $_POST['code'], $service['price']);
            FastMicroPayCodes::pay($code_id);

            if (!empty($service['ga_id']) and ! empty($ga_client_id) and ! empty($code_id)) {
                $this->report_ga($service, (int)$_POST['post_id'], get_the_title((int)$_POST['post_id']), $code_id . '-' . $_POST['code'], $ga_client_id, (float)$service['price']);
            }
            self::unlock_post_cookie($_POST['code'], $_POST['post_id'], $service['expiration_time']);
            self::unlock_service_cookie($_POST['code'], (int) $service_id, $service['expiration_time']);
            $this->purge_post_cache($_POST['post_id']);
            self::ajax_response(array('status' => 'ok', 'redirect' => get_permalink($_POST['post_id']), 'type' => 'success'));
        }

        // if ($code_db_status == false) {
        //     FastMicroPayLog::save($service_id, $_POST['post_id'], 'check-access-external', $_POST['code']);
        //     $external_status = $provider->check_access($service, $_POST['code']);
        //     if ($external_status == false) {
        //         FastMicroPayLog::save($service_id, $_POST['post_id'], 'invalid-code-external', $_POST['code']);
        //         if ($service['provider'] == 'dotpay-transfer') {
        //             // $transaction=substr(md5(rand(1000,900000000)),0,8);
        //             setcookie('fast_micro_pay_user_email', $_POST['code'], time() + 14 * 24 * 60 * 60, '/');
        //             self::ajax_response(array('status' => 'invalid-code', 'message' => 'Wykup dostęp do treści za <strong>'.number_format($service['price'], 2).'zł</strong>.', 'type' => 'error', 'dotpay_transfer' => true, 'email' => $_POST['code'], 'chk' => $provider->chk($service_id, $_POST['post_id'], $service, $_POST['code'])));
        //         } else {
        //             self::ajax_response(array('status' => 'invalid-code', 'message' => 'Nieprawidłowy kod', 'type' => 'error'));
        //         }
        //     }
        //     FastMicroPayLog::save((int) $service_id, (int) $_POST['post_id'], 'valid-code-external', $_POST['code']);
        //     FastMicroPayCodes::save((int) $service_id, (int) $_POST['post_id'], $_POST['code'], $service['price']);
        //     self::unlock_post_cookie($_POST['code'], $_POST['post_id'], $service['expiration_time']);
        //     self::ajax_response(array('status' => 'ok', 'redirect' => get_permalink($_POST['post_id']), 'type' => 'success'));
        // }
        if (!empty($_POST['periodically']) and $_POST['periodically'] == 'true') {
            FastMicroPayLog::save($service_id, $_POST['post_id'], 'check-access-db', $_POST['code']);
        }
        FastMicroPayLog::save($service_id, $_POST['post_id'], 'valid-code-db', $_POST['code']);

        $response=array('status' => 'ok', 'type' => 'success');
        if (!empty($service['donation'])) {
            $response['donation_message']=((!empty($service['donation_message'])) ? $service['donation_message'] : 'Dziękujemy za złożenie dotacji');
        } else {
            self::unlock_post_cookie($_POST['code'], $_POST['post_id'], $service['expiration_time']);
            self::unlock_service_cookie($_POST['code'], (int) $service_id, $service['expiration_time']);
            $this->purge_post_cache($_POST['post_id']);
            $response['redirect']=$this->generate_url($_POST['post_id']);
        }
        self::ajax_response($response);
    }

    public function ajax_unlock_post_set()
    {
        if (empty($_POST['post_id']) or empty($_POST['set_id']) or empty($_POST['code']) or !preg_match('/[0-9]{1,10}/', $_POST['post_id'], $_POST['set_id']) or (filter_var($_POST['code'], FILTER_VALIDATE_EMAIL) === false and ! preg_match('/^[0-9a-zA-Z]+$/', $_POST['code']))) {
            FastMicroPayLog::save(null, (empty($_POST['post_id']) ? (int)$_POST['post_id'] : null), 'abnormal', '');
            self::ajax_response(array('status' => 'no-data', 'message' => 'Nieprawidłowe dane', 'type' => 'error'));
        }

        // $service_id = get_post_meta($_POST['post_id'], 'fmp_service_id', true);
        $set_id = get_post_meta($_POST['post_id'], 'fmp_set_id', true);
        // if( empty($set_id) OR empty($this->core->options['sets'][$set_id]['status']) OR empty($this->core->options['sets'][$set_id]['service_id']) OR count(array_intersect($this->core->options['sets'][$set_id]['service_id'], array_keys($this->core->options['sets'][$set_id]['service_id'])))==0)
        if (empty($set_id) or empty($this->core->options['sets'][$set_id]['status'])) {
            FastMicroPayLog::save(null, (int)$_POST['post_id'], 'no-set', 'Brak pakietu');
            self::ajax_response(array('status' => 'no-data', 'message' => 'Nieprawidłowe dane', 'type' => 'error'));
        }

        foreach ($this->core->options['sets'][$set_id]['service_id'] as $service_id) {
            if (empty($this->core->options['services'][$service_id])) {
                continue;
            }
            $service=$this->core->options['services'][$service_id];
            if (empty($service['collective'])) {
                $code_db_status = self::check_used_code_db('post', $_POST['code'], $_POST['post_id'], (int) $service['expiration_time']);
            } else {
                $code_db_status = self::check_used_code_db('service', $_POST['code'], $service_id, (int) $service['expiration_time']);
            }
            if ($code_db_status==true) {
                FastMicroPayLog::save($service_id, $_POST['post_id'], 'check-access-db', $_POST['code']);
                FastMicroPayLog::save($service_id, $_POST['post_id'], 'valid-code-db', $_POST['code']);
                self::unlock_post_cookie($_POST['code'], $_POST['post_id'], $service['expiration_time']);
                self::unlock_service_cookie($_POST['code'], (int) $service_id, $service['expiration_time']);
                $this->purge_post_cache($_POST['post_id']);
                self::ajax_response(array('status' => 'ok', 'redirect' => $this->generate_url($_POST['post_id']), 'type' => 'success'));
            }
        }
        usleep(400000);
        FastMicroPayLog::save(null, $_POST['post_id'], 'invalid-code-db-set', $_POST['code']);
        self::ajax_response(array('status' => 'no-access', 'message' => 'Brak dostępu', 'type' => 'error'));
    }




    public function ajax_check_cache()
    {
        if (!empty($_POST['post_id'])) {
            $service_id = get_post_meta((int) $_POST['post_id'], 'fmp_service_id', true);
            if (!empty($service_id) and !empty($this->core->options['services'][(int) $service_id]['status'])) {
                $service = $this->core->options['services'][(int) $service_id];
                if ((empty($service['collective']) and self::is_post_unlocked((int) $_POST['post_id'], @(int) $service['expiration_time']) == true) or (!empty($service['collective']) and self::is_service_unlocked($service_id, @(int) $service['expiration_time']) == true)) {
                    //if (self::is_post_unlocked((int) $_POST['post_id'], @(int) $service['expiration_time']) == true) {
                    self::ajax_response(array('cached' => true, 'redirect' => $this->generate_url($_POST['post_id'])));
                }
            }
        }
        self::ajax_response(array('cached' => false));
    }

    public function purge_post_cache($post_id)
    {
        if (function_exists('w3tc_pgcache_flush_post')) {
            w3tc_pgcache_flush_post((int) $post_id);
        }
        if (function_exists('clear_post_supercache')) {
            clear_post_supercache((int) $post_id);
        }
        if (!empty($GLOBALS['zencache'])) {
            $GLOBALS['zencache']->auto_clear_post_cache((int) $post_id);
        }
    }


    public function report_ga($service, $post_id, $post_title, $transaction_id, $cid, $price)
    {
        $request[1]=array('v'=>1, 't'=>'transaction', 'tid'=>$service['ga_id'], 'cid'=>$cid, 'ti'=>$transaction_id, 'tr'=>$price, 'ts'=> 0, 'tt'=>0);
        $request[2]=array('v'=>1, 't'=>'item', 'tid'=>$service['ga_id'], 'cid'=>$cid, 'ti'=>$transaction_id, 'in'=>$post_title, 'ip'=>$price, 'iq'=>1, 'ic'=>$post_id, iv=>$service['name']);
        
        foreach ($request as $r) {
            //echo 'https://www.google-analytics.com/collect?' . http_build_query($r);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://www.google-analytics.com/collect?' . http_build_query($r));
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_TIMEOUT, 100);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('User-agent:  FMP'));
            curl_exec($ch);
            curl_close($ch);
        }
    }

    public function send_email($service, $email, $price='', $url='')
    {
        $replacements=array(
            '{email}'=>$email,
            '{price}'=>$price,
            '{url}'=>$url,
            '{expiration}'=>date('Y-m-d H:i:s', (current_time('timestamp') + (int) $service['expiration_time'] * 24 * 60 * 60)),
            '{domain}'=>str_replace(array('http://', 'https://'), array('',''), get_site_url()),
        );
        $title=str_replace(array_keys($replacements), array_values($replacements), nl2br($service['email_title']));
        $body =str_replace(array_keys($replacements), array_values($replacements), nl2br($service['email_body']));
        $headers = array('Content-Type: text/html; charset=UTF-8');
        // var_dump($body);exit;
        return wp_mail($email, $title, $body, $headers);
    }

    public function custom_wp_mail_from_name($original_email_from)
    {
        return get_bloginfo('name');
    }

    public function enqueue_media()
    {
        wp_enqueue_style('fast-micro-pay', plugins_url('/css/fast-micro-pay.css', __FILE__), array(), $this->core->get_version());
        wp_enqueue_script('fast-micro-pay', plugins_url('/js/fast-micro-pay.js', __FILE__), array('jquery'), $this->core->get_version());
        wp_localize_script('fast-micro-pay', 'FastMicroPay', array('ajax' => admin_url('admin-ajax.php')));
    }

    public function content_js()
    {
        if (is_singular() and empty($_GET['fast_micro_pay_cache'])) {
            //if (is_singular() AND $this->is_cache_enable() AND empty($_GET['fast_micro_pay_cache'])) {
            $id = get_the_ID();
            if ($id) {
                echo '
<script type="text/javascript">
    jQuery(document).ready(function(){
        fast_micro_pay_check_cache('.$id.');
    })
    var fast_micro_pay_post_id = '.$id.';
</script>
';
            }
        }
    }
}

;
