<?php

class FastMicroPaySetup
{
    public static function install_database()
    {
        global $wpdb;

        $charset_collate = $wpdb->get_charset_collate();

        $sql_1 = "CREATE TABLE ". $wpdb->prefix  ."fast_micro_pay_codes (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(1) unsigned NOT NULL DEFAULT 0,
  `service_id` int(10) DEFAULT NULL,
  `promo_id` int(10) DEFAULT NULL,
  `post_id` int(10) unsigned NOT NULL,
  `code` varchar(128) NOT NULL,
  `transaction` varchar(64) NULL DEFAULT NULL,
  `price` float(5,2) NOT NULL DEFAULT '0.00',
  `user_info` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `paid_at` timestamp  NULL DEFAULT NULL,
  PRIMARY KEY  id (id)
) $charset_collate;";

        $sql_2 = "CREATE TABLE ". $wpdb->prefix  ."fast_micro_pay_log (
`id` int(10) NOT NULL AUTO_INCREMENT,
  `service_id` int(10) DEFAULT NULL,
  `post_id` int(10) DEFAULT NULL,
  `type` varchar(32) NOT NULL,
  `comment` TEXT NOT NULL,
  `ip` varchar(15) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY  id (id)
  ) $charset_collate;";
        $sql_3 = "CREATE TABLE ". $wpdb->prefix  ."fast_micro_pay_clickwebinar (
`id` int(10) NOT NULL AUTO_INCREMENT,
  `room_id` int(10) DEFAULT NULL,
  `code` varchar(128) NOT NULL,
  `token` varchar(32) NOT NULL,
  `ip` varchar(15) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY  id (id)
  ) $charset_collate;";


	    $sql_4 = "CREATE TABLE ". $wpdb->prefix  ."fast_micro_pay_promos (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NULL DEFAULT NULL,
  `promo` varchar(64) NULL DEFAULT NULL,
  `service_id` int(10) DEFAULT NULL,
  `price` float(8,2) NULL DEFAULT NULL,
  `income` float(10,2) NULL DEFAULT 0,
  `max_usage` int(10) NULL DEFAULT NULL,
  `usage_count` int(10) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expires_at` timestamp  NULL DEFAULT NULL,
  PRIMARY KEY  id (id)
) $charset_collate;";

//var_dump($sql_1);
        require_once ABSPATH.'wp-admin/includes/upgrade.php';
        dbDelta($sql_1);
        dbDelta($sql_2);
        dbDelta($sql_3);
        dbDelta($sql_4);
    }

    public static function migrate_1_8()
    {
    	global $wpdb;
		$codes=$wpdb->get_results('SELECT * FROM ' . $wpdb->prefix  . 'fast_micro_pay_codes WHERE paid_at is not null', ARRAY_A);
		if (! empty($codes))
		{
			foreach($codes AS $code)
			{
				$user_info=json_decode($code['user_info'], true);
				if(empty($user_info['migration_1_8']))
				{
					if(!is_array($user_info))
					{
						$user_info=array();
					}
					$user_info['migration_1_8']=true;
					$user_info=json_encode($user_info);
					$wpdb->update($wpdb->prefix  . 'fast_micro_pay_codes', array('user_info'=>$user_info, 'paid_at'=>current_time('mysql')), array('id'=>$code['id']));
				}
			}
		}
    }
}
