<?php

class FastMicroPayProviderDotpayTransfer
{
    public function generate_info_box($post_id, $service_id, $service)
    {
        $parameters=array(
            'api_version'=>'dev',
            'currency'=>'PLN',
            'lang'=>'pl',
            'id'=>$service['external_id'],
            'description'=>$service['description'],
            'amount'=>$service['price'],
            'URL'=>get_permalink($post_id),
            'type'=>0,
            'buttontext'=>'Powrót do ' . $_SERVER['HTTP_HOST'],
            'channel_groups'=>$service['channel_groups'],
        );
        $submit_url='https://ssl.dotpay.pl/t2/';
        if($service['environment']=='test')
        {
            $submit_url='https://ssl.dotpay.pl/test_payment/';
        }
        $template = str_replace('{code}', '<input type="text" class="fmp-code" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'" placeholder="Podaj email" data-type="email">', $service['info_box']);
        for($i=1;$i<=5;$i++)
        {
            if(!empty($service['regulations_text' . (($i==1) ? '' : '_' . $i)]))
            {
                $template.='<span class="fmp-regulations-container"><label class="fmp-regulations-option"><input type="checkbox" value="1"><span>Akceptuj</span></label><span class="fmp-regulations-text"><span>' . $service['regulations_text' . (($i==1) ? '' : '_' . $i)] . '</span></span></span>';
            }
        }
	    $template = str_replace('{submit}', '<span class="fmp-submit" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'">' . ( ! empty($service['button']) ?
        $service['button'] : 'Odblokuj') . '</span>', $template);
	    if(! empty($service['donation']))
        {
            $template = str_replace('{donation}', '<input type="text" class="fmp-donation" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'" placeholder="Podaj kwotę darowizny" value="' . ((empty($service['price'])) ? '' : number_format($service['price'], 2)) . '">', $template);
        }
	    $template = str_replace('{promo}', '<div class="fmp-promo-container"><input type="text" class="fmp-promo" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'" placeholder="Kod rabatowy" value=""><span class="fmp-promo-submit"><span>Sprawdź</span></span></div>', $template);
	    $template = str_replace('{invoice-info}', '
            <div class="fmp-invoice-details">
                <div class="fmp-invoice-data-info"><input type="text" placeholder="Imię" name="invoice[firstname]" class="fmp-required"><input type="text" placeholder="Nazwisko" name="invoice[lastname]" class="fmp-required"></div>
                <div class="fmp-invoice-data-info"><input type="text" placeholder="Ulica" name="invoice[street]" class="fmp-required"><input type="text" name="invoice[street_n1]" class="fmp-required"><span class="fmp-separator">/</span><input type="text" name="invoice[street_n2]"></div>
                <div class="fmp-invoice-data-info"><input type="text" placeholder="Miasto" name="invoice[city]" class="fmp-required"><input type="text" placeholder="Kod pocztowy" name="invoice[postcode]" class="fmp-required"></div>
                <div class="fmp-invoice-data-info"><input type="text" placeholder="NIP" name="invoice[nip]"></div>
                <input type="hidden" name="step" value="1" />
            </div>
        ', $template);
        $template='<form action="' . $submit_url . '" method="post">' . $template;
        $template.='</form>';
        return $template;
    }

    public function check_access($service, $sms_code)
    {
        return false;
    }


    public function chk($service_id, $post_id, $service, $email, $control=null)
    {

        $DotpayPin=(string)$service['pin'];
        $ParametersArray=array(
            'api_version'=>'dev',
            'currency'=>'PLN',
            'lang'=>'pl',
            'id'=>$service['external_id'],
            'description'=>$service['description'],
            'amount'=>$service['price'],
            'URL'=>get_permalink($post_id),
            'type'=>0,
            'buttontext'=>'Powrót do ' . $_SERVER['HTTP_HOST'],
            'channel_groups'=>$service['channel_groups'],
            'URLC'=>admin_url('admin-ajax.php?action=fmp_dotpay_urlc&code_id=' . $control),
//            'URLC'=>admin_url('admin-ajax.php?action=fmp_dotpay_urlc&post_id=' . $post_id . '&service_id=' . $service_id),
            'email'=>$email,
            'control'=>$control,
        );

         $ChkParametersChain =
         $DotpayPin.
         (isset($ParametersArray['api_version']) ?
         $ParametersArray['api_version'] : null).
         (isset($ParametersArray['charset']) ?
         $ParametersArray['charset'] : null).
         (isset($ParametersArray['lang']) ?
         $ParametersArray['lang'] : null).
         (isset($ParametersArray['id']) ?
         $ParametersArray['id'] : null).
         (isset($ParametersArray['amount']) ?
         $ParametersArray['amount'] : null).
         (isset($ParametersArray['currency']) ?
         $ParametersArray['currency'] : null).
         (isset($ParametersArray['description']) ?
         $ParametersArray['description'] : null).
         (isset($ParametersArray['control']) ?
         $ParametersArray['control'] : null).
         (isset($ParametersArray['channel']) ?
         $ParametersArray['channel'] : null).
         (isset($ParametersArray['credit_card_brand']) ?
         $ParametersArray['credit_card_brand'] : null).
         (isset($ParametersArray['ch_lock']) ?
         $ParametersArray['ch_lock'] : null).
         (isset($ParametersArray['channel_groups']) ?
         $ParametersArray['channel_groups'] : null).
         (isset($ParametersArray['onlinetransfer']) ?
         $ParametersArray['onlinetransfer'] : null).
         (isset($ParametersArray['URL']) ?
         $ParametersArray['URL'] : null).
         (isset($ParametersArray['type']) ?
         $ParametersArray['type'] : null).
         (isset($ParametersArray['buttontext']) ?
         $ParametersArray['buttontext'] : null).
         (isset($ParametersArray['URLC']) ?
         $ParametersArray['URLC'] : null).
         (isset($ParametersArray['firstname']) ?
         $ParametersArray['firstname'] : null).
         (isset($ParametersArray['lastname']) ?
         $ParametersArray['lastname'] : null).
         (isset($ParametersArray['email']) ?
         $ParametersArray['email'] : null).
         (isset($ParametersArray['street']) ?
         $ParametersArray['street'] : null).
         (isset($ParametersArray['street_n1']) ?
         $ParametersArray['street_n1'] : null).
         (isset($ParametersArray['street_n2']) ?
         $ParametersArray['street_n2'] : null).
         (isset($ParametersArray['state']) ?
         $ParametersArray['state'] : null).
         (isset($ParametersArray['addr3']) ?
         $ParametersArray['addr3'] : null).
         (isset($ParametersArray['city']) ?
         $ParametersArray['city'] : null).
         (isset($ParametersArray['postcode']) ?
         $ParametersArray['postcode'] : null).
         (isset($ParametersArray['phone']) ?
         $ParametersArray['phone'] : null).
         (isset($ParametersArray['country']) ?
         $ParametersArray['country'] : null).
         (isset($ParametersArray['code']) ?
         $ParametersArray['code'] : null).
         (isset($ParametersArray['p_info']) ?
         $ParametersArray['p_info'] : null).
         (isset($ParametersArray['p_email']) ?
         $ParametersArray['p_email'] : null).
         (isset($ParametersArray['n_email']) ?
         $ParametersArray['n_email'] : null).
         (isset($ParametersArray['expiration_date']) ?
         $ParametersArray['expiration_date'] : null).
         (isset($ParametersArray['deladdr']) ?
         $ParametersArray['deladdr'] : null).
         (isset($ParametersArray['recipient_account_number']) ?
         $ParametersArray['recipient_account_number'] : null).
         (isset($ParametersArray['recipient_company']) ?
         $ParametersArray['recipient_company'] : null).
         (isset($ParametersArray['recipient_first_name']) ?
         $ParametersArray['recipient_first_name'] : null).
         (isset($ParametersArray['recipient_last_name']) ?
         $ParametersArray['recipient_last_name'] : null).
         (isset($ParametersArray['recipient_address_street']) ?
         $ParametersArray['recipient_address_street'] : null).
         (isset($ParametersArray['recipient_address_building']) ?
         $ParametersArray['recipient_address_building'] : null).
         (isset($ParametersArray['recipient_address_apartment']) ?
         $ParametersArray['recipient_address_apartment'] : null).
         (isset($ParametersArray['recipient_address_postcode']) ?
         $ParametersArray['recipient_address_postcode'] : null).
         (isset($ParametersArray['recipient_address_city']) ?
         $ParametersArray['recipient_address_city'] : null).
         (isset($ParametersArray['warranty']) ?
         $ParametersArray['warranty'] : null).
         (isset($ParametersArray['bylaw']) ?
         $ParametersArray['bylaw'] : null).
         (isset($ParametersArray['personal_data']) ?
         $ParametersArray['personal_data'] : null).
         (isset($ParametersArray['credit_card_number']) ?
         $ParametersArray['credit_card_number'] : null).
         (isset($ParametersArray['credit_card_expiration_date_year']) ?
         $ParametersArray['credit_card_expiration_date_year'] : null).
         (isset($ParametersArray['credit_card_expiration_date_month']) ?
         $ParametersArray['credit_card_expiration_date_month'] : null).
         (isset($ParametersArray['credit_card_security_code']) ?
         $ParametersArray['credit_card_security_code'] : null).
         (isset($ParametersArray['credit_card_store']) ?
         $ParametersArray['credit_card_store'] : null).
         (isset($ParametersArray['credit_card_store_security_code']) ?
         $ParametersArray['credit_card_store_security_code'] : null).
         (isset($ParametersArray['credit_card_customer_id']) ?
         $ParametersArray['credit_card_customer_id'] : null).
         (isset($ParametersArray['credit_card_id']) ?
         $ParametersArray['credit_card_id'] : null).
         (isset($ParametersArray['blik_code']) ?
         $ParametersArray['blik_code'] : null).
         (isset($ParametersArray['credit_card_registration']) ?
         $ParametersArray['credit_card_registration'] : null).
         (isset($ParametersArray['recurring_frequency']) ?
         $ParametersArray['recurring_frequency'] : null).
         (isset($ParametersArray['recurring_interval']) ?
         $ParametersArray['recurring_interval'] : null).
         (isset($ParametersArray['recurring_start']) ?
         $ParametersArray['recurring_start'] : null).
         (isset($ParametersArray['recurring_count']) ?
         $ParametersArray['recurring_count'] : null);


         $ChkValue = hash('sha256',$ChkParametersChain);

         return $ChkValue;
    }

    public function signature($post, $pin)
    {
        $sign=
        $pin.
        $post['id'].
        $post['operation_number'].
        $post['operation_type'].
        $post['operation_status'].
        $post['operation_amount'].
        $post['operation_currency'].
        $post['operation_withdrawal_amount'].
        $post['operation_commission_amount'].
        $post['operation_original_amount'].
        $post['operation_original_currency'].
        $post['operation_datetime'].
        $post['operation_related_number'].
        $post['control'].
        $post['description'].
        $post['email'].
        $post['p_info'].
        $post['p_email'].
        $post['credit_card_issuer_identification_number'].
        $post['credit_card_masked_number'].
        $post['credit_card_brand_codename'].
        $post['credit_card_brand_code'].
        $post['credit_card_id'].
        $post['channel'].
        $post['channel_country'].
        $post['geoip_country'];
        $signature=hash('sha256', $sign);
        return $signature;
    }
}
