<?php

class FastMicroPayProviderPrzelewy24
{
    public function generate_info_box($post_id, $service_id, $service)
    {
//        $parameters = $this->generate_parameters($post_id, $service_id, $service);
        $submit_url = 'https://secure.przelewy24.pl/trnDirect';
        if (!empty($service['environment']) and $service['environment'] == 'test') {
            $submit_url = 'https://sandbox.przelewy24.pl/trnDirect';
        }
        $template = str_replace('{code}', '<input type="text" class="fmp-code" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'" placeholder="Podaj email" data-type="email">', $service['info_box']);
        for ($i=1;$i<=5;$i++) {
            if (!empty($service['regulations_text' . (($i==1) ? '' : '_' . $i)])) {
                $template.='<span class="fmp-regulations-container"><label class="fmp-regulations-option"><input type="checkbox" value="1"><span>Akceptuj</span></label><span class="fmp-regulations-text"><span>' . $service['regulations_text' . (($i==1) ? '' : '_' . $i)] . '</span></span></span>';
            }
        }
        $template = str_replace('{submit}', '<span class="fmp-submit" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'">'.(!empty($service['button']) ? $service['button'] : 'Odblokuj').'</span>', $template);
        if (! empty($service['donation'])) {
            $template = str_replace('{donation}', '<input type="text" class="fmp-donation" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'" placeholder="Podaj kwotę darowizny" value="' . ((empty($service['price'])) ? '' : number_format($service['price'], 2)) . '">', $template);
        }
        $template = str_replace('{promo}', '<div class="fmp-promo-container"><input type="text" class="fmp-promo" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'" placeholder="Kod rabatowy" value=""><span class="fmp-promo-submit"><span>Sprawdź</span></span></div>', $template);
        $template = str_replace('{invoice-info}', '
            <div class="fmp-invoice-details">
                <div class="fmp-invoice-data-info"><input type="text" placeholder="Imię" name="invoice[firstname]" class="fmp-required"><input type="text" placeholder="Nazwisko" name="invoice[lastname]" class="fmp-required"></div>
                <div class="fmp-invoice-data-info"><input type="text" placeholder="Ulica" name="invoice[street]" class="fmp-required"><input type="text" name="invoice[street_n1]" class="fmp-required"><span class="fmp-separator">/</span><input type="text" name="invoice[street_n2]"></div>
                <div class="fmp-invoice-data-info"><input type="text" placeholder="Miasto" name="invoice[city]" class="fmp-required"><input type="text" placeholder="Kod pocztowy" name="invoice[postcode]" class="fmp-required"></div>
                <div class="fmp-invoice-data-info"><input type="text" placeholder="NIP" name="invoice[nip]"></div>
                <input type="hidden" name="step" value="1" />
            </div>
        ', $template);
        $template = '<form action="'.$submit_url.'" method="post">'.$template;
        $template .= '</form>';
        return $template;
    }

    public function check_access($service, $sms_code)
    {
        return false;
    }

    public function generate_parameters($post_id, $code_id, $service)
    {
        $post_url = get_permalink($post_id);
        $parameters = array(
            'p24_merchant_id'=>(int)$service['external_id'],
            'p24_pos_id'=>(int)$service['external_id'],
            'p24_session_id'=>$code_id,
            'p24_amount'=>(int)round((float) $service['price'] * 100),
            'p24_currency'=>'PLN',
            'p24_description'=>$service['description'],
//            'p24_email'=>'x',
            'p24_country'=>'PL',
            'p24_url_return'=>$post_url.((substr_count($post_url, '?') > 0) ? '&' : '?').'status=OK',
            'p24_url_status'=>admin_url('admin-ajax.php?action=fmp_przelewy24&code_id='.$code_id),
            'p24_api_version'=>'3.20',
//            'p24_sign'=>'x',
            'p24_name_1'=>$service['name'],
            'p24_quantity_1'=>1,
            'p24_price_1'=>(int)round((float) $service['price'] * 100),
        );

        return $parameters;
    }

    public function user_ip()
    {
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            $ip = $_SERVER['REMOTE_ADDR'];
        }

        return $ip;
    }

    public function generate_signature($parameters, $crc)
    {
        return md5($parameters['p24_session_id'] . '|' . $parameters['p24_merchant_id'] . '|' . $parameters['p24_amount'] . '|' . $parameters['p24_currency'] . '|' . $crc);
    }
    public function generate_verification_signature($parameters, $crc)
    {
        return md5($parameters['p24_session_id'] . '|' . $parameters['p24_order_id'] . '|' . $parameters['p24_amount'] . '|' . $parameters['p24_currency'] . '|' . $crc);
    }


    public function verify($parameters, $test)
    {
        $url='https://secure.przelewy24.pl/trnVerify';
        if ($test) {
            $url='https://sandbox.przelewy24.pl/trnVerify';
        }
        $post = array();
        $post['p24_merchant_id'] = (int)$parameters['p24_merchant_id'];
        $post['p24_pos_id'] = (int)$parameters['p24_pos_id'];
        $post['p24_session_id'] = (int)$parameters['p24_session_id'];
        $post['p24_amount'] = (int)$parameters['p24_amount'];
        $post['p24_currency'] = 'PLN';
        $post['p24_order_id'] = (int)$parameters['p24_order_id'];
        $post['p24_sign'] = preg_replace('/[^a-f0-9]/', '', $parameters['p24_sign']);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        if ($response = curl_exec($ch)) {
            $info = curl_getinfo($ch);
            curl_close($ch);

            if ($info["http_code"]!=200) {
                return array('error'=>200,'message'=>'HTTP error '.$info["http_code"]);
            } else {
                $response=explode('&', $response);
                $error=str_replace('error=', '', $response[0]);
                $message=@str_replace('errorMessage=', '', @$response[1]);
                return array('error'=>$error,'message'=>$message);
            }
        }
        return null;
    }
}
