<?php

class FastMicroPayProviderSimpaySms
{

    protected $auth = array();

    protected $response = array();
    protected $call = array();

    public function setApi($key = '', $secret = '' ){

        $this->auth = array(
            "auth" => array(
                "key" => $key,
                "secret" => $secret,
            )
        );
    }

    public function url($value, $params = array())
    {
        $data = json_encode(array('params'=>array_merge($this->auth, $params)));
        $this->call = $this->request($data, "https://simpay.pl/api/".$value);
        return $this->call;
    }

    public function getStatus($params)
    {
        $this->response = $this->url('status', $params);
        return $this->response;
    }
    public function getServices()
    {
        $this->response = $this->url( 'get_services' );
        return $this->response;
    }
    public function getServicesDB()
    {
        $this->response = $this->url( 'get_services_db' );

        return $this->response;
    }
    public function getTransactionsSMS()
    {
        $this->response = $this->url( 'transactions_sms' );

        return $this->response;
    }
    public function getTransactionsDB()
    {
        $this->response = $this->url( 'transactions_db' );

        return $this->response;
    }

    public function check()
    {
        if(isset($this->response) and is_array($this->response)) {
            if(isset($this->response['respond']['status']) and $this->response['respond']['status']=='OK') {
                return true;
            } else if(isset($this->response['error']) and is_array($this->response['error'])) {
                return false;
            }
        } else {
            throw new Exception('Brak informacji na temat ostatniego zapytania');
        }
    }

    public function error()
    {
        if(isset($this->response['error']) and is_array($this->response['error'])) {
            return true;
        } else {
            return false;
        }
    }

    public function showError()
    {
        if(isset($this->response['error']) and is_array($this->response['error'])) {
            return $this->response['error'];
        } else {
            throw new Exception('Brak bledu do pokazania');
        }
    }

    private function request($data, $url){
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        curl_setopt($curl, CURLOPT_FAILONERROR, 1);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false); // developer only
        $call = curl_exec($curl);
        $response = json_decode($call, true);
        $error = curl_errno($curl);
        curl_close($curl);

        if ($error > 0) {
            throw new RuntimeException('CURL ERROR Code:'.$error);
        }

        return $response;
    }

    public function response() {
        return $this->response;
    }
    public function getResponse(){
        return $this->response;
    }










    public function generate_info_box($post_id, $service_id, $service)
    {
        $template = str_replace('{code}', '<input type="text" class="fmp-code" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'" placeholder="Podaj kod dostępu" data-type="sms">', $service['info_box']);
        $template = str_replace('{submit}', '<span class="fmp-submit" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'">' . ( ! empty($service['button']) ? $service['button'] : 'Wyślij') . '</span>', $template);
        for($i=1;$i<=5;$i++)
        {
            if(!empty($service['regulations_text' . (($i==1) ? '' : '_' . $i)]))
            {
                $template.='<span class="fmp-regulations-container"><label class="fmp-regulations-option"><input type="checkbox" value="1"><span>Akceptuj</span></label><span class="fmp-regulations-text"><span>' . $service['regulations_text' . (($i==1) ? '' : '_' . $i)] . '</span></span></span>';
            }
        }
        return $template;
    }

    public function check_access($service, $sms_code)
    {
        $array = array();
        $array['check'] = $sms_code;
        $array['code'] = $service['external_service'];
        $array['id'] = $service['external_id'];
        $array['type'] = 'sms';
        $array['del'] = 1;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://ssl.dotpay.pl/check_code.php');
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 100);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $array);
        $recv = curl_exec($ch);
        curl_close($ch);

        $dane = explode("\n", $recv);
        $status = $dane[0];
        if ($status == 0) {
            return false;
        }

        return true;
    }
}
