<?php
include_once(FMP_PLUGIN_PATH . 'vendor/ClickMeetingRestClient.php');

class FastMicroPayWebinarClickMeeting
{

    private $room=null;
    public function __construct($fast_micro_pay_content)
    {
		$this->fast_micro_pay_content=$fast_micro_pay_content;
        if($this->fast_micro_pay_content->core->is_license_active())
        {
            add_filter('the_content', array($this, 'content'));
        }
    }



	public function content($content)
	{

		global $post;
        $content_normal=$content;
        $content_normal=str_replace('&#8221;','"', $content_normal);
        $content_normal=str_replace('&#8243;','"', $content_normal);


		$service_id = get_post_meta($post->ID, 'fmp_service_id', true);
		if ( ! empty($service_id) and ! empty($this->fast_micro_pay_content->core->options['services'][(int) $service_id]['status']) AND preg_match('/\[CLICKWEBINAR api_key="([0-9a-z]+)" room_id="([0-9]+)" url="([^"]+)" name="([^"]+)" time="([^"]+)"\]/i', $content_normal, $match) AND $this->fast_micro_pay_content->is_post_unlocked($post->ID, @(int) $this->fast_micro_pay_content->core->options['services'][(int) $service_id]['expiration_time'])) {
			$service=$this->fast_micro_pay_content->core->options['services'][(int)$service_id];
			$api_key=$match[1];
            $room_id=$match[2];
            $url    =$match[3];
            $name   =$match[4];
            $time   =$match[5];

            $this->room=array('url'=>$url, 'name'=>$name, 'time'=>$time);

			$code=false;
			if( ! empty($_COOKIE['fast_micro_pay_post_'.$post->ID]))
			{
				$cookie=$this->fast_micro_pay_content->sms_decrypt_cookie($_COOKIE['fast_micro_pay_post_'.$post->ID]);
				$cookie = explode('//', $cookie);
				if( ! empty($cookie[2]))
				{
					$code=$cookie[2];
				}
			}

			if($code)
			{
				$token=$this->get_code_token($code, $api_key, $room_id);
				if($token)
				{
					$replace='<span class="fmp-webinar-success">Do zalogowania się użyj tokena: <strong>' . $token  . '</strong></span>';
				}
				else
				{
					$replace='<span class="fmp-webinar-error">Token nie mógł zostać wygenerowany. Skontaktuj się ze sprzedawcą</span>';
				}
			}
			else
			{
				$replace='<span class="fmp-webinar-error">Post nie został odblokowany</span>';
			}
			$content=preg_replace('/\[CLICKWEBINAR([^\]]+)\]/i',$replace, $content);
		}
		return $content;
	}


	private function get_code_token($code, $api_key, $room_id)
	{
		$token=$this->get_token($room_id, $code);
		if(!$token)
		{
			$token=$this->generate_token($api_key, $room_id);
			if($token)
			{
				$this->save_token($room_id, $code, $token);
                if(filter_var($code, FILTER_VALIDATE_EMAIL) !== false)
                {
                    $this->send_notification($code, $token);
                }
			}
		}
		return $token;
	}


	private function get_token($room_id, $code)
	{
		global $wpdb;
		$token = $wpdb->get_results("SELECT token FROM {$wpdb->prefix}fast_micro_pay_clickwebinar WHERE room_id='" . (int)$room_id . "' AND code=". $wpdb->prepare('%s', array($code)), OBJECT);
		//$token = $wpdb->get_results("SELECT token FROM {$wpdb->prefix}fast_micro_pay_clickwebinar WHERE room_id='" . (int)$room_id . "' AND code='".$code."'", OBJECT);
		if(!empty($token[0]->token))
		{
			return $token[0]->token;
		}
		return false;
	}


	private function save_token($room_id, $code, $token)
	{
		global $wpdb;
		$wpdb->insert($wpdb->prefix.'fast_micro_pay_clickwebinar', array('room_id' => (int)$room_id, 'code' => $code, 'token' => strtoupper($token), 'created_at' => date('Y-m-d H:i:s', current_time('timestamp'))));
	}


	private function generate_token($api_key, $room_id)
	{
		try {
			$client = new ClickMeetingRestClient(array('api_key' => $api_key));
			$params = array(
				'how_many' => 1
			);
			$tokens = $client->generateConferenceTokens($room_id, $params);
			$tokens = $tokens->access_tokens;
		} catch (Exception $e) {
			return false;
		}

		if( ! empty($tokens[0]->token))
		{
			return $tokens[0]->token;
		}
		return false;
	}

    private function send_notification($mail, $token)
    {
        add_filter('wp_mail_from_name',array($this,'set_mail_from_name'));
        $headers='Your Name" <youremail@example.com>';
        $message = "Witaj\n\nUzyskałeś dostęp do webinaru %s, który rozpocznie się %s. Aby uruchomić webinar wejdź na %s i użyj tokena %s.\n\n\nDziękujemy";
        $message = sprintf($message, $this->room['name'], $this->room['time'], $this->room['url'], $token);
        @wp_mail( $mail, get_bloginfo('name') . ' - ' . $this->room['name'], $message, $headers);
    }

    function set_mail_from_name($name) {
      return get_bloginfo('name');
    }
}

//
// function fast_micro_pay_clickmeeting_init()
// {
// 	global $fast_micro_pay_content;
// 	new FastMicroPayWebinarClickMeeting($fast_micro_pay_content);
// }


//add_action('plugins_loaded','fast_micro_pay_clickmeeting_init');
?>
