<?php

class FastMicroPayAdmin extends FastMicroPay
{
    public $options;
    public $status = array('no-data' => 'Brak danych',
                    'no-code' => 'Brak transakcji',
                    'abnormal' => 'Nieprawidłowe dane',
                    'no-content-service' => 'Treść nie wymaga płatności',
                    'no-service' => 'Brak zdefiniowanej usługi',
                    'check-access-db' => 'Sprawdzenie kodu (baza danych)',
                    'valid-code-db' => 'Kod prawidłowy (baza danych)',
                    'invalid-code-db' => 'Kod nieprawidłowy (baza danych)',
                    'invalid-code-db-set' => 'Kod nieprawidłowy (baza danych)',
                    'check-access-external' => 'Sprawdzenie kodu (serwis płatności)',
                    'valid-code-external' => 'Kod prawidłowy (serwis płatności)',
                    'invalid-code-external' => 'Kod nieprawidłowy (serwis płatności)',
                    'dotpay-completed' => 'Dotpay - zakończono',
                    'dotpay-rejected' => 'Dotpay - odrzucono',
                    'payu-COMPLETED' => 'PayU - zakończono',
                    'payu-CANCELED' => 'PayU - anulowano',
                    'payu-REJECTED' => 'PayU - odrzucono',
                    'payu-PENDING' => 'PayU - oczekuje',
                    'tpay-TRUE' => 'TPay - zakończono',
                    'tpay-FALSE' => 'TPay - anulowano',
                    'przelewy24-verification' => 'Przelewy24 - błąd weryfikacji',
                    'przelewy24-verified' => 'Przelewy24 - zweryfikowano',
                    'other' => 'Inny',
                    'wrong-dotation-value' => 'Nieprawidłowa kwota dotacji',
                    'email-sent' => 'Wysłano e-mail',
                    'email-not-sent' => 'Nie można wysłać e-maila',
                    'invalid-response-host' => 'Nieprawidłowy adres IP weryfikacji',
                    'gr-success' => 'GetResponse - Zapis do kampanii',
                    'gr-error' => 'GetResponse - Błąd zapisu do kampanii'
);

    /**
     * Start up.
     */
    public function __construct($core)
    {
        global $wpdb;
        $this->core = $core;
        $this->post_types = get_post_types(array(), 'objects');
        add_action('admin_menu', array($this, 'add_plugin_page'));
        add_action('admin_enqueue_scripts', array($this, 'fmp_load_wp_admin_scripts'));
        add_action('admin_init', array($this, 'init'));


        if (empty($this->core->options['version']) or $this->core->options['version'] != self::VERSION) {
            FastMicroPaySetup::install_database();
            if (!empty($this->core->options['version'])) {
                $version=explode('.', self::VERSION);
                $version=(float)($version[0] . '.' . $version[1]);
                if ($version<1.8) {
                    FastMicroPaySetup::migrate_1_8();
                }
            }

            $this->core->options['version'] = self::VERSION;
            update_option('fast_micro_pay', $this->core->options);
            $this->core->activation();
        }
    }

    public function init()
    {
        if (current_user_can('delete_posts')) {
            add_action('delete_post', array('FastMicroPayLog', 'delete_post_logs'));
            add_action('delete_post', array('FastMicroPayCodes', 'delete_post_codes'));
        }
    }

    public function fmp_load_wp_admin_scripts()
    {
        wp_enqueue_script('jquery-ui-datepicker');
        $wp_scripts = wp_scripts();
        wp_enqueue_style(
            'jquery-ui-theme-smoothness',
            sprintf(
                'https://ajax.googleapis.com/ajax/libs/jqueryui/%s/themes/smoothness/jquery-ui.css',
                $wp_scripts->registered['jquery-ui-core']->ver
            )
        );
        wp_register_style('fmp_wp_admin_css', plugin_dir_url(__FILE__).'css/wp-admin.css', false, self::VERSION);
        wp_enqueue_style('fmp_wp_admin_css');
        wp_register_script('fmp_wp_admin_js', plugin_dir_url(__FILE__).'js/admin.js', false, self::VERSION);
        wp_enqueue_script('fmp_wp_admin_js');
    }
    /**
     * Add options page.
     */
    public function add_plugin_page()
    {
        add_options_page(
            'Fast Micro Pay',
            'Mikropłatności',
            'manage_options',
            'fast-micro-pay',
            array($this, 'create_admin_page')
        );
    }

    public function page_header()
    {
        global $section;
        $core=$this->core;
        //////////////////////////////////////////////////////////////////////////////////////?>
<div class="wrap">
    <h1>Fast Micro Pay</h1>
<?php

$license = $this->core->get_license();
        if ($this->core->check_type('demo') and $this->core->is_license_active()) :?>
<div class="updatded update-nag" style="width: 96%; text-align: center;">Licencja demo Fast Micro Pay wygasa <strong><?php echo $license['to']; ?></strong>.
</div>
<?php elseif ($this->core->check_type('demo') and !$this->core->is_license_active()): ?>
<div class="updatded update-nag" style="color: #a00; width: 96%;">Darmowa 3-dniowa licencja demo wygasła. Chcesz przedłużyć okres testowy? Wyślij wiadomość na <a href="mailto:biuro@projektmarketing.pl">biuro@projektmarketing.pl</a>, podając adres domeny internetowej, gdzie ma zostać wydłużona licencja demo Fast Micro Pay.</div>
<?php endif;

        if ($this->core->is_license_active()) {
            ?>
    <input type="hidden" name="fmp-version" value="<?php echo $core::VERSION; ?>">
    <p style="text-align:center" class=" fmp-sections-links">
        <a class="button<?php echo (@$this->section == 'services') ? '-primary' : ''; ?> action" href="<?php echo admin_url('options-general.php?page=fast-micro-pay'); ?>"><i class="dashicons dashicons-tickets"></i> Usługi</a>
        <a class="button<?php echo (@$this->section == 'sets') ? '-primary' : ''; ?> action" href="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=sets'); ?>"><i class="dashicons dashicons-admin-page"></i> Pakiety</a>
        <a class="button<?php echo (@$this->section == 'stats') ? '-primary' : ''; ?> action" href="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=stats'); ?>"><i class="dashicons dashicons-chart-pie"></i> Statystyki</a>
        <a class="button<?php echo (@$this->section == 'codes') ? '-primary' : ''; ?> action" href="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=codes'); ?>"><i class="dashicons dashicons-lock"></i>Kody / Dostępy</a>
        <a class="button<?php echo (@$this->section == 'promos') ? '-primary' : ''; ?> action" href="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=promos'); ?>"><i class="dashicons dashicons-tickets-alt"></i>Kody rabatowe</a>
        <a class="button<?php echo (@$this->section == 'log') ? '-primary' : ''; ?> action" href="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=log'); ?>"><i class="dashicons dashicons-list-view"></i>Log</a>
        <a class="button<?php echo (@$this->section == 'license') ? '-primary' : ''; ?> action" href="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=license'); ?>"><i class="dashicons dashicons-admin-network"></i> Licencja</a>
        <a class="button action" href="http://pracabezszefa.pl/dokumentacja-techniczna-wtyczki-fast-micro-pay" target="_blank"><i class="dashicons dashicons-book"></i> Dokumentacja</a>
        <?php if ($this->core->check_type('demo')) : ?>
        <a class="button action" href="http://pracabezszefa.pl/wsparcie-techniczne-dla-wtyczki-fast-micropay" target="_blank"><i class="dashicons dashicons-phone"></i> Pomoc techniczna</a>
        <?php endif; ?>
        <span class="fmp-update-notify"></span>
    </p>
<?php
        } else {
            ?>

        <p style="text-align:center" class=" fmp-sections-links">
            <a class="button action" href="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=license'); ?>" style="font-weight:bold;"><i class="dashicons dashicons-admin-network"></i> Licencja</a>
            <span class="fmp-update-notify"></span>
        </p>

<?php
        }

        /////////////////////////////////////////////////////////////////////////////////////
    }

    public function create_admin_page()
    {
        $sections = array('license', 'services', 'sets', 'log', 'stats', 'codes', 'promos');
        $this->section = @$_GET['section'];

        if (empty($this->section)) {
            $this->section = 'services';
        }

        if ($this->core->is_license_active()) {
            switch ($this->section) {
        case 'license':
            $this->admin_page_license();
        break;
        case 'services':
            $this->admin_page_services();
        break;
        case 'sets':
            $this->admin_page_sets();
        break;
        case 'stats':
            $this->admin_page_stats();
        break;
        case 'codes':
            $this->admin_page_codes();
        break;
        case 'promos':
            $this->admin_page_promos();
        break;
        case 'log':
            $this->admin_page_log();
        break;
        default:
            wp_redirect(admin_url('options-general.php?page=fast-micro-pay'), 302);
            exit;
        break;

    }
        } else {
            $this->admin_page_license();
        } ?>
        </div>
        <?php
    }

    public function admin_page_license()
    {
        $license = $this->core->get_license();

        $current_domain = explode(':', $_SERVER['HTTP_HOST']);
        $current_domain = strtolower($current_domain[0]);
        if (!empty($_POST)) {
            if (!empty($_POST['save']) and isset($_POST['license'])) {
                $this->core->options['license'] = $_POST['license'];
                update_option('fast_micro_pay', $this->core->options);
            }
            if (!empty($_POST['generate_demo_license'])) {
                $genrated_license = $this->core->generate_demo_license();

                if ($genrated_license != false and is_array($genrated_license) and ! empty($genrated_license['status']) and ! empty($genrated_license['key']) and $genrated_license['status']=='ok') {
                    $this->core->options['license'] = $genrated_license['key'];
                    update_option('fast_micro_pay', $this->core->options);
                }
            }
            wp_redirect(admin_url('options-general.php?page=fast-micro-pay&section=license'), 302);
            exit;
        }

        $this->page_header(); ?>
        <hr>
        <h2><i class="dashicons dashicons-admin-network"></i> Licencja</h2>
<div style="width:100%">

<div style="width:49%; float:left">
<form style="text-align:center; margin-top:0px;" class=" fmp-sections-links" action="<?php echo admin_url('options-general.php?page=fast-micro-pay&amp;section=license&amp;noheader'); ?>" method="POST">
<textarea name="license" style="width:90%; height:150px;margin:0 auto; display:block;"><?php echo $this->core->options['license']; ?></textarea>
<button type="submit" class="button action" value="1" name="save" style="margin-top:10px;"><i class="dashicons dashicons-post-status"></i>Zapisz</button>
<?php if ($license['status'] == 'invalid'): ?>
<button type="submit" class="button action" value="1" name="generate_demo_license" style="margin-top:10px;"><i class="dashicons dashicons-unlock"></i>Wygeneruj licencję testową</button>
<?php endif; ?>
</form>
    </div>
    <div style="width:49%; float:left">
        <table class="wp-list-table widefat" style="height:150px">

    <tr>
            <td><strong>Status</strong></td>
            <td style="color:<?php echo ($this->core->is_license_active()) ? '#006505' : '#a00'; ?>; text-align:center"><?php if ($license['status'] == 'active') {
            echo 'Aktywna';
        } elseif ($license['status'] == 'inactive') {
            echo 'Nieaktywna';
        } else {
            echo 'Brak licencji';
        } ?></td>
        </tr>
        <tr>
            <td><strong>Licencja dla</strong></td>
            <td style="color:#006505; text-align:center"><?php echo ($this->core->is_license_valid()) ? $license['for'] : '-'; ?></td>
        </tr>
        <tr>
            <td><strong>Adres e-mail</strong></td>
            <td style="color:#006505; text-align:center"><?php echo ($this->core->is_license_valid()) ? $license['email'] : '-'; ?></td>
        </tr>
        <tr>
            <td><strong>Rodzaj</strong></td>
            <td style="color:#006505; text-align:center"><?php echo ($this->core->is_license_valid()) ? implode('<br />', $license['type']) : '-'; ?></td>
        </tr>
        <tr>
            <td><strong>Ważna do</strong></td>
            <td style="<?php if (!$this->core->is_license_valid()) {
            echo '';
        } else {
            echo ((int) str_replace('-', '', $license['to']) >= (int) date('Ymd') or $license['to'] == 'unlimited') ? 'color:#006505' : 'color:#a00';
        } ?>; text-align:center"><?php if (!$this->core->is_license_valid()) {
            echo '-';
        } else {
            echo ($license['to'] == 'unlimited') ? 'Bez ograniczeń' : $license['to'];
        } ?></td>
        </tr>
        <tr>
            <td><strong>Domena</strong></td>
            <td style="<?php if (!$this->core->is_license_valid()) {
            echo '';
        } else {
            echo ($license['domain'][0] == 'unlimited' or in_array($current_domain, $license['domain'])) ? 'color:#006505' : 'color:#a00';
        } ?>; text-align:center"><?php if (!$this->core->is_license_valid()) {
            echo '-';
        } else {
            echo ($license['domain'][0] == 'unlimited') ? 'Bez ograniczeń' : implode(', ', $license['domain']);
        } ?></td>
        </tr>
    </tbody>
                            </table>
    </div>

</div>


<?php
    }

    public function admin_page_services()
    {
        global $wpdb;
        global $table_prefix;

        $email_title_default='Automat - Płatność w serwisie {domain}';
        $email_body_default='Szanowni Państwo!

Uprzejmie informujemy o nowej transakcji w kwocie {price} PLN.

<strong>Dostęp do zakupionych zasobów:</strong>

URL: <a href="{url}#fmp-premium-content">{url}</a>
Hasło: {email}
Wygasa: {expiration}

Pozdrawiamy serdecznie
[Wiadomość została wysłana automatycznie, prosimy <strong>NIE ODPOWIADAĆ</strong> na nią].';
        $mode = 'add';
        if (!empty($_GET['action']) and $_GET['action'] == 'edit-service' and !empty($_GET['id']) and !empty($this->core->options['services'][$_GET['id']])) {
            $service_data = $this->core->options['services'][$_GET['id']];
            $mode = 'edit';
        }

        if (!empty($_POST['fast_micro_pay']['service']) and !empty($_POST['mode']) and in_array($_POST['mode'], array('add', 'edit'))) {
            // exit;
            $service_data = $this->core->limit_array($_POST['fast_micro_pay']['service'], array('provider', 'name', 'api_key', 'api_secret',  'external_id', 'external_service', 'price', 'expiration_time', 'description', 'pin', 'key', 'channel_groups', 'environment', 'info_box', 'info_box_second', 'regulations_text', 'regulations_text_2', 'regulations_text_3', 'regulations_text_4', 'regulations_text_5', 'donation_message', 'status', 'button', 'collective', 'donation', 'service_header', 'email_title', 'email_body', 'ga_id', 'external_number', 'crc'));
            if (!empty($service_data['provider']) and
            (!empty($service_data['external_id']) or in_array($service_data['provider'], array('tpay-sms', 'simpay-sms'))) and
            !empty($service_data['expiration_time']) and
            in_array($service_data['provider'], array('dotpay-sms', 'dotpay-online', 'dotpay-transfer', 'payu', 'tpay-sms', 'tpay-online', 'simpay-sms', 'przelewy24')) and
            (!empty($service_data['external_service']) or in_array($service_data['provider'], array('dotpay-transfer', 'payu', 'tpay-online', 'przelewy24'))) and

            isset($service_data['status'])
            ) {
                // var_dump($service_data);
                // exit;
                $service_data['external_id'] = (int) $service_data['external_id'];
                $service_data['expiration_time'] = (int) $service_data['expiration_time'];
                $service_data['price'] = round(floatval(str_replace(',', '.', $service_data['price'])), 2);
                $service_data['status'] = (int) $service_data['status'];
                $service_data['description'] = (string) @$service_data['description'];
                $service_data['pin'] = trim((string) @$service_data['pin']);
                $service_data['crc'] = trim((string) @$service_data['crc']);
                $service_data['key'] = trim((string) @$service_data['key']);
                $service_data['channel_groups'] = trim((string) @$service_data['channel_groups']);
                $service_data['environment'] = (string) @$service_data['environment'];
                $service_data['button'] = (string) @$service_data['button'];
                $service_data['collective'] = (int) @$service_data['collective'];
                $service_data['donation'] = (int) @$service_data['donation'];
                $service_data['donation_message'] = (string) @$service_data['donation_message'];

                $service_data['donation']=0;
                if (substr_count($service_data['info_box'], '{donation}')>0 and in_array($service_data['provider'], array( 'dotpay-transfer', 'payu', 'tpay-online', 'tpay-online', 'przelewy24'))) {
                    $service_data['donation'] = 1;
                }

                if (empty($service_data['description'])) {
                    $service_data['description']='Zakup: ' . $service_data['name'];
                }

                if ($_POST['mode'] == 'add') {
                    $this->core->options['services'][$this->core->options['services_ai'] + 1] = stripslashes_deep($service_data);
                }

                if ($_POST['mode'] == 'edit' and !empty($_POST['fast_micro_pay']['service']['id']) and !empty($this->core->options['services'][$_POST['fast_micro_pay']['service']['id']])) {
                    // var_dump(stripslashes_deep($service_data));
                    // exit;
                    $this->core->options['services'][$_POST['fast_micro_pay']['service']['id']] = stripslashes_deep($service_data);
                }

                update_option('fast_micro_pay', $this->core->options); ?>
<script>
    window.location.href=window.location.href;
</script>
            <?php
            }
        } else {
        }

        if (! empty($_POST['delete'])) {
            if (!empty($_POST['service_id']) and is_array($_POST['service_id'])) {
                foreach ($_POST['service_id'] as $id) {
                    FastMicroPayLog::delete_service_logs((int) $id);
                    FastMicroPayCodes::delete_service_codes((int) $id);
                    FastMicroPayPromos::delete_service_promos((int) $id);
                    unset($this->core->options['services'][(int) $id]);
                    if (! empty($this->core->options['sets'])) {
                        foreach ($this->core->options['sets'] as $k=>$v) {
                            if (! empty($this->core->options['sets'][$k]['service_id']) and in_array((int) $id, $this->core->options['sets'][$k]['service_id'])) {
                                unset($this->core->options['sets'][$k]['service_id'][array_search((int) $id, $this->core->options['sets'][$k]['service_id'], false)]);
                            }
                        }
                    }
                    $wpdb->delete($wpdb->prefix.'postmeta', array('meta_key' => 'fmp_service_id', 'meta_value' => (int)$id));
                }
            }
            update_option('fast_micro_pay', $this->core->options);
            wp_redirect(admin_url('options-general.php?page=fast-micro-pay'), 302);
        }




        if (!empty($_GET['action']) and in_array($_GET['action'], array('toggle-service-status'))) {
            if ($_GET['action'] == 'toggle-service-status' and !empty($_GET['id']) and !empty($this->core->options['services'][$_GET['id']])) {
                $this->core->options['services'][(int) $_GET['id']]['status'] = ((int) $this->core->options['services'][(int) $_GET['id']]['status'] == 1) ? 0 : 1;
            }
            update_option('fast_micro_pay', $this->core->options);
            wp_redirect(admin_url('options-general.php?page=fast-micro-pay'), 302);
            exit;
        }

        $this->page_header(); ?>



        <hr>
        <h2><i class="dashicons dashicons-tickets"></i> Usługi</h2>


        <form method="post" class="fmp-box" id="fmp-new-service-form">
            <input type="hidden" name="mode" value="<?php echo $mode; ?>">
		    <?php if ($mode == 'edit'): ?>
                <h3>Edytuj usługę <?php echo $this->core->options['services'][$_GET['id']]['name']; ?> [ID <?php echo $_GET['id']; ?>]</h3>
            <input type="hidden" name="fast_micro_pay[service][id]" value="<?php echo $_GET['id']; ?>">
                <script>




                    jQuery(document).ready(function(){
                        form=jQuery('.fmp-new-service-template[data-provider="<?php echo $this->core->options['services'][$_GET['id']]['provider']; ?>"]').html();
                        jQuery('#fmp-new-service-form .submit').show();
                        jQuery('#fmp-new-service-form .fields').attr('data-provider', '<?php echo $this->core->options['services'][$_GET['id']]['provider']; ?>').html(form);
                    });

                </script>

		    <?php

            else:

            ?>
		    <?php if (!empty($_POST['mode']) and $_POST['mode'] == 'add' and !empty($service_data['provider'])):  ?>
                

                <script>
                    jQuery(document).ready(function(){
                        jQuery('#fmp-new-service-type').val('<?php echo $service_data['provider']; ?>');
                        form=jQuery('.fmp-new-service-template[data-provider="<?php echo $service_data['provider']; ?>"]').html();
                        jQuery('#fmp-new-service-form .submit').show();
                        jQuery('#fmp-new-service-form .fields').attr('data-provider', '<?php echo $this->core->options['services'][$_GET['id']]['provider']; ?>').html(form);
                    });
                </script>


		    <?php endif; ?>
                <h3>Dodaj nową usługę</h3>
                <p>Wybierz rodzaj usługi i wypełnij opcje konfiguracyjne:
                    <select type="text" id="fmp-new-service-type">
                        <option value="">Wybierz</option>
					    <?php foreach ($this->core->providers as $provider_key => $provider): ?>
                            <option value="<?php echo $provider_key ?>"><?php echo $provider['name']; ?></option>
					    <?php endforeach ?>
                    </select></p>
		    <?php endif; ?>




            <div class="fields" id="add-service-form">

            </div>
            <p style="clear: both;padding-top:15px; text-align:left; display: none" class="submit"><span class="required">*</span> - Obowiązkowe</p>
            <p style="clear: both;padding-top:5px; text-align:center; display:none;" class="submit"><input type="submit" name="submit_fmp" class="button-primary" value="Zapisz usługę" /></p>
        </form>


        <div class="fmp-new-service-template" data-provider="dotpay-sms">

            <input type="hidden" name="fast_micro_pay[service][provider]" value="dotpay-sms">
            <input type="hidden" name="fast_micro_pay[service][status]" value="<?php echo @$service_data['status']?>">

            <div class="fmp-add-service-info">
                <a class="button action" href="http://pracabezszefa.pl/jak-uruchomic-platnosci-sms-premium-przez-dotpay" target="_blank"><i class="dashicons dashicons-book"></i> Poradnik</a>
            </div>

            <div class="fmp-tabs-wrapper">
                <h2 class="nav-tab-wrapper">
                    <a href="#" class="nav-tab nav-tab-active" data-tab="main">Ustawienia główne</a>
                    <a href="#" class="nav-tab" data-tab="contents">Treści
                        <a href="#" class="nav-tab" data-tab="other">Pozostałe</a>
                </h2>
                <div class="fmp-tabs">
                    <div class="fmp-tab-content active" data-tab="main">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <label>Nazwa<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][name]" value="<?php echo @$service_data['name']?>" placeholder="Np.: Chroniony materiał" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>ID użytkownika<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][external_id]" value="<?php echo @$service_data['external_id']?>" placeholder="Np.: 1234" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Identyfikator usługi<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][external_service]" value="<?php echo @$service_data['external_service']?>" placeholder="Np.: ABC" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Cena<span class="required">*</span>:<br><input type="number" step="0.01" name="fast_micro_pay[service][price]" value="<?php echo((float)@$service_data['price'] > 0 ? number_format((float)@$service_data['price'], 2, '.', ' ') : ''); ?>" placeholder="Np.: 3.00" required></label>
                            </div>

                            <div class="fmp-item">
                                <label>Ważność kodu<span class="required">*</span>:<br><input type="number" name="fast_micro_pay[service][expiration_time]" value="<?php echo @$service_data['expiration_time']?>" placeholder="Np.: 30" required></label>
                            </div>

                            <div class="fmp-item">
                                <label>Usługa grupowa:<br><input type="checkbox" name="fast_micro_pay[service][collective]" value="1"<?php echo (!empty($service_data['collective'])) ? ' checked' : ''; ?>></label>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="contents">
                        <div class="fmp-add-service">
                            <div class="fmp-item-big">
                                <div style="width:200px; float:left">
                                    <label>Treść przycisku:<br><input type="text" name="fast_micro_pay[service][button]" value="<?php echo @$service_data['button']?>" placeholder="Np. Odblokuj"></label><br />
                                </div>
                                <div style="width: auto; margin: 0 auto 0 200px;">
                                    <label>Informacja o akceptacji regulaminu:<br><textarea name="fast_micro_pay[service][regulations_text]" rows="2" cols="25" placeholder="Prośba o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item-big">
                                <label>Treść okna zakupu<span class="required">*</span>:<br><textarea name="fast_micro_pay[service][info_box]" rows="4" cols="25" placeholder="Obowiazkowe zmienne to {code} {submit}" required><?php echo ($mode == 'edit') ? stripslashes(@$service_data['info_box']) : '{code} {submit}' ?></textarea></label>
                                <span class="fmp-insert-shortcode-container"><span class="fmp-insert-shortcode" data-shortcode="code" title="Pole do wpisania adresu email">{code}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="submit" title="Przycisk do wysłania formularza">{submit}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="link" title="Link do płatności">{link}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="invoice-info" title="Formularz podania danych osobowych">{invoice-info}</span><span class="fmp-insert-shortcode" data-shortcode="donation" title="Pole do wpisania kwoty dotacji">{donation}</span><span class="fmp-insert-shortcode" data-shortcode="promo" title="Pole do wpisania kodu rabatowego">{promo}</span></span>
                            </div>

                            <div class="fmp-item-big">
                                <label>Treść kolejnego okna zakupu:<br><textarea name="fast_micro_pay[service][info_box_second]" rows="4" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['info_box_second']) : '' ?></textarea></label>
                            </div>

                            <div class="fmp-item-big">
                                <label>Nagłówek w pakiecie:<br><textarea name="fast_micro_pay[service][service_header]" rows="4" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['service_header']) : '' ?></textarea></label>
                            </div>
                        </div>

                    </div>
                    <div class="fmp-tab-content" data-tab="other">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <label>Google Analytics ID<br><input type="text" name="fast_micro_pay[service][ga_id]" value="<?php echo @$service_data['ga_id']?>" placeholder="Np.: UA-12345678-1"></label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="fmp-new-service-template" data-provider="dotpay-online">
            <input type="hidden" name="fast_micro_pay[service][provider]" value="dotpay-online">
            <input type="hidden" name="fast_micro_pay[service][status]" value="<?php echo @$service_data['status']?>">
            <div class="fmp-add-service-info">
                <a class="button action" href="http://pracabezszefa.pl/szybki-przelew-bankowy-online-dotpay-czyli-uruchomic-sprzedaz-produktow-blogu" target="_blank"><i class="dashicons dashicons-book"></i> Poradnik</a>
            </div>
            <div class="fmp-tabs-wrapper">
                <h2 class="nav-tab-wrapper">
                    <a href="#" class="nav-tab nav-tab-active" data-tab="main">Ustawienia główne</a>
                    <a href="#" class="nav-tab" data-tab="contents">Treści</a>
                    <a href="#" class="nav-tab" data-tab="agreements">Zgody</a>
                    <a href="#" class="nav-tab" data-tab="other">Pozostałe</a>
                </h2>
                <div class="fmp-tabs">
                    <div class="fmp-tab-content active" data-tab="main">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <label>Nazwa<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][name]" value="<?php echo @$service_data['name']?>" placeholder="Np.: Chroniony materiał" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>ID użytkownika<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][external_id]" value="<?php echo @$service_data['external_id']?>" placeholder="Np.: 1234" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Identyfikator usługi<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][external_service]" value="<?php echo @$service_data['external_service']?>" placeholder="Np.: ABC" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Cena<span class="required">*</span>:<br><input type="number" step="0.01" name="fast_micro_pay[service][price]" value="<?php echo((float)@$service_data['price'] > 0 ? number_format((float)@$service_data['price'], 2, '.', ' ') : ''); ?>" placeholder="Np.: 3.00" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Ważność kodu<span class="required">*</span>:<br><input type="number" name="fast_micro_pay[service][expiration_time]" value="<?php echo @$service_data['expiration_time']?>" placeholder="Np.: 30" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Usługa grupowa:<br><input type="checkbox" name="fast_micro_pay[service][collective]" value="1"<?php echo (!empty($service_data['collective'])) ? ' checked' : ''; ?>></label>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="contents">
                        <div class="fmp-add-service">
                            <div class="fmp-item-big">
                                <div style="width:200px; float:left">
                                    <label>Treść przycisku:<br><input type="text" name="fast_micro_pay[service][button]" value="<?php echo @$service_data['button']?>" placeholder="Np. Odblokuj"></label><br />
                                </div>
                            </div>
                            <div class="fmp-item-big">
                                <label>Treść okna zakupu<span class="required">*</span>:<br><textarea name="fast_micro_pay[service][info_box]" rows="4" cols="25" placeholder="Obowiazkowe zmienne to {code} {submit} i {link}" required><?php echo ($mode == 'edit') ? stripslashes(@$service_data['info_box']) : '{code} {submit} {link}' ?></textarea></label>
                                <span class="fmp-insert-shortcode-container"><span class="fmp-insert-shortcode" data-shortcode="code" title="Pole do wpisania adresu email">{code}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="submit" title="Przycisk do wysłania formularza">{submit}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="link" title="Link do płatności">{link}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="invoice-info" title="Formularz podania danych osobowych">{invoice-info}</span><span class="fmp-insert-shortcode" data-shortcode="donation" title="Pole do wpisania kwoty dotacji">{donation}</span><span class="fmp-insert-shortcode" data-shortcode="promo" title="Pole do wpisania kodu rabatowego">{promo}</span></span>
                            </div>
                            <div class="fmp-item-big">
                                <label>Treść kolejnego okna zakupu:<br><textarea name="fast_micro_pay[service][info_box_second]" rows="4" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['info_box_second']) : '' ?></textarea></label>
                            </div>
                            <div class="fmp-item-big">
                                <label>Nagłówek w pakiecie:<br><textarea name="fast_micro_pay[service][service_header]" rows="4" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['service_header']) : '' ?></textarea></label>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="agreements">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text]" rows="5" cols="25" placeholder="Prośba o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #2:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_2]" rows="5" cols="25" placeholder="Prośba #2 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_2']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #3:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_3]" rows="5" cols="25" placeholder="Prośba #3 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_3']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #4:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_4]" rows="5" cols="25" placeholder="Prośba #4 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_4']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #5:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_5]" rows="5" cols="25" placeholder="Prośba #5 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_5']) : '' ?></textarea></label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="other">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <label>Google Analytics ID<br><input type="text" name="fast_micro_pay[service][ga_id]" value="<?php echo @$service_data['ga_id']?>" placeholder="Np.: UA-12345678-1"></label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>

        <div class="fmp-new-service-template" data-provider="dotpay-transfer">
            <input type="hidden" name="fast_micro_pay[service][provider]" value="dotpay-transfer">
            <input type="hidden" name="fast_micro_pay[service][status]" value="<?php echo @$service_data['status']?>">
            <div class="fmp-add-service-info">
                <a class="button action" href="http://pracabezszefa.pl/platnosci-online-dotpay-sprzedaz-na-wordpressie-przez-wtyczke-fast-micro-pay" target="_blank"><i class="dashicons dashicons-book"></i> Poradnik</a>
            </div>
            <div class="fmp-tabs-wrapper">
                <h2 class="nav-tab-wrapper">
                    <a href="#" class="nav-tab nav-tab-active" data-tab="main">Ustawienia główne</a>
                    <a href="#" class="nav-tab" data-tab="contents">Treści</a>
                    <a href="#" class="nav-tab" data-tab="agreements">Zgody</a>
                    <a href="#" class="nav-tab" data-tab="email">E-mail</a>
                    <a href="#" class="nav-tab" data-tab="other">Pozostałe</a>
                </h2>
                <div class="fmp-tabs">
                    <div class="fmp-tab-content active" data-tab="main">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <label>Nazwa<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][name]" value="<?php echo @$service_data['name']?>" placeholder="Np.: Chroniony materiał" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>ID użytkownika<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][external_id]" value="<?php echo @$service_data['external_id']?>" placeholder="Np.: 1234" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Cena<span class="required">*</span>:<br><input type="number" step="0.01" name="fast_micro_pay[service][price]" value="<?php echo((float)@$service_data['price'] > 0 ? number_format((float)@$service_data['price'], 2, '.', ' ') : ''); ?>" placeholder="Np.: 3.00" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Ważność dostępu<span class="required">*</span>:<br><input type="number" name="fast_micro_pay[service][expiration_time]" value="<?php echo @$service_data['expiration_time']?>" placeholder="Np.: 30" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>PIN Dotpay<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][pin]" value="<?php echo @$service_data['pin']?>" placeholder="Z konfiguracji Dotpay" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Kanały płatności<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][channel_groups]" value="<?php echo @$service_data['channel_groups']; ?>" placeholder="Zalecane: K,T,P,W" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Środowisko<span class="required">*</span>:<br>
                                    <select name="fast_micro_pay[service][environment]">
                                        <option value="production">Produkcyjne</option>
                                        <option value="test"<?php echo (@$service_data['environment'] == 'test') ? ' selected' : ''; ?>>Testowe</option>
                                    </select>
                                </label>
                            </div>
                            <div class="fmp-item">
                                <label>Usługa grupowa:<br><input type="checkbox" name="fast_micro_pay[service][collective]" value="1"<?php echo (!empty($service_data['collective'])) ? ' checked' : ''; ?>></label>
                            </div>
                            <div class="fmp-item">
                                <label>Dotacja:<br><input type="checkbox" name="fast_micro_pay[service][donation]" value="1"<?php echo (!empty($service_data['donation'])) ? ' checked' : ''; ?>></label>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="contents">
                        <div class="fmp-add-service">
                            <div class="fmp-item-big">
                                <div style="width:200px; float:left">
                                    <label>Treść przycisku:<br><input type="text" name="fast_micro_pay[service][button]" value="<?php echo @$service_data['button']?>" placeholder="Np. Odblokuj"></label><br />
                                </div>
                            </div>
                            <div class="fmp-item-big">
                                <label>Treść okna zakupu<span class="required">*</span>:<br><textarea name="fast_micro_pay[service][info_box]" rows="4" cols="25" placeholder="Obowiazkowe zmienne to {code} {submit} i {link}" required><?php echo ($mode == 'edit') ? stripslashes(@$service_data['info_box']) : '{code} {submit}' ?></textarea></label>
                                <span class="fmp-insert-shortcode-container"><span class="fmp-insert-shortcode" data-shortcode="code" title="Pole do wpisania adresu email">{code}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="submit" title="Przycisk do wysłania formularza">{submit}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="link" title="Link do płatności">{link}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="invoice-info" title="Formularz podania danych osobowych">{invoice-info}</span><span class="fmp-insert-shortcode" data-shortcode="donation" title="Pole do wpisania kwoty dotacji">{donation}</span><span class="fmp-insert-shortcode" data-shortcode="promo" title="Pole do wpisania kodu rabatowego">{promo}</span></span>
                            </div>
                            <div class="fmp-item-big">
                                <label>Treść kolejnego okna zakupu:<br><textarea name="fast_micro_pay[service][info_box_second]" rows="4 cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['info_box_second']) : '' ?></textarea></label>
                            </div>
                            <div class="fmp-item-big">
                                <label>Opis transakcji<span class="required">*</span>:<br><textarea name="fast_micro_pay[service][description]" maxlength="255" rows="4" cols="25" placeholder="Pole obowiązkowe. Maksymalnie 255 znaków"><?php echo @$service_data['description']?></textarea></label>
                            </div>
                            <div class="fmp-item-big">
                                <label>Nagłówek w pakiecie:<br><textarea name="fast_micro_pay[service][service_header]" rows="4" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['service_header']) : '' ?></textarea></label>
                            </div>
                            <div class="fmp-item-big">
                                <label>Podziękowanie za złożenie dotacji:<br><textarea name="fast_micro_pay[service][donation_message]" rows="4" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['donation_message']) : '' ?></textarea></label>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="agreements">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text]" rows="5" cols="25" placeholder="Prośba o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #2:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_2]" rows="5" cols="25" placeholder="Prośba #2 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_2']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #3:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_3]" rows="5" cols="25" placeholder="Prośba #3 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_3']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #4:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_4]" rows="5" cols="25" placeholder="Prośba #4 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_4']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #5:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_5]" rows="5" cols="25" placeholder="Prośba #5 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_5']) : '' ?></textarea></label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="email">
                        <div class="fmp-add-service">
                            <div class="fmp-item-big">
                                <label>Temat e-maila:<br><input type="text" name="fast_micro_pay[service][email_title]" value="<?php echo(($mode=='add') ? $email_title_default : @$service_data['email_title'])?>"></label><br />
                                <label>Treść e-maila:<br><textarea name="fast_micro_pay[service][email_body]" rows="4" cols="25" placeholder=""><?php echo(($mode=='add') ? $email_body_default : @$service_data['email_body'])?></textarea></label>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="other">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <label>Google Analytics ID:<br><input type="text" name="fast_micro_pay[service][ga_id]" value="<?php echo @$service_data['ga_id']?>" placeholder="Np.: UA-12345678-1"></label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="fmp-new-service-template" data-provider="payu">
            <input type="hidden" name="fast_micro_pay[service][provider]" value="payu">
            <input type="hidden" name="fast_micro_pay[service][status]" value="<?php echo @$service_data['status']?>">
            <div class="fmp-add-service-info">
                <a class="button action" href="http://pracabezszefa.pl/platny-dostep-tresci-system-platnosci-payu-wordpress" target="_blank"><i class="dashicons dashicons-book"></i> Poradnik</a>
            </div>
            <div class="fmp-tabs-wrapper">
                <h2 class="nav-tab-wrapper">
                    <a href="#" class="nav-tab nav-tab-active" data-tab="main">Ustawienia główne</a>
                    <a href="#" class="nav-tab" data-tab="contents">Treści</a>
                    <a href="#" class="nav-tab" data-tab="agreements">Zgody</a>
                    <a href="#" class="nav-tab" data-tab="email">E-mail</a>
                    <a href="#" class="nav-tab" data-tab="other">Pozostałe</a>
                </h2>
                <div class="fmp-tabs">
                    <div class="fmp-tab-content active" data-tab="main">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <label>Nazwa<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][name]" value="<?php echo @$service_data['name']?>" placeholder="Np.: Chroniony materiał" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>ID punktu płatności (pos_id)<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][external_id]" value="<?php echo @$service_data['external_id']?>" placeholder="Np.: 1234" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Cena<span class="required">*</span>:<br><input type="number" step="0.01" name="fast_micro_pay[service][price]" value="<?php echo((float)@$service_data['price'] > 0 ? number_format((float)@$service_data['price'], 2, '.', ' ') : ''); ?>" placeholder="Np.: 3.00" required></label>
                            </div>

                            <div class="fmp-item">
                                <label>Ważność dostępu<span class="required">*</span>:<br><input type="number" name="fast_micro_pay[service][expiration_time]" value="<?php echo @$service_data['expiration_time']?>" placeholder="Np.: 30" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Drugi klucz (MD5)<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][pin]" value="<?php echo @$service_data['pin']?>" placeholder="Z konfiguracji POS" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Usługa grupowa:<br><input type="checkbox" name="fast_micro_pay[service][collective]" value="1"<?php echo (!empty($service_data['collective'])) ? ' checked' : ''; ?>></label>
                            </div>
                            <div class="fmp-item">
                                <label>Dotacja:<br><input type="checkbox" name="fast_micro_pay[service][donation]" value="1"<?php echo (!empty($service_data['donation'])) ? ' checked' : ''; ?>></label>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="contents">
                        <div class="fmp-add-service">
                            <div class="fmp-item-big">
                                <div style="width:200px; float:left">
                                    <label>Treść przycisku:<br><input type="text" name="fast_micro_pay[service][button]" value="<?php echo @$service_data['button']?>" placeholder="Np. Odblokuj"></label><br />
                                </div>
                            </div>
                            <div class="fmp-item-big">
                                <label>Treść okna zakupu<span class="required">*</span>:<br><textarea name="fast_micro_pay[service][info_box]" rows="2" cols="25" placeholder="Obowiazkowe zmienne to {code} {submit} i {link}" required><?php echo ($mode == 'edit') ? stripslashes(@$service_data['info_box']) : '{code} {submit}' ?></textarea></label>
                                <span class="fmp-insert-shortcode-container"><span class="fmp-insert-shortcode" data-shortcode="code" title="Pole do wpisania adresu email">{code}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="submit" title="Przycisk do wysłania formularza">{submit}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="link" title="Link do płatności">{link}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="invoice-info" title="Formularz podania danych osobowych">{invoice-info}</span><span class="fmp-insert-shortcode" data-shortcode="donation" title="Pole do wpisania kwoty dotacji">{donation}</span><span class="fmp-insert-shortcode" data-shortcode="promo" title="Pole do wpisania kodu rabatowego">{promo}</span></span>
                            </div>
                            <div class="fmp-item-big">
                                <label>Treść kolejnego okna zakupu:<br><textarea name="fast_micro_pay[service][info_box_second]" rows="2" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['info_box_second']) : '' ?></textarea></label>
                            </div>
                            <div class="fmp-item-big">
                                <label>Opis transakcji:<br><textarea name="fast_micro_pay[service][description]" maxlength="255" rows="2" cols="25" placeholder="Pole obowiązkowe"><?php echo @$service_data['description']?></textarea></label>
                            </div>
                            <div class="fmp-item-big">
                                <label>Nagłówek w pakiecie:<br><textarea name="fast_micro_pay[service][service_header]" rows="2" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['service_header']) : '' ?></textarea></label>
                            </div>
                            <div class="fmp-item-big">
                                <label>Podziękowanie za złożenie dotacji:<br><textarea name="fast_micro_pay[service][donation_message]" rows="4" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['donation_message']) : '' ?></textarea></label>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="agreements">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text]" rows="5" cols="25" placeholder="Prośba o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #2:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_2]" rows="5" cols="25" placeholder="Prośba #2 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_2']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #3:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_3]" rows="5" cols="25" placeholder="Prośba #3 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_3']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #4:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_4]" rows="5" cols="25" placeholder="Prośba #4 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_4']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #5:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_5]" rows="5" cols="25" placeholder="Prośba #5 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_5']) : '' ?></textarea></label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="email">
                        <div class="fmp-add-service">
                            <div class="fmp-item-big">
                                <label>Temat e-maila:<br><input type="text" name="fast_micro_pay[service][email_title]" value="<?php echo(($mode=='add') ? $email_title_default : @$service_data['email_title'])?>"></label><br />
                                <label>Treść e-maila:<br><textarea name="fast_micro_pay[service][email_body]" rows="2" cols="25" placeholder=""><?php echo(($mode=='add') ? $email_body_default : @$service_data['email_body'])?></textarea></label>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="other">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <label>Google Analytics ID:<br><input type="text" name="fast_micro_pay[service][ga_id]" value="<?php echo @$service_data['ga_id']?>" placeholder="Np.: UA-12345678-1"></label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="fmp-new-service-template" data-provider="tpay-sms">
            <input type="hidden" name="fast_micro_pay[service][provider]" value="tpay-sms">
            <input type="hidden" name="fast_micro_pay[service][status]" value="<?php echo @$service_data['status']?>">

            <div class="fmp-add-service-info">
                <a class="button action" href="http://pracabezszefa.pl/platnosci-sms-premium-tpay-wordpress" target="_blank"><i class="dashicons dashicons-book"></i> Poradnik</a>
            </div>
            <div class="fmp-tabs-wrapper">
                <h2 class="nav-tab-wrapper">
                    <a href="#" class="nav-tab nav-tab-active" data-tab="main">Ustawienia główne</a>
                    <a href="#" class="nav-tab" data-tab="contents">Treści</a>
                    <a href="#" class="nav-tab" data-tab="agreements">Zgody</a>
                    <a href="#" class="nav-tab" data-tab="other">Pozostałe</a>
                </h2>
                <div class="fmp-tabs">
                    <div class="fmp-tab-content active" data-tab="main">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <label>Nazwa<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][name]" value="<?php echo @$service_data['name']?>" placeholder="Np.: Chroniony materiał" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Identyfikator usługi<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][external_service]" value="<?php echo @$service_data['external_service']?>" placeholder="Np.: ABC" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Cena<span class="required">*</span>:<br><input type="number" step="0.01" name="fast_micro_pay[service][price]" value="<?php echo((float)@$service_data['price'] > 0 ? number_format((float)@$service_data['price'], 2, '.', ' ') : ''); ?>" placeholder="Np.: 3.00" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Ważność kodu<span class="required">*</span>:<br><input type="number" name="fast_micro_pay[service][expiration_time]" value="<?php echo @$service_data['expiration_time']?>" placeholder="Np.: 30" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Usługa grupowa:<br><input type="checkbox" name="fast_micro_pay[service][collective]" value="1"<?php echo (!empty($service_data['collective'])) ? ' checked' : ''; ?>></label>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="contents">
                        <div class="fmp-add-service">
                            <div class="fmp-item-big">
                                <div style="width:200px; float:left">
                                    <label>Treść przycisku:<br><input type="text" name="fast_micro_pay[service][button]" value="<?php echo @$service_data['button']?>" placeholder="Np. Odblokuj"></label><br />
                                </div>
                            </div>
                            <div class="fmp-item-big">
                                <label>Treść okna zakupu<span class="required">*</span>:<br><textarea name="fast_micro_pay[service][info_box]" rows="2" cols="25" placeholder="Obowiazkowe zmienne to {code} {submit}" required><?php echo ($mode == 'edit') ? stripslashes(@$service_data['info_box']) : '{code} {submit}' ?></textarea></label>
                                <span class="fmp-insert-shortcode-container"><span class="fmp-insert-shortcode" data-shortcode="code" title="Pole do wpisania adresu email">{code}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="submit" title="Przycisk do wysłania formularza">{submit}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="link" title="Link do płatności">{link}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="invoice-info" title="Formularz podania danych osobowych">{invoice-info}</span><span class="fmp-insert-shortcode" data-shortcode="donation" title="Pole do wpisania kwoty dotacji">{donation}</span><span class="fmp-insert-shortcode" data-shortcode="promo" title="Pole do wpisania kodu rabatowego">{promo}</span></span>
                            </div>

                            <div class="fmp-item-big">
                                <label>Treść kolejnego okna zakupu:<br><textarea name="fast_micro_pay[service][info_box_second]" rows="2" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['info_box_second']) : '' ?></textarea></label>
                            </div>
                            <div class="fmp-item-big">
                                <label>Nagłówek w pakiecie:<br><textarea name="fast_micro_pay[service][service_header]" rows="2" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['service_header']) : '' ?></textarea></label>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="agreements">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text]" rows="5" cols="25" placeholder="Prośba o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #2:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_2]" rows="5" cols="25" placeholder="Prośba #2 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_2']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #3:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_3]" rows="5" cols="25" placeholder="Prośba #3 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_3']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #4:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_4]" rows="5" cols="25" placeholder="Prośba #4 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_4']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #5:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_5]" rows="5" cols="25" placeholder="Prośba #5 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_5']) : '' ?></textarea></label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="other">
                        <div class="fmp-item">
                            <label>Google Analytics ID:<br><input type="text" name="fast_micro_pay[service][ga_id]" value="<?php echo @$service_data['ga_id']?>" placeholder="Np.: UA-12345678-1"></label>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="fmp-new-service-template" data-provider="tpay-online">
            <input type="hidden" name="fast_micro_pay[service][provider]" value="tpay-online">
            <input type="hidden" name="fast_micro_pay[service][status]" value="<?php echo @$service_data['status']?>">
            <div class="fmp-add-service-info">
                <a class="button action" href="http://pracabezszefa.pl/platny-dostep-do-tresci-przez-tpay-na-wordpress" target="_blank"><i class="dashicons dashicons-book"></i> Poradnik</a>
            </div>
            <div class="fmp-tabs-wrapper">
                <h2 class="nav-tab-wrapper">
                    <a href="#" class="nav-tab nav-tab-active" data-tab="main">Ustawienia główne</a>
                    <a href="#" class="nav-tab" data-tab="contents">Treści</a>
                    <a href="#" class="nav-tab" data-tab="agreements">Zgody</a>
                    <a href="#" class="nav-tab" data-tab="email">E-mail</a>
                    <a href="#" class="nav-tab" data-tab="other">Pozostałe</a>
                </h2>
                <div class="fmp-tabs">
                    <div class="fmp-tab-content active" data-tab="main">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <label>Nazwa<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][name]" value="<?php echo @$service_data['name']?>" placeholder="Np.: Chroniony materiał" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>ID użytkownika<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][external_id]" value="<?php echo @$service_data['external_id']?>" placeholder="Np.: 1234" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Cena<span class="required">*</span>:<br><input type="number" step="0.01" name="fast_micro_pay[service][price]" value="<?php echo((float)@$service_data['price'] > 0 ? number_format((float)@$service_data['price'], 2, '.', ' ') : ''); ?>" placeholder="Np.: 3.00" required></label>
                            </div>

                            <div class="fmp-item">
                                <label>Ważność dostępu<span class="required">*</span>:<br><input type="number" name="fast_micro_pay[service][expiration_time]" value="<?php echo @$service_data['expiration_time']?>" placeholder="Np.: 30" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Kod bezpieczeństwa<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][key]" value="<?php echo @$service_data['key']?>" placeholder="Z konfiguracji Tpay"  required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Usługa grupowa:<br><input type="checkbox" name="fast_micro_pay[service][collective]" value="1"<?php echo (!empty($service_data['collective'])) ? ' checked' : ''; ?>></label>
                            </div>
                            <div class="fmp-item">
                                <label>Dotacja:<br><input type="checkbox" name="fast_micro_pay[service][donation]" value="1"<?php echo (!empty($service_data['donation'])) ? ' checked' : ''; ?>></label>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="contents">
                        <div class="fmp-add-service">
                            <div class="fmp-item-big">
                                <div style="width:200px; float:left">
                                    <label>Treść przycisku:<br><input type="text" name="fast_micro_pay[service][button]" value="<?php echo @$service_data['button']?>" placeholder="Np. Odblokuj"></label><br />
                                </div>
                            </div>
                            <div class="fmp-item-big">
                                <label>Treść okna zakupu<span class="required">*</span>:<br><textarea name="fast_micro_pay[service][info_box]" rows="2" cols="25" placeholder="Obowiazkowe zmienne to {code} {submit} i {link}" required><?php echo ($mode == 'edit') ? stripslashes(@$service_data['info_box']) : '{code} {submit}' ?></textarea></label>
                                <span class="fmp-insert-shortcode-container"><span class="fmp-insert-shortcode" data-shortcode="code" title="Pole do wpisania adresu email">{code}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="submit" title="Przycisk do wysłania formularza">{submit}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="link" title="Link do płatności">{link}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="invoice-info" title="Formularz podania danych osobowych">{invoice-info}</span><span class="fmp-insert-shortcode" data-shortcode="donation" title="Pole do wpisania kwoty dotacji">{donation}</span><span class="fmp-insert-shortcode" data-shortcode="promo" title="Pole do wpisania kodu rabatowego">{promo}</span></span>
                            </div>
                            <div class="fmp-item-big">
                                <label>Treść kolejnego okna zakupu:<br><textarea name="fast_micro_pay[service][info_box_second]" rows="2" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['info_box_second']) : '' ?></textarea></label>
                            </div>
                            <div class="fmp-item-big">
                                <label>Opis transakcji:<br><textarea name="fast_micro_pay[service][description]" maxlength="255" rows="2" cols="25" placeholder="Pole obowiązkowe"><?php echo @$service_data['description']?></textarea></label>
                            </div>
                            <div class="fmp-item-big">
                                <label>Nagłówek w pakiecie:<br><textarea name="fast_micro_pay[service][service_header]" rows="2" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['service_header']) : '' ?></textarea></label>
                            </div>
                            <div class="fmp-item-big">
                                <label>Podziękowanie za złożenie dotacji:<br><textarea name="fast_micro_pay[service][donation_message]" rows="4" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['donation_message']) : '' ?></textarea></label>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="agreements">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text]" rows="5" cols="25" placeholder="Prośba o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #2:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_2]" rows="5" cols="25" placeholder="Prośba #2 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_2']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #3:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_3]" rows="5" cols="25" placeholder="Prośba #3 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_3']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #4:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_4]" rows="5" cols="25" placeholder="Prośba #4 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_4']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #5:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_5]" rows="5" cols="25" placeholder="Prośba #5 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_5']) : '' ?></textarea></label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="email">
                        <div class="fmp-add-service">
                            <div class="fmp-item-big">
                                <label>Temat e-maila:<br><input type="text" name="fast_micro_pay[service][email_title]" value="<?php echo(($mode=='add') ? $email_title_default : @$service_data['email_title'])?>"></label><br />
                                <label>Treść e-maila:<br><textarea name="fast_micro_pay[service][email_body]" rows="2" cols="25" placeholder=""><?php echo(($mode=='add') ? $email_body_default : @$service_data['email_body'])?></textarea></label>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="other">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <label>Google Analytics ID:<br><input type="text" name="fast_micro_pay[service][ga_id]" value="<?php echo @$service_data['ga_id']?>" placeholder="Np.: UA-12345678-1"></label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="fmp-new-service-template" data-provider="simpay-sms">
            <input type="hidden" name="fast_micro_pay[service][provider]" value="simpay-sms">
            <input type="hidden" name="fast_micro_pay[service][status]" value="<?php echo @$service_data['status']?>">

            <div class="fmp-add-service-info">
                <a class="button action" href="http://pracabezszefa.pl/platnosci-sms-premium-simpay-wordpress" target="_blank"><i class="dashicons dashicons-book"></i> Poradnik</a>
            </div>
            <div class="fmp-tabs-wrapper">
                <h2 class="nav-tab-wrapper">
                    <a href="#" class="nav-tab nav-tab-active" data-tab="main">Ustawienia główne</a>
                    <a href="#" class="nav-tab" data-tab="contents">Treści</a>
                    <a href="#" class="nav-tab" data-tab="agreements">Zgody</a>
                    <a href="#" class="nav-tab" data-tab="other">Pozostałe</a>
                </h2>
                <div class="fmp-tabs">
                    <div class="fmp-tab-content active" data-tab="main">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <label>Nazwa<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][name]" value="<?php echo @$service_data['name']?>" placeholder="Np.: Chroniony materiał" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Klucz API<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][api_key]" value="<?php echo @$service_data['api_key']?>" placeholder="Z ustawień konta" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Hasło API<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][api_secret]" value="<?php echo @$service_data['api_secret']?>" placeholder="Z ustawień konta" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Identyfikator usługi<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][external_service]" value="<?php echo @$service_data['external_service']?>" placeholder="Z konfiguracji usługi" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Numer telefonu<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][external_number]" value="<?php echo @$service_data['external_number']?>" placeholder="Z konfiguracji usługi" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Cena<span class="required">*</span>:<br><input type="number" step="0.01" name="fast_micro_pay[service][price]" value="<?php echo((float)@$service_data['price'] > 0 ? number_format((float)@$service_data['price'], 2, '.', ' ') : ''); ?>" placeholder="Np.: 3.00" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Ważność kodu<span class="required">*</span>:<br><input type="number" name="fast_micro_pay[service][expiration_time]" value="<?php echo @$service_data['expiration_time']?>" placeholder="Np.: 30" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Usługa grupowa:<br><input type="checkbox" name="fast_micro_pay[service][collective]" value="1"<?php echo (!empty($service_data['collective'])) ? ' checked' : ''; ?>></label>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="contents">
                        <div class="fmp-add-service">
                            <div class="fmp-item-big">
                                <div style="width:200px; float:left">
                                    <label>Treść przycisku:<br><input type="text" name="fast_micro_pay[service][button]" value="<?php echo @$service_data['button']?>" placeholder="Np. Odblokuj"></label><br />
                                </div>
                            </div>
                            <div class="fmp-item-big">
                                <label>Treść okna zakupu<span class="required">*</span>:<br><textarea name="fast_micro_pay[service][info_box]" rows="2" cols="25" placeholder="Obowiazkowe zmienne to {code} {submit}" required><?php echo ($mode == 'edit') ? stripslashes(@$service_data['info_box']) : '{code} {submit}' ?></textarea></label>
                                <span class="fmp-insert-shortcode-container"><span class="fmp-insert-shortcode" data-shortcode="code" title="Pole do wpisania adresu email">{code}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="submit" title="Przycisk do wysłania formularza">{submit}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="link" title="Link do płatności">{link}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="invoice-info" title="Formularz podania danych osobowych">{invoice-info}</span><span class="fmp-insert-shortcode" data-shortcode="donation" title="Pole do wpisania kwoty dotacji">{donation}</span><span class="fmp-insert-shortcode" data-shortcode="promo" title="Pole do wpisania kodu rabatowego">{promo}</span></span>
                            </div>

                            <div class="fmp-item-big">
                                <label>Treść kolejnego okna zakupu:<br><textarea name="fast_micro_pay[service][info_box_second]" rows="2" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['info_box_second']) : '' ?></textarea></label>
                            </div>
                            <div class="fmp-item-big">
                                <label>Nagłówek w pakiecie:<br><textarea name="fast_micro_pay[service][service_header]" rows="2" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['service_header']) : '' ?></textarea></label>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="agreements">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text]" rows="5" cols="25" placeholder="Prośba o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #2:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_2]" rows="5" cols="25" placeholder="Prośba #2 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_2']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #3:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_3]" rows="5" cols="25" placeholder="Prośba #3 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_3']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #4:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_4]" rows="5" cols="25" placeholder="Prośba #4 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_4']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #5:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_5]" rows="5" cols="25" placeholder="Prośba #5 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_5']) : '' ?></textarea></label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="other">
                        <div class="fmp-item">
                            <label>Google Analytics ID:<br><input type="text" name="fast_micro_pay[service][ga_id]" value="<?php echo @$service_data['ga_id']?>" placeholder="Np.: UA-12345678-1"></label>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="fmp-new-service-template" data-provider="przelewy24">
            <input type="hidden" name="fast_micro_pay[service][provider]" value="przelewy24">
            <input type="hidden" name="fast_micro_pay[service][status]" value="<?php echo @$service_data['status']?>">
            <div class="fmp-add-service-info">
                <a class="button action" href="http://pracabezszefa.pl/platny-dostep-tresci-system-platnosci-przelewy24-wordpress" target="_blank"><i class="dashicons dashicons-book"></i> Poradnik</a>
            </div>
            <div class="fmp-tabs-wrapper">
                <h2 class="nav-tab-wrapper">
                    <a href="#" class="nav-tab nav-tab-active" data-tab="main">Ustawienia główne</a>
                    <a href="#" class="nav-tab" data-tab="contents">Treści</a>
                    <a href="#" class="nav-tab" data-tab="agreements">Zgody</a>
                    <a href="#" class="nav-tab" data-tab="email">E-mail</a>
                    <a href="#" class="nav-tab" data-tab="other">Pozostałe</a>
                </h2>
                <div class="fmp-tabs">
                    <div class="fmp-tab-content active" data-tab="main">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <label>Nazwa<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][name]" value="<?php echo @$service_data['name']?>" placeholder="Np.: Chroniony materiał" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Numer konta (p24_merchant_id)<span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][external_id]" value="<?php echo @$service_data['external_id']?>" placeholder="Np.: 1234" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Cena<span class="required">*</span>:<br><input type="number" step="0.01" name="fast_micro_pay[service][price]" value="<?php echo((float)@$service_data['price'] > 0 ? number_format((float)@$service_data['price'], 2, '.', ' ') : ''); ?>" placeholder="Np.: 3.00" required></label>
                            </div>

                            <div class="fmp-item">
                                <label>Ważność dostępu<span class="required">*</span>:<br><input type="number" name="fast_micro_pay[service][expiration_time]" value="<?php echo @$service_data['expiration_time']?>" placeholder="Np.: 30" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Klucz do CRC <span class="required">*</span>:<br><input type="text" name="fast_micro_pay[service][crc]" value="<?php echo @$service_data['crc']?>" placeholder="Z panelu sprzedawcy" required></label>
                            </div>
                            <div class="fmp-item">
                                <label>Środowisko<span class="required">*</span>:<br>
                                    <select name="fast_micro_pay[service][environment]">
                                        <option value="production">Produkcyjne</option>
                                        <option value="test"<?php echo (@$service_data['environment'] == 'test') ? ' selected' : ''; ?>>Testowe</option>
                                    </select>
                                </label>
                            </div>
                            <div class="fmp-item">
                                <label>Usługa grupowa:<br><input type="checkbox" name="fast_micro_pay[service][collective]" value="1"<?php echo (!empty($service_data['collective'])) ? ' checked' : ''; ?>></label>
                            </div>
                            <div class="fmp-item">
                                <label>Dotacja:<br><input type="checkbox" name="fast_micro_pay[service][donation]" value="1"<?php echo (!empty($service_data['donation'])) ? ' checked' : ''; ?>></label>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="contents">
                        <div class="fmp-add-service">
                            <div class="fmp-item-big">
                                <div style="width:200px; float:left">
                                    <label>Treść przycisku:<br><input type="text" name="fast_micro_pay[service][button]" value="<?php echo @$service_data['button']?>" placeholder="Np. Odblokuj"></label><br />
                                </div>
                            </div>
                            <div class="fmp-item-big">
                                <label>Treść okna zakupu<span class="required">*</span>:<br><textarea name="fast_micro_pay[service][info_box]" rows="2" cols="25" placeholder="Obowiazkowe zmienne to {code} {submit} i {link}" required><?php echo ($mode == 'edit') ? stripslashes(@$service_data['info_box']) : '{code} {submit}' ?></textarea></label>
                                <span class="fmp-insert-shortcode-container"><span class="fmp-insert-shortcode" data-shortcode="code" title="Pole do wpisania adresu email">{code}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="submit" title="Przycisk do wysłania formularza">{submit}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="link" title="Link do płatności">{link}<span class="required">*</span></span><span class="fmp-insert-shortcode" data-shortcode="invoice-info" title="Formularz podania danych osobowych">{invoice-info}</span><span class="fmp-insert-shortcode" data-shortcode="donation" title="Pole do wpisania kwoty dotacji">{donation}</span><span class="fmp-insert-shortcode" data-shortcode="promo" title="Pole do wpisania kodu rabatowego">{promo}</span></span>
                            </div>
                            <div class="fmp-item-big">
                                <label>Treść kolejnego okna zakupu:<br><textarea name="fast_micro_pay[service][info_box_second]" rows="2" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['info_box_second']) : '' ?></textarea></label>
                            </div>
                            <div class="fmp-item-big">
                                <label>Opis transakcji:<br><textarea name="fast_micro_pay[service][description]" maxlength="255" rows="2" cols="25" placeholder="Pole obowiązkowe"><?php echo @$service_data['description']?></textarea></label>
                            </div>
                            <div class="fmp-item-big">
                                <label>Nagłówek w pakiecie:<br><textarea name="fast_micro_pay[service][service_header]" rows="2" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['service_header']) : '' ?></textarea></label>
                            </div>
                            <div class="fmp-item-big">
                                <label>Podziękowanie za złożenie dotacji:<br><textarea name="fast_micro_pay[service][donation_message]" rows="4" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$service_data['donation_message']) : '' ?></textarea></label>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="agreements">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text]" rows="5" cols="25" placeholder="Prośba o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #2:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_2]" rows="5" cols="25" placeholder="Prośba #2 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_2']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #3:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_3]" rows="5" cols="25" placeholder="Prośba #3 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_3']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #4:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_4]" rows="5" cols="25" placeholder="Prośba #4 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_4']) : '' ?></textarea></label>
                                </div>
                            </div>
                            <div class="fmp-item">
                                <div>
                                    <label>Informacja o akceptacji regulaminu #5:<br><textarea style="width: calc(100% - 15px)" name="fast_micro_pay[service][regulations_text_5]" rows="5" cols="25" placeholder="Prośba #5 o zapoznanie się z regulaminem. Jeśli pozostawisz puste checkbox z prośbą o akceptację nie wyświetli się."><?php echo ($mode == 'edit') ? stripslashes(@$service_data['regulations_text_5']) : '' ?></textarea></label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="email">
                        <div class="fmp-add-service">
                            <div class="fmp-item-big">
                                <label>Temat e-maila:<br><input type="text" name="fast_micro_pay[service][email_title]" value="<?php echo(($mode=='add') ? $email_title_default : @$service_data['email_title'])?>"></label><br />
                                <label>Treść e-maila:<br><textarea name="fast_micro_pay[service][email_body]" rows="2" cols="25" placeholder=""><?php echo(($mode=='add') ? $email_body_default : @$service_data['email_body'])?></textarea></label>
                            </div>
                        </div>
                    </div>
                    <div class="fmp-tab-content" data-tab="other">
                        <div class="fmp-add-service">
                            <div class="fmp-item">
                                <label>Google Analytics ID:<br><input type="text" name="fast_micro_pay[service][ga_id]" value="<?php echo @$service_data['ga_id']?>" placeholder="Np.: UA-12345678-1"></label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
<form method="POST" action="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=services&noheader') ; ?>">

<table class="wp-list-table widefat fmp-responsive-table">
                        <thead>
                            <tr style="">
                                <th style="width:30px; text-align:center;"><input type="checkbox" class="fmp-checkbox-all" style=" margin:0 4px 0 0;"></th>
                                <th style="width:20px; text-align:center">ID</th>
                                <th style="width:220px; text-align:center">Nazwa</th>
                                <th style="width:180px; text-align:center">Serwis</th>
<!--                                <th style="width:100px; text-align:center">Id użytkownika</th>-->
                                <th style="width:20px; text-align:center"><span class="dashicons dashicons-info"></span></th>
                                <th style="width:20px; text-align:center"><span class="dashicons dashicons-tickets-alt"></span></th>
                                <th style="width:20px; text-align:center"><span class="dashicons dashicons-media-spreadsheet"></span></th>
                                <th style="width:20px; text-align:center"><span class="dashicons dashicons-format-gallery"></span></th>
                                <th style="width:60px; text-align:center">Cena</th>
                                <th style="width:60px; text-align:center">Ważność</th>
                                <th style="width:auto"></th>
                                <th style="width:90px; text-align:center">Status</th>
<!--                                <th style="width:90px; text-align:center">Edycja</th>-->
                                <th style="width:110px; text-align:center">Kody / Dostępy</th>
                                <th style="width:35px; text-align:center">Log</th>
<!--                                <th style="width:60px; text-align:center">Usuń</th>-->
                            </tr>
                        </thead>
                        <tbody>
<?php
if (empty($this->core->options['services'])) {
                ?>
<tr>
<td colspan="14" style="text-align:center;">Brak zdefiniowanych usług</td>
</tr>
<?php
            } else {
                foreach ($this->core->options['services'] as $k => $v): ?>


<tr class="<?php echo (!empty($_GET['id']) and $_GET['id']==$k) ? 'active' : ''; ?><?php echo (empty($v['status'])) ? ' fmp-disabled' : ''; ?>">
    <td style="text-align:center"><input type="checkbox" name="service_id[]" value="<?php echo $k ?>" class="fmp-checkbox"></td>
    <td style="text-align:center"><?php echo $k ?></td>
    <td style="text-align:left"><a href="options-general.php?page=fast-micro-pay&amp;action=edit-service&amp;id=<?php echo $k ?>"><?php echo $v['name'] ?></a></td>
    <td style="text-align:left"><?php echo ! empty($this->providers[$v['provider']]['name']) ? $this->providers[$v['provider']]['name'] : '<span class="dashicons dashicons-minus"></span>'; ?></td>
<!--    <td style="text-align:center">--><?php //echo (empty($v['external_id'])) ? '-': $v['external_id'];?><!--</td>-->
    <td style="text-align:center; width: 20px;"><span class="dashicons <?php echo((!empty($v['donation'])) ? 'dashicons-heart' : 'dashicons-cart'); ?>"></span></td>
    <td style="text-align:center; width: 20px;"><span class="dashicons <?php echo((substr_count($v['info_box'], '{promo}')>0) ? 'dashicons-tickets-alt' : 'dashicons-minus'); ?>"></span></td>
    <td style="text-align:center; width: 20px;"><span class="dashicons <?php echo((substr_count($v['info_box'], '{invoice-info}')>0) ? 'dashicons-media-spreadsheet' : 'dashicons-minus'); ?>"></span></td>
    <td style="text-align:center; width: 20px;"><span class="dashicons <?php echo((!empty($v['collective'])) ? 'dashicons-format-gallery' : 'dashicons-minus'); ?>"></span></td>
    <td style="text-align:center; font-weight: bold;"><?php echo number_format($v['price'], 2, ',', ' '); ?></td>
    <td style="text-align:center; font-weight: bold;"><?php echo $v['expiration_time'] ?></td>
    <td></td>
    <td style="text-align:center"><a href="options-general.php?page=fast-micro-pay&amp;action=toggle-service-status&amp;noheader=true&amp;id=<?php echo $k ?>"><?php echo ($v['status'] == '1') ? '<span style="color:#006505">Włączony</span>' : '<span style="color:#a00">Wyłączony</span>'; ?></a></td>
<!--    <td style="text-align:center"><a href="options-general.php?page=fast-micro-pay&amp;action=edit-service&amp;id=--><?php //echo $k?><!--">Edycja</a></td>-->
    <td style="text-align:center"><a href="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=codes&service_id='.$k); ?>">Kody / Dostępy</a></td>
    <td style="text-align:center"><a href="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=log&service_id='.$k); ?>">Log</a></td>
<!--    <td style="text-align:center"><a href="options-general.php?page=fast-micro-pay&amp;action=delete-service&amp;noheader=true&amp;id=--><?php //echo $k?><!--">Usuń</a></td>-->
</tr>

<?php endforeach;
            } ?>
                        </tbody>
                    </table>
    <p style="text-align:center; margin-top:20px;" class="fmp-sections-links">
        <input type="hidden" name="delete" value="1">
        <button type="submit" class="button action"><i class="dashicons dashicons-trash"></i> Usuń zaznaczone</button>
    </p>
</form>
        <p style="text-align:center; margin-top:20px;" class="fmp-bottom-legend">
            <span class="fmp-legend-item"><span class="dashicons dashicons-cart"></span><span class="fmp-legend-description">Zakup standardowy</span></span>
            <span class="fmp-legend-item"><span class="dashicons dashicons-heart"></span><span class="fmp-legend-description">Dotacja</span></span>
            <span class="fmp-legend-item"><span class="dashicons dashicons-tickets-alt"></span><span class="fmp-legend-description">Włączone kody rabatowe</span></span>
            <span class="fmp-legend-item"><span class="dashicons dashicons dashicons-media-spreadsheet"></span><span class="fmp-legend-description">Włączone dane do faktury</span></span>
            <span class="fmp-legend-item"><span class="dashicons dashicons-format-gallery"></span><span class="fmp-legend-description">Usługa grupowa</span></span>
        </p>





    <?php
    }


    public function admin_page_sets()
    {
        global $wpdb;
        $mode = 'add';
        if (!empty($_GET['action']) and $_GET['action'] == 'edit-set' and !empty($_GET['id']) and !empty($this->core->options['sets'][$_GET['id']])) {
            $set_data = $this->core->options['sets'][$_GET['id']];
            $mode = 'edit';
        }



        if (!empty($_POST['fast_micro_pay']['set']) and !empty($_POST['mode']) and in_array($_POST['mode'], array('add', 'edit'))) {
            $set_data = $this->core->limit_array($_POST['fast_micro_pay']['set'], array('name', 'service_id', 'info_box', 'info_box_second', 'status'));


            if (count(array_intersect(array_values(isset($set_data['service_id']) ? $set_data['service_id'] : array()), array_keys($this->core->options['services']))) == count(array_values(isset($set_data['service_id']) ? $set_data['service_id'] : array())) and ! empty($set_data['name'])) {
                if ($_POST['mode'] == 'add') {
                    $this->core->options['sets'][$this->core->options['sets_ai'] + 1] = stripslashes_deep($set_data);
                }

                if ($_POST['mode'] == 'edit' and !empty($_POST['fast_micro_pay']['set']['id']) and !empty($this->core->options['sets'][$_POST['fast_micro_pay']['set']['id']])) {
                    $this->core->options['sets'][$_POST['fast_micro_pay']['set']['id']] = stripslashes_deep($set_data);
                }

                update_option('fast_micro_pay', $this->core->options);
            }
        }

        if (! empty($_POST['delete'])) {
            if (!empty($_POST['set_id'])) {
                foreach ($_POST['set_id'] as $id) {
                    unset($this->core->options['sets'][(int) $id]);
                    $wpdb->delete($wpdb->prefix.'postmeta', array('meta_key' => 'fmp_set_id', 'meta_value' => (int)$id));
                }
            }
            update_option('fast_micro_pay', $this->core->options);
            wp_redirect(admin_url('options-general.php?page=fast-micro-pay&section=sets'), 302);
        }

        if (!empty($_GET['action']) and in_array($_GET['action'], array('toggle-set-status'))) {
            if ($_GET['action'] == 'toggle-set-status' and !empty($_GET['id']) and !empty($this->core->options['sets'][$_GET['id']])) {
                $this->core->options['sets'][(int) $_GET['id']]['status'] = empty($this->core->options['sets'][(int) $_GET['id']]['status']) ? 1 : 0;
            }
            update_option('fast_micro_pay', $this->core->options);
            wp_redirect(admin_url('options-general.php?page=fast-micro-pay&section=sets'), 302);
            exit;
        }


        $this->page_header(); ?>
        <script>
            jQuery(document).ready(function() {
                if (window.location.hash.substr(1) == 'add') {
                    jQuery('.fmp-add-set').show();
                }
            });
        </script>
        <hr>
        <h2><i class="dashicons dashicons-admin-page"></i> Pakiety</h2>


        <p style="text-align:center; margin-top:0px;" class="fmp-sections-links">
            <a href="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=sets#add'); ?>" class="button action fmp-button fmp-add-set-toggle"><span class="dashicons dashicons-plus-alt"></span> Dodaj pakiet</a>
        </p>
        <form method="post" class="postbox fmp-item-box <?php echo (!empty($set_data)) ? 'fmp-edit-set' : 'fmp-add-set'; ?>">
            <div class="inside">
            <input type="hidden" name="mode" value="<?php echo $mode; ?>">
		    <?php if ($mode == 'edit'): ?>
                <h3>Edytuj pakiet <?php echo $this->core->options['sets'][$_GET['id']]['name']; ?> [ID <?php echo $_GET['id']; ?>]</h3>
                <input type="hidden" name="fast_micro_pay[set][id]" value="<?php echo $_GET['id']; ?>">
                <input type="hidden" name="fast_micro_pay[set][status]" value="<?php echo @$set_data['status']?>">
		    <?php
            else:
                ?>
                <h3>Dodaj nowy pakiet</h3>
		    <?php endif; ?>
            <div class="fields" id="fmp-add-set-form">
                <div class="fmp-add-service">
                    <div class="fmp-item">
                        <label>Nazwa pakietu:<br><input type="text" name="fast_micro_pay[set][name]" value="<?php echo @$set_data['name']?>" placeholder="Np. SMS + PayU" required></label>
                    </div>
                    <div class="fmp-item">
                        <label>Usługi:</label><br>
                        <!-- <select name="fast_micro_pay[set][service_id][]" multiple> -->
					    <?php
                        foreach ($this->core->options['services'] as $k => $v) {
                            ?>
                            <label><input type="checkbox" name="fast_micro_pay[set][service_id][]" value="<?php echo($k) ?>"<?php echo @in_array($k, $set_data['service_id']) ? ' checked' : ''; ?>> <a href="options-general.php?page=fast-micro-pay&amp;action=edit-service&amp;id=<?php echo $k ?>"><i class="dashicons dashicons-edit"></i></a> <?php echo($v['name']) ?></label><br>
						    <?php
                        } ?>
                        <!-- </select> -->

                    </div>
                </div>
                <div class="fmp-add-service" style="clear:both;">

                    <div class="fmp-item-big">
                        <label>Treść okna zakupu:<br><textarea name="fast_micro_pay[set][info_box]" rows="2" cols="25" placeholder="" required><?php echo ($mode == 'edit') ? stripslashes(@$set_data['info_box']) : '' ?></textarea></label>
                    </div>
                    <div class="fmp-item-big">
                        <label>Treść kolejnego okna zakupu:<br><textarea name="fast_micro_pay[set][info_box_second]" rows="2" cols="25" placeholder=""><?php echo ($mode == 'edit') ? stripslashes(@$set_data['info_box_second']) : '' ?></textarea></label>
                    </div>
                </div>
            </div>
            </div>
            <p style="clear: both;padding-top:24px;; text-align:center;" class="submit"><input type="submit" name="submit_fmp" class="button-primary" value="Zapisz pakiet" /></p>
        </form>
<form method="POST" action="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=sets&noheader') ; ?>">
        <table class="wp-list-table widefat fmp-responsive-table">
                        <thead>
                            <tr style="">
                                <th style="width:30px; text-align:center;"><input type="checkbox" class="fmp-checkbox-all" style=" margin:0 4px 0 0;"></th>
                                <th style="width:20px; text-align:center">ID</th>
                                <th style="width:300px; text-align:center">Nazwa</th>
                                <th style="width:auto"></th>
                                <th style="width:150px; text-align:center">Ilość usług</th>
                                <th style="width:90px; text-align:center">Status</th>
<!--                                <th style="width:90px; text-align:center">Edycja</th>-->
                                <th style="width:110px; text-align:center">Kody / Dostępy</th>
                                <th style="width:40px; text-align:center">Log</th>
<!--                                <th style="width:80px; text-align:center">Usuń</th>-->
                            </tr>
                        </thead>
                        <tbody>
<?php
if (empty($this->core->options['sets'])) {
                            ?>
<tr>
<td colspan="12" style="text-align:center;">Brak zdefiniowanych pakietów</td>
</tr>
<?php
                        } else {
                            foreach ($this->core->options['sets'] as $k => $v): ?>


<tr class="<?php echo (!empty($_GET['id']) and $_GET['id']==$k) ? 'active' : ''; ?><?php echo (empty($v['status'])) ? ' fmp-disabled' : ''; ?>">
    <td style="text-align:center"><input type="checkbox" name="set_id[]" value="<?php echo $k ?>" class="fmp-checkbox"></td>
    <td style="text-align:center"><?php echo $k ?></td>
    <td style="text-align:left"><a href="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=sets&action=edit-set&id='.$k); ?>"><?php echo $v['name'] ?></a></td>
    <td></td>
    <td style="text-align:center"><?php echo count($v['service_id']) ?></td>
    <td style="text-align:center"><a href="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=sets&action=toggle-set-status&noheader=true&id='.$k); ?>"><?php echo (empty($v['status'])) ? '<span style="color:#a00">Wyłączony</span>' : '<span style="color:#006505">Włączony</span>'; ?></a></td>
<!--    <td style="text-align:center"><a href="--><?php //echo admin_url('options-general.php?page=fast-micro-pay&section=sets&action=edit-set&id='.$k);?><!--">Edycja</a></td>-->
    <td style="text-align:center"><a href="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=codes&set_id='.$k); ?>">Kody / Dostępy</a></td>
    <td style="text-align:center"><a href="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=log&set_id='.$k); ?>">Log</a></td>
<!--    <td style="text-align:center"><a href="options-general.php?page=fast-micro-pay&amp;section=sets&amp;action=delete-set&amp;noheader=true&amp;id=--><?php //echo $k?><!--">Usuń</a></td>-->
</tr>

<?php endforeach;
                        } ?>
                        </tbody>
                    </table>
    <p style="text-align:center; margin-top:20px;" class="fmp-sections-links">
        <input type="hidden" name="delete" value="1">
        <button type="submit" class="button action"><i class="dashicons dashicons-trash"></i> Usuń zaznaczone</button>
    </p>
</form>






<?php
    }


    public function admin_page_log()
    {
        if (!empty($_GET['set_id'])) {
            $service_id= (! empty($this->core->options['sets'][(int)$_GET['set_id']]['service_id'])) ? $this->core->options['sets'][(int)$_GET['set_id']]['service_id'] : array();
        } elseif (! empty($_GET['service_id'])) {
            $service_id=(int)$_GET['service_id'];
        } else {
            $service_id=null;
        }
        if (!empty($_GET['action'])) {
            if (!empty($_POST['mode']) and in_array((int) $_POST['mode'], array(14, 30))) {
                FastMicroPayLog::delete_older((int) $_POST['mode'], $_POST['service_id']);
            } elseif (isset($_POST['mode']) and (int) $_POST['mode'] == 0) {
                FastMicroPayLog::clear($service_id);
            }
            wp_redirect(admin_url('options-general.php?page=fast-micro-pay&section=log'), 302);
        }

        $logs = FastMicroPayLog::get($service_id, ((!empty($_GET['post_id']) ? $_GET['post_id'] : null)));
        $post_types = get_post_types(array(), 'objects');
        $this->page_header(); ?>
        <hr>
        <h2><i class="dashicons dashicons-list-view"></i> Log</h2>

            <table class="wp-list-table widefat fmp-responsive-table">
                            <thead>
                                <tr style="">
                                    <th class="lp">Lp.</th>
                                    <th class="id">ID</th>
                                    <th class="service">Usługa</th>
                                    <th style="width:auto;">Wpis</th>
                                    <th style="width:150px; text-align:center">Typ</th>
                                    <th style="width:auto; text-align:center">Komentarz</th>
                                    <th class="ip">Adres IP</th>
                                    <th class="expired-to">Data</th>
                                </tr>
                            </thead>
                            <tbody>
    <?php
    if (empty($logs)) {
        ?>
    <tr>
    <td colspan="9" style="text-align:center;">Log jest pusty</td>
    </tr>
    <?php
    } else {
        $lp = 0;
        foreach ($logs as $log): ?>

<?php ++$lp; ?>
    <tr>
        <td style="text-align:center"><?php echo $lp ?></td>
        <td style="text-align:center"><?php echo $log->id ?></td>
        <td style="text-align:center"><?php echo @$this->core->options['services'][$log->service_id]['name'] ?></td>
        <td><?php echo ($log->post_title == null) ? 'Brak posta' : '<a href="'.get_site_url().'/?p='.$log->post_id.'"><i class="dashicons dashicons-admin-links fmp-dashicon"></i></a> <a href="'.admin_url('post.php?post='.$log->post_id.'&action=edit').'">'.$log->post_title.'</a>'; ?></td>
        <td style="text-align:center"><?php echo (!empty($this->status[$log->type])) ? $this->status[$log->type] : $log->type; ?></td>
        <td style="text-align:center"><?php echo $log->comment ?></td>
        <td style="text-align:center"><?php echo $log->ip ?></td>
        <td style="text-align:center"><?php echo $log->created_at ?></td>
    </tr>

    <?php endforeach;
    } ?>
                            </tbody>
                        </table>
<?php  if (FastMicroPayLog::count() > 0): ?>

                        <form style="text-align:center; margin-top:10px;" class=" fmp-sections-links" action="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=log&action=clear&noheader'); ?>" method="POST">
                            <?php if (!empty($service_id)) : ?>
                            <input type="hidden" name="service_id" value="<?php echo $service_id; ?> ">
                            <?php endif; ?>
                            <button type="submit" class="button action" value="14" name="mode"><i class="dashicons dashicons-trash"></i>Wyczyść starsze niż 14 dni</button>
                            <button type="submit" class="button action" value="30" name="mode"><i class="dashicons dashicons-trash"></i>Wyczyść starsze niż 30 dni</button>
                            <button type="submit" class="button action" value="0" name="mode"><i class="dashicons dashicons-trash"></i>Wyczyść cały log</button>
                        </form>

<?php endif; ?>


<?php
    }

    public function admin_page_stats()
    {
        global $wpdb;
        $stats = $wpdb->get_results("SELECT posts.id, posts.post_title, posts.post_type, SUM(codes.price) AS earnings, COUNT(*) AS codes_count FROM `{$wpdb->prefix}fast_micro_pay_codes` AS codes LEFT JOIN `{$wpdb->prefix}posts` AS posts ON (posts.id=codes.post_id AND codes.paid_at is NOT NULL)  WHERE posts.id IS NOT NULL  GROUP BY posts.id ORDER BY earnings DESC", OBJECT);
        $this->page_header(); ?>
        <hr>
        <h2><i class="dashicons dashicons-chart-pie"></i> Statystyki</h2>
<table class="wp-list-table widefat fmp-responsive-table">
                <thead>
                    <tr style="">
                        <th style="width:30px; text-align:center">Lp.</th>
                        <th style="width:30px; text-align:center">ID</th>
                        <th style="width:auto;">Wpis</th>
                        <th style="width:100px; text-align:center">Typ wpisu</th>
                        <th></th>
                        <th style="width:100px; text-align:center">Zamówienia</th>
                        <th style="width:100px; text-align:center">Przychód</th>
                    </tr>
                </thead>
                <tbody>
<?php
if (empty($stats)) {
            ?>
<tr>
<td colspan="7" style="text-align:center;">Statystyki są puste</td>
</tr>
<?php
        } else {
            $lp = 0;
            $now = time();
            //var_dump($this->core);
            foreach ($stats as $stat): ?>
<?php
++$lp; ?>

<tr>
<td style="text-align:center"><?php echo $lp ?></td>
<td style="text-align:center"><?php echo $stat->id ?></td>
<td><?php echo '<a href="'.get_site_url().'/?p='.$stat->id.'"><i class="dashicons dashicons-admin-links fmp-dashicon"></i></a> <a href="'.admin_url('post.php?post='.$stat->id.'&action=edit').'">'.$stat->post_title.'</a>'; ?></td>
<td style="text-align:center"><?php echo ($stat->post_type == null or empty($this->post_types[$stat->post_type])) ? '-' : '<a href="'.admin_url('edit.php?post_type='.$stat->post_type).'">'.$this->post_types[$stat->post_type]->labels->singular_name.'</a>'  ?></td>
<td></td>
<td style="text-align:center"><?php echo $stat->codes_count ?></td>
<td style="text-align:center"><?php echo $stat->earnings ?></td>
</tr>

<?php endforeach;
        } ?>
                </tbody>
            </table>


<?php
    }

    public function admin_page_codes()
    {
        global $wpdb;

        if (!empty($_GET['set_id'])) {
            $service_id= (! empty($this->core->options['sets'][(int)$_GET['set_id']]['service_id'])) ? $this->core->options['sets'][(int)$_GET['set_id']]['service_id'] : array();
        } elseif (! empty($_GET['service_id'])) {
            $service_id=(int)$_GET['service_id'];
        } else {
            $service_id=null;
        }
        if (!empty($_POST['action']) and $_POST['action']=='add_code' and ! empty($_POST['code']) and !empty($this->core->options['services'][$service_id])) {
            $posts=array();
            if (! empty($_POST['post_id'])) {
                $posts=explode(',', $_POST['post_id']);
                $posts=array_map(function ($i) {
                    return (int)trim($i);
                }, $posts);
                $posts=array_filter($posts, function ($i) {
                    return ! empty($i);
                });
                $posts=array_unique($posts);
            }

            if (count($posts)==0) {
                $posts=array(0);
            }

            foreach ($posts as $post_id) {
                $code=FastMicroPayCodes::save($service_id, $post_id, trim($_POST['code']), 0, '', '', 2);
                FastMicroPayCodes::pay($code);
            }
            wp_redirect(admin_url('options-general.php?page=fast-micro-pay&section=codes&service_id=' . $service_id), 302);
            exit;
        }
        if (!empty($_POST['code-id']) and is_array($_POST['code-id'])) {
            foreach ($_POST['code-id'] as $code_id) {
                $x = $wpdb->delete($wpdb->prefix.'fast_micro_pay_codes', array('id' => $code_id), array('id' => '%d'));
                //var_dump($x); exit;
            }
            wp_redirect(admin_url('options-general.php?page=fast-micro-pay&section=codes'), 302);
            exit;
        } elseif (!empty($_GET['noheader']) and $_GET['noheader'] == 'true') {
            wp_redirect(admin_url('options-general.php?page=fast-micro-pay&section=codes'), 302);
            exit;
        }
        $codes = FastMicroPayCodes::get($service_id, ((!empty($_GET['post_id']) ? (int) $_GET['post_id'] : null)), $this->core->options['services'], null, ((isset($_GET['active']) and in_array($_GET['active'], array('1', '0'))) ? $_GET['active'] : null), true);
//        var_dump($codes);
        $post_types = get_post_types(array(), 'objects');
        $this->page_header(); ?>
        <hr>
        <h2><i class="dashicons dashicons-lock"></i> Kody / Dostępy<?php if (! empty($service_id) and ! empty($this->core->options['services'][$service_id])) {
            echo(' ('.$this->core->options['services'][$service_id]['name'].')');
        } elseif (! empty($_GET['set_id']) and ! empty($this->core->options['sets'][$_GET['set_id']])) {
            echo(' ('.$this->core->options['sets'][$_GET['set_id']]['name'].')');
        } ?></h2>

    <?php
//        if (FastMicroPayCodes::count() > 0):
        if (count($codes) > 0 or isset($_GET['active'])):
            ?>

                            <p style="text-align:center; margin-top:0px;" class="fmp-sections-links">
                                Wyświetl:
                                <a href="<?php echo admin_url('options-general.php?page=fast-micro-pay&amp;section=codes'.((!empty($_GET['service_id'])) ? '&amp;service_id='.(int) $_GET['service_id'] : '').((!empty($_GET['post_id'])) ? '&amp;post_id='.(int) $_GET['post_id'] : '')); ?>" class="button<?php echo((!isset($_GET['active'])) ? '-primary' : ''); ?> action">Wszystkie</a>
                                <a href="<?php echo admin_url('options-general.php?page=fast-micro-pay&amp;section=codes'.((!empty($_GET['service_id'])) ? '&amp;service_id='.(int) $_GET['service_id'] : '').((!empty($_GET['post_id'])) ? '&amp;post_id='.(int) $_GET['post_id'] : '').'&amp;active=1'); ?>" class="button<?php echo((isset($_GET['active']) and $_GET['active']=='1') ? '-primary' : ''); ?> action"><i class="dashicons dashicons-yes" style="color: #006505"></i>Aktywne</a>
                                <a href="<?php echo admin_url('options-general.php?page=fast-micro-pay&amp;section=codes'.((!empty($_GET['service_id'])) ? '&amp;service_id='.(int) $_GET['service_id'] : '').((!empty($_GET['post_id'])) ? '&amp;post_id='.(int) $_GET['post_id'] : '').'&amp;active=0'); ?>" class="button<?php echo((isset($_GET['active']) and $_GET['active']=='0') ? '-primary' : ''); ?> action"><i class="dashicons dashicons-no" style="color: #a00"></i>Przedawnione</a>
                                <button type="button" class="button action toggle-invoice-info"><i class="dashicons dashicons-media-spreadsheet"></i>Pokaż szczegóły</button>
                            </p>

    <?php endif; ?>

        <?php if (! empty($service_id) and ! empty($this->core->options['services'][$service_id]) and empty($this->core->options['services'][$service_id]['donation'])):  ?>
<form action="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=codes&service_id='.$service_id.'&noheader=true'); ?>" method="POST">
    <div class="postbox add-code-container">
        <?php if (in_array($this->core->options['services'][$service_id]['provider'], array('dotpay-transfer','payu','tpay-online','przelewy24'))): ?>
            <label>Dodaj nowy dostęp: <input type="email" value="" class="regular-text" name="code" placeholder="E-mail" style="width:200px" required><?php if (empty($this->core->options['services'][$service_id]['collective'])): ?><input type="text" title="Podaj ID postu dla którego chcesz przydzielić dostęp. Możesz podać kilka numerów ID po przecinku." class="regular-text" name="post_id" placeholder="ID postu" style="width:120px" required><?php endif; ?><input class="button-primary" type="submit" value="Zapisz"></label>
        <?php else: ?>
            <label>Dodaj nowy dostęp: <input type="text" title="Podaj kod dostępu do usługi. Powinien mieć równo 8 znaków (dopuszczalne są tylko litery i cyfry)"  pattern="[a-zA-Z0-9-]{8}" maxlength="8" value="" class="regular-text" name="code" placeholder="Kod (8 znaków)" style="width:200px" required><span class="dashicons dashicons-editor-textcolor generate" title="Wygeneruj losowy kod"></span><?php if (empty($this->core->options['services'][$service_id]['collective'])): ?><input type="text" title="Podaj ID postu dla którego chcesz przydzielić dostęp. Możesz podać kilka numerów ID po przecinku." class="regular-text" name="post_id" placeholder="ID postu" style="width:120px" required><?php endif; ?><input class="button-primary" type="submit" name="Example" value="Zapisz"></label>
        <?php endif; ?>

            <!-- .inside -->
        <input type="hidden" name="action" value="add_code">
    </div>
</form>
<?php endif; ?>
<form action="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=codes&noheader=true'); ?>" method="POST">
            <table class="wp-list-table widefat fmp-responsive-table">
                            <thead>
                                <tr style="">
                                    <th style="width:30px; text-align:center;"><input type="checkbox" class="fmp-checkbox-all" style=" margin:0 4px 0 0;"></th>
                                    <th class="lp">Lp.</th>
                                    <th class="id">ID</th>
                                    <th class="service">Usługa</th>
                                    <th style="width:auto;">Wpis</th>
                                    <th class="code-email">Kod/email</th>
                                    <th class="status">Status</th>
                                    <th style="width:140px; text-align:center">Trans.</th>
                                    <th style="width:20px; text-align:center"><span class="dashicons dashicons-info"></span></th>
                                    <th class="expired-from">Ważne od</th>
                                    <th class="expired-to">Ważne do</th>
                                </tr>
                            </thead>
                            <tbody>
    <?php

    if (empty($codes)) {
        ?>
    <tr>
    <td colspan="11" style="text-align:center;">Lista kodów jest pusta</td>
    </tr>
    <?php
    } else {
        $lp = 0;
        $now = time();
        foreach ($codes as $code): ?>
<?php
++$lp;
        $code->created_at_timestamp = strtotime($code->created_at, time());
        $code->expired_at_timestamp = $code->created_at_timestamp + $this->core->options['services'][$code->service_id]['expiration_time'] * 24 * 60 * 60;
        $user_info=json_decode($code->user_info, true);
        if (! empty($code->user_info) and ! empty($user_info['firstname'])) {
            $invoice_info='<div class="fmp-invoice-info"><strong>' . @$user_info['firstname'] . ' ' . @$user_info['lastname'] . '</strong><br />' . @$user_info['street'] . ' ' . @$user_info['street_n1'] . ' ' . @$user_info['street_n2'] . '<br />' . @$user_info['postcode'] . ' ' . @$user_info['city'] . ((! empty($user_info['nip'])) ? '<br>NIP: ' . $user_info['nip'] : ''). '</div>';
        } else {
            $invoice_info='';
        } ?>
    <tr>
        <td style="text-align:center"><input type="checkbox" name="code-id[]" value="<?php echo $code->id ?>" class="fmp-checkbox"></td>
        <td style="text-align:center"><?php echo $lp ?></td>
        <td style="text-align:center"><?php echo $code->id ?></td>
        <td style="text-align:center"><?php echo (empty($this->core->options['services'][$code->service_id]['name'])) ? '-' : '<a href="' . admin_url('options-general.php?page=fast-micro-pay&action=edit-service&id='.$code->service_id) . '">'.$this->core->options['services'][$code->service_id]['name'] . '</a>'; ?></td>
        <td><?php echo ($code->post_title == null) ? 'Brak posta' : '<a href="'.get_site_url().'/?p='.$code->post_id.'"><i class="dashicons dashicons-admin-links fmp-dashicon"></i></a> <a href="'.admin_url('post.php?post='.$code->post_id.'&action=edit').'">'.$code->post_title.'</a>'; ?></td>
        <td style="text-align:center;font-weight:bold;"><?php echo $code->code ?></td>
        <td style="text-align:center"><?php echo ($code->expired_at_timestamp > current_time('timestamp')) ? '<i class="dashicons dashicons-yes" style="color:#006505"></i>' : '<i class="dashicons dashicons-no" style="color: #a00"></i>'; ?></td>
        <td style="text-align:center; width: 140px;"><span style="font-size:0.8em;"><?php echo $code->transaction . ((! empty($invoice_info)) ? $invoice_info : ''); ?></span></td>
        <td style="text-align:center; width: 20px;"><span class="dashicons <?php echo((! empty($code->promo_id)) ? 'dashicons-tickets-alt' : ((empty($code->type)) ? 'dashicons-cart' : (($code->type==1) ? 'dashicons-heart' : 'dashicons-share-alt2'))); ?>"></span></td>
        <td style="text-align:center"><span title="<?php echo $code->created_at ?>"><?php echo substr($code->created_at, 0, 10); ?></span></td>
        <td style="text-align:center"><?php $expired_to=date('Y-m-d H:i:s', strtotime($code->created_at) + $this->core->options['services'][$code->service_id]['expiration_time'] * 24 * 60 * 60) ?><span title="<?php echo $expired_to; ?>"><?php echo substr($expired_to, 0, 10); ?></span></td>
    </tr>

    <?php endforeach;
    } ?>
                            </tbody>
                        </table>
                        <p style="text-align:center; margin-top:20px;" class="fmp-sections-links">

                                <button type="submit" class="button action"><i class="dashicons dashicons-trash"></i> Usuń zaznaczone</button>
                                                    </p>
    <p style="text-align:center; margin-top:20px;" class="fmp-bottom-legend">
        <span class="fmp-legend-item"><span class="dashicons dashicons-tickets-alt"></span><span class="fmp-legend-description">Zakup przy użyciu kodu rabatowego</span></span>
        <span class="fmp-legend-item"><span class="dashicons dashicons-cart"></span><span class="fmp-legend-description">Zakup standardowy</span></span>
        <span class="fmp-legend-item"><span class="dashicons dashicons-heart"></span><span class="fmp-legend-description">Dotacja</span></span>
        <span class="fmp-legend-item"><span class="dashicons dashicons-share-alt2"></span><span class="fmp-legend-description">Dostęp przydzielony</span></span>
    </p>
</form>






<?php
    }
    public function admin_page_promos()
    {
        if (!empty($_GET['action']) and $_GET['action']=='edit-promo' and ! empty($_GET['id'])) {
            $selected_promo=FastMicroPayPromos::getOne($_GET['id']);
        }
        if (! empty($_POST['save']) and ! empty($_POST['promo'])) {
            $promo_codes=explode("\n", trim($_POST['promo']['promo']));
            $promo_codes=array_filter($promo_codes, function ($i) {
                return ! (empty(trim($i)) or strlen(trim($i))<3);
            });

            if (! empty($selected_promo)) {
                $promo_array=array_filter($_POST['promo'], function ($k) {
                    return in_array($k, array('name', 'max_usage', 'expires_at', 'price'));
                }, ARRAY_FILTER_USE_KEY);

                $promo_array['max_usage']=((empty($promo_array['max_usage'])) ? null : $promo_array['max_usage']);
                $promo_array['expires_at']=((empty($promo_array['expires_at'])) ? null : $promo_array['expires_at']);
                FastMicroPayPromos::update($selected_promo['id'], $promo_array);
            } elseif (!empty($promo_codes)) {
                $promo_array=array_filter($_POST['promo'], function ($k) {
                    return in_array($k, array('service_id','name', 'max_usage', 'expires_at', 'price'));
                }, ARRAY_FILTER_USE_KEY);
                foreach ($promo_codes as $promo) {
                    FastMicroPayPromos::add(array_merge($promo_array, array('promo' => strtoupper($promo))));
                }
            }
            wp_redirect(admin_url('options-general.php?page=fast-micro-pay&section=promos' . ((! empty($selected_promo)) ? '&action=edit-promo&id=' . $selected_promo['id'] : '#add')), 302);
        } elseif (! empty($_POST['delete'])) {
            if (!empty($_POST['promo_id'])) {
                foreach ($_POST['promo_id'] as $id) {
                    FastMicroPayPromos::delete($id);
                }
            }
            wp_redirect(admin_url('options-general.php?page=fast-micro-pay&section=promos'), 302);
        }
        $this->page_header(); ?>
        <script>
            jQuery(document).ready(function() {
                if (window.location.hash.substr(1) == 'add') {
                    jQuery('.fmp-add-promo').show();
                }
            });
        </script>
        <hr>
        <h2><i class="dashicons dashicons-tickets-alt"></i> Kody rabatowe</h2>
        <p style="text-align:center; margin-top:0px;" class="fmp-sections-links">
            <a href="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=promos#add'); ?>" class="button action fmp-button fmp-add-promo-toggle"><span class="dashicons dashicons-plus-alt"></span> Dodaj kody rabatowe</a>
        </p>
        <form class="postbox fmp-item-box <?php echo (!empty($selected_promo['name'])) ? 'fmp-edit-promo' : 'fmp-add-promo'; ?>" method="POST" action="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=promos' . ((! empty($selected_promo)) ? '&action=edit-promo&id=' . $selected_promo['id'] : '') . '&noheader') ; ?>">
<input type="hidden" name="save" value="1">
            <h2><?php echo (!empty($selected_promo['name'])) ? 'Edytuj kod rabatowy ' . $selected_promo['name']. ' [ID ' . $selected_promo['id'] . ']' : 'Dodaj nowy kod rabatowy'; ?></h2>

            <div class="inside">
                <div class="fmp-item">
                    <label>Nazwa<span class="required">*</span>:<br><input type="text" title="Nazwa kodu rabatowego wyświetlana w panelu administracyjnym" name="promo[name]" value="<?php echo @$selected_promo['name']; ?>" placeholder="Np. Rabat świąteczny" required></label>
                </div>
<!--                <div class="fmp-item">-->
<!--                    <label>Kod rabatowy<span class="required">*</span>:<br><input type="text" title="Kod rabatowy do przekazania użytkownikom" name="promo[promo]" value="--><?php //echo @$selected_promo['promo'];?><!--" placeholder="Np. SWIETA2018" required></label>-->
<!--                </div>-->
                <div class="fmp-item">
                    <label>Usługa<?php echo((empty($selected_promo['service_id'])) ? '<span class="required">*</span>': '') ?>:<br>
<?php
if (!empty($selected_promo['service_id'])) {
            if (!empty($this->core->options['services'][$selected_promo['service_id']])) { ?>
                        <select style="width:183px;" disabled>
                            <option><?php echo $this->core->options['services'][$selected_promo['service_id']]['name']; ?></option>
                        </select>
    <?php } else { ?>
        <span class="dashicons dashicons-minus"></span>
    <?php }
        } else { ?>
    <select style="max-width:183px;" name="promo[service_id]" required>
        <option value="">Wybierz usługę</option>
		<?php
        $allowed_services=array_filter((empty($this->core->options['services']) ? array() : $this->core->options['services']), function ($i) {
            return in_array($i['provider'], array('dotpay-transfer','payu','tpay-online','przelewy24'));
        });
        foreach ($allowed_services as $k=>$v): ?>
            <option style="color: <?php echo($v['status'] == 1) ? '#006505' : '#a00'; ?> " value="<?php echo $k ?>"<?php echo((!empty($selected_promo['service_id']) and $k==$selected_promo['service_id']) ? ' selected' : '') ?>><?php echo $v['name']; ?></option>
		<?php endforeach; ?>
    </select>
<?php } ?>
                    </label>
                </div>
                <div class="fmp-item">
                    <label>Cena<span class="required">*</span>:<br><input type="number" title="Cena dostępu po zastosowaniu kodu rabatowego" min="0.01" step="0.01" name="promo[price]" value="<?php echo @$selected_promo['price']; ?>" placeholder="Np. 10.00" required></label>
                </div>
                <div class="fmp-item">
		            <?php
                    if (empty($selected_promo)) : ?>
                        <label style="float:left;">Kod rabatowy<span class="required">*</span>:<br>
                            <textarea title="Kod rabatowy do przekazania użytkownikom" name="promo[promo]" style="max-width: 160px; text-transform: uppercase" required></textarea>
                        </label>
                        <div style="float:left; padding-top:18px; padding-left:5px; line-height: 25px;"><span class="dashicons dashicons-info" title="Możesz podać kilka kodów rabatowych - każdy w nowym wierszu"></span><br><span class="dashicons dashicons-editor-textcolor generate-promo-code" title="Kliknij, aby wygenerować losowy kod"></span> </div>
		            <?php else:  ?>
                        <label style="float:left;">Kod rabatowy:<br>
                            <input type="text" value="<?php echo $selected_promo['promo']; ?>" disabled>
                        </label>
		            <?php endif ?>
                </div>
                <div class="fmp-item">
                    <label>Maksymalna ilośc użyć<span class="required">*</span>:<br><input type="number"  class="optional" data-default="1" title="Ile razy maksymalnie kod rabatowy może zostać użyty" min="1" name="promo[max_usage]" placeholder="Np. 10" <?php echo((isset($selected_promo) and is_null($selected_promo['max_usage'])) ? ' value="" disabled' : ' value="' . ((!isset($selected_promo)) ? "1" : $selected_promo['max_usage']).'"'); ?>></label> <label><input type="checkbox" value="1" name="promo[max_usage_unlimited]" <?php echo((isset($selected_promo) and is_null($selected_promo['max_usage'])) ? ' checked' : '') ?>> Bez limitu</label>
                </div>
                <div class="fmp-item">
                    <label>Ważny do<span class="required">*</span>:<br><input type="text" class="optional" data-default="" title="Do kiedy kod rabatowy może zostać użyty" name="promo[expires_at]" placeholder="Np. 2018-03-29" <?php echo((isset($selected_promo) and is_null($selected_promo['expires_at'])) ? ' value="" disabled' : ' value="' . substr(@$selected_promo['expires_at'], 0, 16) . '"') ?> required></label> <label><input type="checkbox" value="1" name="promo[expires_at_unlimited]" <?php echo((isset($selected_promo) and is_null($selected_promo['expires_at'])) ? ' checked' : '') ?>> Bez limitu</label>
                </div>
            </div>
            <p style="width:100%;clear:both;text-align: center">
                <button type="submit" class="button-primary action fmp-button">Zapisz kod rabatowy</button>
            </p>
            <!-- .inside -->

        </form>
	    <?php
        $promos = FastMicroPayPromos::getList();
        //	    var_dump( $promos );?>
        <form method="POST" action="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=promos&noheader') ; ?>">
<table class="wp-list-table widefat fmp-responsive-table">
    <thead>
    <tr>
        <th style="width:30px; text-align:center;"><input type="checkbox" class="fmp-checkbox-all" style=" margin:0 4px 0 0;"></th>
        <th class="lp">Lp.</th>
        <th class="id">ID</th>
        <th class="name">Nazwa</th>
        <th class="service">Usługa</th>
        <th class="price">Cena</th>
        <th class="icon"><span class="dashicons dashicons-yes"></span></th>
        <th class="promo">Kod</th>
        <th class="max-usage">Max użyć</th>
        <th class="usage-count">Zużyto</th>
        <th class="income">Przychód</th>
        <th class="expired-from">Utworzono</th>
        <th class="expires-at">Ważny do</th>
    </tr>
    </thead>
    <tbody>
    <?php

    if (count($promos)==0) : ?>
    <tr>
        <td colspan="13" style="text-align:center;">Brak zdefiniowanych kodów rabatowych</td>
    </tr>
    <?php else:
    $lp = 0;
        foreach ($promos as $promo):
        $lp++; ?>
    <tr<?php echo  (!empty($selected_promo['id']) and $selected_promo['id']==$promo['id']) ? ' class="active"' : ''; ?>>
        <td style="text-align:center"><input type="checkbox" name="promo_id[]" value="<?php echo $promo['id'] ?>" class="fmp-checkbox"></td>
        <td style="text-align:center"><?php echo $lp ?></td>
        <td style="text-align:center"><?php echo $promo['id']; ?></td>
        <td style="max-width:180px; display: block;"><a href="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=promos&action=edit-promo&id='.$promo['id']) ?>"><?php echo $promo['name']; ?></a></td>
        <td style="text-align:center"><?php echo((!empty($this->core->options['services'][$promo['service_id']])) ? '<a href="'.admin_url('options-general.php?page=fast-micro-pay&action=edit-service&id='.$promo['service_id']).'">'.$this->core->options['services'][$promo['service_id']]['name'].'</a>' : '<span class="dashicons dashicons-minus"></span>') ; ?></td>
        <td style="text-align:center"><?php echo number_format($promo['price'], 2, ',', ' '); ?></td>
        <td style="text-align:center;"><?php echo(((bool)$promo['is_expired'] || (bool)$promo['is_used']) ? '<span class="dashicons dashicons-no" style="color: #a00"></span>' : '<span class="dashicons dashicons-yes" style="color: #006505"></span>'); ?></td>
        <td class="promo-code-value" style="text-align: left; width:auto;"><?php echo $promo['promo']; ?></td>
        <td style="text-align: center; font-weight:bold;"><?php echo(!empty($promo['max_usage']) ? $promo['max_usage'] : '<span class="dashicons dashicons-minus"></span>') ; ?></td>
        <td style="text-align: center; font-weight:bold;<?php echo(((bool)$promo['is_used']) ? '; color: #a00' : ''); ?>"><?php echo $promo['usage_count']; ?></td>
        <td style="text-align: center; font-weight:bold;"><?php echo number_format($promo['income'], 2, ',', ' ') ?></td>
        <td style="text-align: center"><?php echo substr($promo['created_at'], 0, 10); ?></td>
        <td style="text-align: center;<?php echo(((bool)$promo['is_expired']) ? '; color: #a00' : ''); ?>"><?php echo(!empty($promo['expires_at']) ? substr($promo['expires_at'], 0, 16) : '<span class="dashicons dashicons-minus"></span>') ; ?></td>
    </tr>
     <?php endforeach; ?>
     <?php endif; ?>
    </tbody>
</table>
        <p style="text-align:center; margin-top:20px;" class="fmp-sections-links">
<input type="hidden" name="delete" value="1">
            <button type="submit" class="button action"><i class="dashicons dashicons-trash"></i> Usuń zaznaczone</button>
        </p>
        </form>
	    <?php
    }
}
?>
