<?php

class FastMicroPayCodes
{
    public static function save($service_id, $post_id, $code, $price, $transaction='', $user_info='', $type=0)
    {
        global $wpdb;
        $code = $wpdb->insert($wpdb->prefix.'fast_micro_pay_codes', array('service_id' => $service_id, 'post_id' => $post_id, 'code' => $code, 'transaction' => $transaction, 'price' => $price, 'user_info' => $user_info, 'type' => $type, 'created_at' => date('Y-m-d H:i:s', current_time('timestamp'))));
        return $wpdb->insert_id;
    }

    public static function getOne($id)
    {
	    global $wpdb;
	    return $wpdb->get_row($wpdb->prepare("SELECT * FROM {$wpdb->prefix}fast_micro_pay_codes WHERE id=%d", array($id)), ARRAY_A);
    }


    public static function get($service_id, $post_id, $services, $transaction, $active, $paid=null, $type=null)
    {
        global $wpdb;
        $query = self::where($service_id, $post_id, $services, $transaction, $active, $paid, $type, true);
        $codes = $wpdb->get_results("SELECT codes.*, posts.post_title, posts.post_type FROM {$wpdb->prefix}fast_micro_pay_codes AS codes LEFT JOIN {$wpdb->prefix}posts AS posts ON posts.id=codes.post_id $query ORDER BY codes.id DESC", OBJECT);

        return $codes;
    }

    public static function pay($code_id)
    {
    	return self::update($code_id,array('paid_at'=>current_time( 'mysql' )));
    }

    public static function update($code_id, $update)
    {
        global $wpdb;

	    return $wpdb->update(
		    $wpdb->prefix.'fast_micro_pay_codes',
		    $update,
		    array( 'id' => $code_id )
	    );
    }

    public static function clear()
    {
        global $wpdb;
        $wpdb->query("TRUNCATE TABLE {$wpdb->prefix}fast_micro_pay_codes");
    }

    public static function delete_older($days)
    {
        global $wpdb;
        $wpdb->query("DELETE FROM {$wpdb->prefix}fast_micro_pay_codes WHERE created_at < '".date('Y-m-d H:i:s', (current_time('timestamp') - (int) $days * 24 * 60 * 60))."'");
    }

    public static function count($service_id = null, $post_id = null, $paid=null, $type=null)
    {
        global $wpdb;
        $query = self::where($service_id, $post_id, null, null, null, $paid, $type, true);

        return $wpdb->get_var("SELECT COUNT(*) as codes_count FROM {$wpdb->prefix}fast_micro_pay_codes $query");

    }

    public static function earnings($service_id = null, $post_id = null)
    {
        global $wpdb;
	    $query = self::where($service_id, $post_id, null, null, null, true, array(0, 1),  true);
        return $wpdb->get_var("SELECT IF(ISNULL(SUM(price)),0,SUM(price)) as earnings FROM {$wpdb->prefix}fast_micro_pay_codes $query");
    }

    public static function delete($delete)
    {
        global $wpdb;
        $wpdb->delete($wpdb->prefix.'fast_micro_pay_codes', $delete);
    }

    public static function delete_post_codes($post_id)
    {
        self::delete(array('post_id' => $post_id));
    }

    public static function delete_service_codes($service_id)
    {
        self::delete(array('service_id' => $service_id));
    }

    public static function where($service_id, $post_id, $services, $transaction, $active, $paid, $type, $where = false)
    {
    	global $wpdb;
        $query = array();

        if(is_array($service_id))
        {
	        $service_id=array_map('intval', $service_id);
	        if(! empty($service_id))
            {
                $query[] = 'service_id IN(' . implode(',', $service_id). ')';
            }
            else
            {
                $query[] = 'service_id = 0';
            }
        }
        elseif( ! is_null($service_id))
        {
            $query[] = 'service_id='.(int) $service_id;
        }


        if (!empty($post_id)) {
            $query[] = 'post_id='.(int) $post_id;
        }

        if (!empty($transaction)) {
            $query[] =$wpdb->prepare('transaction=%s', array($transaction));
        }

	    if ($paid===false) {
		    $query[] = 'paid_at is null' ;
	    } elseif ($paid===true) {
		    $query[] = 'paid_at is not null' ;
	    }
	    if (!is_null($type)) {
        	if(!is_array($type))
	        {
	        	$type=array($type);
	        }
		    $type=array_map('intval', $type);
		    $query[] = 'type IN(' . implode(',', $type). ')' ;
	    }

        $services_query = array();
        if ($active !== null) {
            foreach ($services as $k=>$v) {
                $services_query[] = '(service_id='.(int) $k.' AND created_at '.(($active == '1') ? '>=' : '<').' \''. date('Y-m-d H:i:s', (current_time('timestamp') - (int) $v['expiration_time'] * 24 * 60 * 60)) .'\' )';
            }
        }

        if(! empty($services_query))
        {
            $query[]='(' . implode('OR', $services_query) . ')';
        }

        if (empty($query)) {
            return '';
        }

        return (($where) ? 'WHERE ' : '').implode(' AND ', $query);
    }

	public static function clean()
	{
		global $wpdb;
		$wpdb->query('DELETE FROM ' . $wpdb->prefix . 'fast_micro_pay_codes WHERE paid_at is null AND created_at < NOW() - INTERVAL 1 MONTH ');
	}
}
