<?php

class FastMicroPayEditor extends FastMicroPay
{
    public function __construct($core)
    {
        $this->core=$core;
//        add_action( 'admin_head', array($this, 'fmp_add_editor_button'));
        add_filter( 'mce_buttons', array($this, 'fmp_register_editor_button'));
        add_filter( 'mce_external_plugins', array($this, 'fmp_add_editor_plugin') );

        add_filter( 'tiny_mce_before_init', array($this, 'fmp_add_editor_formats' ));
        add_action( 'admin_init', array($this, 'fmp_add_editor_css' ));
        add_action( 'add_meta_boxes', array($this, 'fmp_add_post_box' ));
        add_action( 'save_post', array($this, 'save_post_class_meta'), 10, 2 );
        add_action( 'admin_print_footer_scripts', array($this, 'fmp_add_text_editor_button') );
        //add_filter( 'mce_external_plugins', array($this, "fmp_add_editor_plugin"));




    }

//    public function fmp_add_editor_button()
//    {
//        global $typenow;
//        if ( ! current_user_can( 'manage_options' ) ) {
//            return;
//        }
//        if( ! in_array( $typenow, $this->core->post_types ) )
//            return;
//        if ( get_user_option('rich_editing') == 'true') {
//            //add_filter('mce_buttons', array($this, 'fmp_register_editor_button'));
//            //add_filter("mce_external_plugins", array($this, "fmp_add_editor_plugin"));
//        }
//    }



    function fmp_add_editor_plugin($plugin) {
        global $typenow;
        if ( ! current_user_can( 'manage_options' ) ) {
            return $plugin;
        }
        if( ! in_array( $typenow, $this->core->post_types ) )
            return $plugin;
        $plugin['fmp_editor_button'] = plugins_url( '/js/tmce-button.js?ver=' . $this->core->get_version(), __FILE__ ); // CHANGE THE BUTTON SCRIPT HERE
        return $plugin ;
    }


    function fmp_register_editor_button($buttons) {
        global $typenow;
        if ( ! current_user_can( 'manage_options' ) ) {
            return $buttons;
        }
        if( ! in_array( $typenow, $this->core->post_types ) )
            return $buttons;
       array_push($buttons, "fmp_editor_button");
       if($this->core->check_type('webinar') OR $this->core->check_type('demo'))
       {
           array_push($buttons, "fmp_clickwebinar_editor_button");
       }
       if($this->core->check_type('getresponse') OR $this->core->check_type('demo'))
       {
           array_push($buttons, "fmp_getresponse_editor_button");
       }
       if($this->core->check_type('download') OR $this->core->check_type('demo'))
       {
           array_push($buttons, "fmp_download_editor_button");
       }
       return $buttons;
    }


    function fmp_add_editor_formats( $init_array ) {
    	return $init_array;
    }




    function fmp_add_editor_css() {
        //add_editor_style(plugins_url( '/css/wp-admin-editor.css', __FILE__ ));
    }





    function fmp_add_text_editor_button() {
        $buttons[]="QTags.addButton('fast-micro-pay', 'Mikropłatności', '[FMP]', '\\n[/FMP]')";
	    if($this->core->check_type('webinar') OR $this->core->check_type('demo'))
	    {
		    $buttons[]="QTags.addButton( 'fast-micro-pay-webinar', 'Clickwebinar', '[CLICKWEBINAR api_key=\"\" room_id=\"\" url=\"\" name=\"\" time=\"\"]', '');";
	    }
	    if($this->core->check_type('getresponse') OR $this->core->check_type('demo'))
	    {
		    $buttons[]="QTags.addButton( 'fast-micro-pay-getresponse', 'GetResponse', '[GETRESPONSE api_key=\"\" token=\"\"]', '');";
	    }
        if($this->core->check_type('download') OR $this->core->check_type('demo'))
        {
            $buttons[]="QTags.addButton( 'fast-micro-pay-download', 'Download', '[DOWNLOAD file=\"\" name=\"\"]', '');";
        }
        ?>
    	<script language="javascript" type="text/javascript">
        if(typeof QTags != "undefined" && typeof heshPlugin == "undefined")
        {
<?php
foreach($buttons As $button) : ?>
    <?php echo $button."\n"; ?>
<?php endforeach; ?>
        }
    	</script>
    <?php
    }


    function fmp_add_post_box()
    {
    
        foreach($this->core->post_types AS $post_type)
        {
            add_meta_box(
                'fmp-post-box',      // Unique ID
                'Usługa mikropłatności',    // Title
                array($this, 'fmp_add_post_box_content'),   // Callback function
                $post_type,         // Admin page (or post type)
                'side',         // Context
                'core'         // Priority
              );
        }

    }

    function fmp_add_post_box_content($post, $box) {
        $service_id=get_post_meta( $post->ID, 'fmp_service_id', true );
        $set_id=get_post_meta( $post->ID, 'fmp_set_id', true );
        if(empty($service_id))
        {
            $service_id=null;
        }
        if(empty($set_id))
        {
            $set_id=null;
        }
        else
        {
            $service_id_array= (! empty($this->core->options['sets'][(int)$set_id]['service_id'])) ? $this->core->options['sets'][(int)$set_id]['service_id'] : array();
        }
        ?>

      <?php ?>
      <p>
        <label for="smashing-post-class">Wybierz usługę <a href="<?php echo admin_url('options-general.php?page=fast-micro-pay'); ?>">mikropłatności</a> jaką chcesz zabezpieczyć treść posta:</label>
        <br />
        <select type="text" name="fmp_service_id" placeholder="Nazwa" class="widefat">
        <option value="0">Brak (płatności nieaktywne)</option>
        <optgroup label="Usługi">
            <?php foreach ($this->core->options['services'] as $k => $v) : ?>
                <option style="color: <?php echo($v['status'] == 1) ? '#006505' : '#a00'; ?> " value="SERVICE-<?php echo $k ?>"<?php echo ($k==$service_id) ? ' selected' : ''; ?>><?php echo $v['name']; echo($v['status'] == 1) ? ' (WŁĄCZONA)' : ' (WYŁĄCZONA)'; ?></option>
            <?php endforeach;?>
    </optgroup>
    <optgroup label="Pakiety usług">
    <?php foreach ($this->core->options['sets'] as $k => $v) : ?>
        <option style="color: <?php echo($v['status'] == 1) ? '#006505' : '#a00'; ?> " value="SET-<?php echo $k ?>"<?php echo ($k==$set_id) ? ' selected' : ''; ?>><?php echo $v['name']; echo($v['status'] == 1) ? ' (WŁĄCZONY)' : ' (WYŁĄCZONY)'; ?></option>
    <?php endforeach;?>
    </optgroup>
        </select>
      </p>
      <?php
      if( ! empty($service_id) OR ! empty($set_id)): ?>

      <div class="fmp-sections-links fmp-panel-buttons" style="text-align: center">
          <a class="button action" href="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=stats'); ?>"><i class="dashicons dashicons-chart-pie"></i><?php echo FastMicroPayCodes::earnings( empty($set_id) ? $service_id : $service_id_array, $post->ID); ?>zł</a>
          <a class="button action" href="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=codes&post_id=' . $post->ID . (( ! empty($set_id)) ? '&set_id=' . $set_id : '&service_id=' . $service_id)); ?>"><i class="dashicons dashicons-unlock"></i>Kody <strong>(<?php echo FastMicroPayCodes::count(empty($set_id) ? $service_id : $service_id_array, $post->ID, true, array(0,1)); ?>)</strong></a>
          <a class="button action" href="<?php echo admin_url('options-general.php?page=fast-micro-pay&section=log&post_id=' . $post->ID . (( ! empty($set_id)) ? '&set_id=' . $set_id : '&service_id=' . $service_id)); ?>"><i class="dashicons dashicons-list-view"></i>Log <strong>(<?php echo FastMicroPayLog::count(empty($set_id) ? $service_id : $service_id_array, $post->ID); ?>)</strong></a>
      </div>
  <?php endif; ?>

    <?php }












    function save_post_class_meta( $post_id, $post ) {

      $post_type = get_post_type_object( $post->post_type );
      if ( ! current_user_can( $post_type->cap->edit_post, $post_id ) )
        return $post_id;

      $value = ( isset( $_POST['fmp_service_id'] ) ) ? $_POST['fmp_service_id'] : 98 ;
      $service_id=0;
      $set_id=0;
      if(substr_count($value, 'SERVICE-') == 1)
      {
          $service_id = substr($value, 8);
      }


      if(substr_count($value, 'SET-') == 1)
      {
          $set_id = substr($value, 4);
      }
      update_post_meta( $post_id, 'fmp_service_id', (int)$service_id );
      update_post_meta( $post_id, 'fmp_set_id', (int)$set_id );
    }


    function save_post_meta($post_id, $key, $value)
    {

    }

}



?>
