<?php

class FastMicroPayLog
{
    public static function save($service_id, $post_id, $type, $comment='')
    {
        global $wpdb;
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        $wpdb->insert($wpdb->prefix.'fast_micro_pay_log', array('service_id' => $service_id, 'post_id' => $post_id, 'type' => $type, 'comment' => $comment, 'ip' => $ip, 'created_at' => date('Y-m-d H:i:s', current_time('timestamp'))));
    }

    public static function get($service_id = null, $post_id = null)
    {
        global $wpdb;
        $query = self::where($service_id, $post_id, true);
        $logs = $wpdb->get_results("SELECT logs.*, posts.post_title, posts.post_type FROM {$wpdb->prefix}fast_micro_pay_log AS logs LEFT JOIN {$wpdb->prefix}posts AS posts ON posts.id=logs.post_id $query", OBJECT);

        return $logs;
    }

    public static function clear($service_id=null)
    {
        global $wpdb;
        $wpdb->query("TRUNCATE TABLE {$wpdb->prefix}fast_micro_pay_log");
    }

    public static function delete_older($days, $service_id=null)
    {
        global $wpdb;
	    $wpdb->query($wpdb->prepare('DELETE FROM ' . $wpdb->prefix . 'fast_micro_pay_log WHERE created_at < %s' . (( ! empty((int)$service_id)) ? ' AND service_id=%d' : ''), array(date('Y-m-d H:i:s', (current_time('timestamp') - (int) $days * 24 * 60 * 60)), (int)$service_id)));
    }

    public static function count($service_id = null, $post_id = null)
    {
        global $wpdb;
        $query = self::where($service_id, $post_id, true);
        return $wpdb->get_var("SELECT COUNT(*) as log_count FROM {$wpdb->prefix}fast_micro_pay_log " . $query);
    }

    public static function delete_service_logs($service_id)
    {
    	global $wpdb;
	    $wpdb->delete($wpdb->prefix.'fast_micro_pay_log', array('service_id' => $service_id));
    }

    public static function delete_post_logs($post_id)
    {
    	global $wpdb;
	    $wpdb->delete($wpdb->prefix.'fast_micro_pay_log', array('post_id' => $post_id));
    }


    public static function where($service_id, $post_id, $where=false)
    {
        $query = array();
        if(is_array($service_id))
        {
	        $service_id=array_map('intval', $service_id);
            if(! empty($service_id))
            {
                $query[] = 'service_id IN(' . implode(',', $service_id). ')';
            }
            else
            {
                $query[] = 'service_id = 0';
            }
        }
        elseif( ! is_null($service_id))
        {
            $query[] = 'service_id='.(int) $service_id;
        }

        if (!empty($post_id)) {
            $query[] = 'post_id='.(int)$post_id;
        }
        if(empty($query))
        {
                return '';
        }
        return (($where) ? 'WHERE ': '') . implode(' AND ', $query);
    }
}
