<?php

class FastMicroPayPromos
{

    public static function add($data)
    {
        global $wpdb;
	    return $wpdb->insert( $wpdb->prefix . 'fast_micro_pay_promos', $data);
    }

    public static function getOne($id)
    {
	    global $wpdb;
	    return $wpdb->get_row($wpdb->prepare("SELECT * FROM {$wpdb->prefix}fast_micro_pay_promos WHERE id=%d", array($id)), ARRAY_A);
    }
    public static function getPromo($promo, $service_id)
    {
	    global $wpdb;
	    return $wpdb->get_row($wpdb->prepare('SELECT * FROM '. $wpdb->prefix. 'fast_micro_pay_promos WHERE lower(promo)=lower(%s) AND service_id=%d AND (expires_at is null OR expires_at>=%s) AND (max_usage is null OR usage_count < max_usage) ORDER BY created_at ASC', array($promo, $service_id, current_time('mysql'))), ARRAY_A);
    }

	public static function usePromo($promo_id)
	{
		global $wpdb;
		return $wpdb->query($wpdb->prepare('UPDATE '. $wpdb->prefix. 'fast_micro_pay_promos SET usage_count=usage_count+1, income=income+price WHERE id=%d',array($promo_id)));
	}

	public static function getList()
	{
		global $wpdb;
		return $wpdb->get_results($wpdb->prepare('SELECT *, IF(expires_at is null OR expires_at>=%s,0,1) as is_expired, IF(max_usage is null OR usage_count<max_usage, 0,1) as is_used FROM '. $wpdb->prefix. 'fast_micro_pay_promos ORDER BY created_at ASC',array(current_time('mysql'))), ARRAY_A);
	}

	public static function update($id, $update)
    {
        global $wpdb;

	    return $wpdb->update(
		    $wpdb->prefix.'fast_micro_pay_promos',
		    $update,
		    array( 'id' => $id )
	    );
    }

    public static function delete($id)
    {
        global $wpdb;
        $wpdb->delete($wpdb->prefix.'fast_micro_pay_promos', array('id'=>$id), array('%d'));
    }

	public static function delete_service_promos($service_id)
	{
		global $wpdb;
		$wpdb->delete($wpdb->prefix.'fast_micro_pay_promos', array('service_id'=>$service_id), array('%d'));
	}
}
