<?php
//	error_reporting(E_ALL);
//ini_set('display_errors', 1);
define('FMP_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('FMP_PLUGIN_URL', plugin_dir_url(__FILE__));
class FastMicroPay
{
    const VERSION = '1.8.9';
    const COOKIE_HASH = '12b86d5611503b22b3024d984f09b52e';
    protected $license = null;
    public $post_types = array();
    public $addons = array();
    public $options = array();
    public $providers = array(
//		'dotpay-sms' => array('name' => 'Dotpay (SMS)', 'class' => 'FastMicroPayProviderDotpaySms'),
//		'dotpay-online' => array('name' => 'Dotpay (płatności online)', 'class' => 'FastMicroPayProviderDotpayOnline'),
        'dotpay-transfer' => array('name' => 'Dotpay (new online)', 'class' => 'FastMicroPayProviderDotpayTransfer'),
        'payu' => array('name' => 'PayU', 'class' => 'FastMicroPayProviderPayu'),
        'tpay-sms' => array('name' => 'TPay (SMS)', 'class' => 'FastMicroPayProviderTpaySms'),
        'tpay-online' => array('name' => 'TPay (płatności online)', 'class' => 'FastMicroPayProviderTpayOnline'),
        'simpay-sms' => array('name' => 'Simpay (SMS)', 'class' => 'FastMicroPayProviderSimpaySms'),
        'przelewy24' => array('name' => 'Przelewy24 (płatności online)', 'class' => 'FastMicroPayProviderPrzelewy24'),
    );

    public function __construct()
    {
        $this->parse_options();
        $this->parse_license();
        $this->get_post_types();
    }

    public function get_license()
    {
        return $this->license;
    }
    public function get_version()
    {
        return self::VERSION;
    }

    public function is_license_valid()
    {
        //return true;
        if ($this->license['status'] != 'invalid') {
            return true;
        }
        return false;
    }

    public function is_license_active()
    {
        if (! $this->is_license_valid()) {
            return false;
        }

        if ($this->license['status']=='active') {
            return true;
        }
        return false;
    }

    public function generate_demo_license()
    {
        $current_domain=explode(':', $_SERVER['HTTP_HOST']);
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://fastmicropay.pl/fmp/fast-micro-pay-license-api.php');
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 100);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array('domain' => $current_domain[0], 'email'=>get_bloginfo('admin_email'))));
        $license = @curl_exec($ch);
        curl_close($ch);
        if ($license !==false and json_decode($license) !=false) {
            return json_decode($license, true);
        }
        return false;
    }

    public function register_addon($addon)
    {
        $this->addons[get_class($addon)]=$addon;
    }

    public function encrypt($data, $key=null)
    {
        if (empty($key)) {
            $key='*97@$S8&8&*as&*SA7sa*SA7alnIU&7#$%gf^IsPj8';
        } else {
            $key=md5($key);
        }
        $l = strlen($key);
        if ($l < 16) {
            $key = str_repeat($key, ceil(16/$l));
        }

        if ($m = strlen($data)%8) {
            $data .= str_repeat("\x00", 8 - $m);
        }
        if (!function_exists('openssl_encrypt')) {
            $val = mcrypt_encrypt(MCRYPT_BLOWFISH, $key, $data, MCRYPT_MODE_ECB);
        } else {
            $val = openssl_encrypt($data, 'BF-ECB', $key, OPENSSL_RAW_DATA | OPENSSL_NO_PADDING);
        }
        return  base64_encode($val);
    }



    public function decrypt($data, $key=null)
    {
        if (empty($key)) {
            $key='*97@$S8&8&*as&*SA7sa*SA7alnIU&7#$%gf^IsPj8';
        } else {
            $key=md5($key);
        }
        $data=base64_decode($data);
        $l = strlen($key);
        if ($l < 16) {
            $key = str_repeat($key, ceil(16/$l));
        }

        if (!function_exists('openssl_decrypt')) {
            $val = mcrypt_decrypt(MCRYPT_BLOWFISH, $key, $data, MCRYPT_MODE_ECB);
        } else {
            $val = openssl_decrypt($data, 'BF-ECB', $key, OPENSSL_RAW_DATA | OPENSSL_NO_PADDING);
        }
        return $val;
    }

    public function parse_options()
    {
        $this->options = get_option('fast_micro_pay');
        if (empty($this->options['services'])) {
            $this->options['services'] = array();
        }
        if (empty($this->options['services_ai'])) {
            $this->options['services_ai'] = (int) @max(array_keys($this->options['services']));
        } else {
            $this->options['services_ai'] = (int) @max(array_merge(array_keys($this->options['services']), array($this->options['services_ai'])));
        }
        if (empty($this->options['sets'])) {
            $this->options['sets'] = array();
        }
        if (empty($this->options['sets_ai'])) {
            $this->options['sets_ai'] = (int) @max(array_keys($this->options['sets']));
        } else {
            $this->options['sets_ai'] = (int) @max(array_merge(array_keys($this->options['sets']), array($this->options['sets_ai'])));
        }
        if (empty($this->options['license'])) {
            $this->options['license'] = '';
        }
    }


    public function parse_license()
    {
        if ($this->license !== null) {
            return false;
        }
        $license=$this->options['license'];
        if ($license == false or $license == '') {
            $this->license=array('status'=>'invalid');
            return false;
        }
        $license=$this->decrypt($license);

        if ($license == false or $license == '') {
            $this->license=array('status'=>'invalid');
            return false;
        }
        $license=base64_decode($license);
        if ($license == false or $license=='') {
            $this->license=array('status'=>'invalid');
            return false;
        }
        $license=explode('>>|&>>', $license);

        if (count($license) != 6 or array_pop($license) != md5(md5(implode('>>|&>>', $license)))) {
            $this->license=array('status'=>'invalid');
            return false;
        }



        $expiration_time=str_replace('-', '', $license[3]);
        $domain         =explode('|', $license[4]);
        $type         =explode('|', $license[2]);

        $current_domain=explode(':', $_SERVER['HTTP_HOST']);
        $current_domain=strtolower($current_domain[0]);

        if (($expiration_time == 'unlimited' or (int)$expiration_time>=(int)date('Ymd')) and ($domain[0]=='unlimited' or in_array($current_domain, $domain))) {
            $license_info['status']='active';
        } else {
            $license_info['status']='inactive';
        }

        $license_info['for']     =$license[0];
        $license_info['email']  =$license[1];
        $license_info['type']   =$type;
        $license_info['to']     =$license[3];
        $license_info['domain'] =$domain;
        $this->license=$license_info;
    }

    public function check_type($type)
    {
        if (empty($this->license['type']) or ! is_array($this->license['type']) or ! in_array($type, $this->license['type'])) {
            return false;
        }
        return true;
    }

    public function get_post_types()
    {
        $this->post_types = array_diff(array_keys(get_post_types()), array('revision', 'nav_menu_item'));
    }

    public function limit_array($array, $keys)
    {
        $output=array();
        foreach ($keys as $key) {
            $output[$key]=((isset($array[$key])) ? $array[$key] : null);
        }
        return$output;
    }

    public function add_settings_link($links)
    {
        $settings_link = '<a href="options-general.php?page=fast-micro-pay">' . __('Settings') . '</a>';
        array_push($links, $settings_link);
        return $links;
    }

    public function get_post_services($post_id)
    {
        $service_id_array=array();
        $service_id = get_post_meta($post_id, 'fmp_service_id', true);
        $set_id = get_post_meta($post_id, 'fmp_set_id', true);
        if (!empty($service_id) and !empty($this->options['services'][(int) $service_id]['status'])) {
            $service_id_array[]=(int) $service_id;
        }

        //var_dump($fast_micro_pay->options['sets']);
        if (!empty($set_id) and !empty($this->options['sets'][(int) $set_id]['status']) and !empty($this->options['sets'][(int) $set_id]['service_id'])) {
            $service_id_array=array();
            foreach ($this->options['sets'][(int) $set_id]['service_id'] as $service_id_temp) {
                if (! empty($this->options['services'][(int) $service_id_temp]['status'])) {
                    $service_id_array[]=(int) $service_id_temp;
                }
            }
        }
        return $service_id_array;
    }

    public function clean()
    {
        FastMicroPayCodes::clean();
        FastMicroPayLog::delete_older(90);
    }

    public function activation()
    {
        wp_clear_scheduled_hook('fmp_clean');
        wp_schedule_event(time(), 'daily', 'fmp_clean');
    }

    public function deactivation()
    {
        wp_clear_scheduled_hook('fmp_clean');
    }
}





include FMP_PLUGIN_PATH . 'fast-micro-pay-content.php';
$fast_micro_pay = new FastMicroPay();

add_filter('plugin_action_links_' . plugin_basename(__FILE__), array( $fast_micro_pay, 'add_settings_link' ));

if ($fast_micro_pay->is_license_valid()) {
    include FMP_PLUGIN_PATH . 'fast-micro-pay-log.php';
    include FMP_PLUGIN_PATH . 'fast-micro-pay-codes.php';
    include FMP_PLUGIN_PATH . 'fast-micro-pay-promos.php';
    //	include FMP_PLUGIN_PATH . 'providers/fast-micro-pay-dotpay-online.php';
    //	include FMP_PLUGIN_PATH . 'providers/fast-micro-pay-dotpay-sms.php';
    include FMP_PLUGIN_PATH . 'providers/fast-micro-pay-simpay-sms.php';
    include FMP_PLUGIN_PATH . 'providers/fast-micro-pay-dotpay-transfer.php';
    include FMP_PLUGIN_PATH . 'providers/fast-micro-pay-payu.php';
    include FMP_PLUGIN_PATH . 'providers/fast-micro-pay-tpay-sms.php';
    include FMP_PLUGIN_PATH . 'providers/fast-micro-pay-tpay-online.php';
    include FMP_PLUGIN_PATH . 'providers/fast-micro-pay-przelewy24.php';

    include FMP_PLUGIN_PATH . 'addons/fast-micro-pay-webinar.php';
    include FMP_PLUGIN_PATH . 'addons/fast-micro-pay-getresponse.php';
    include FMP_PLUGIN_PATH . 'addons/fast-micro-pay-download.php';

    $fast_micro_pay_content = new FastMicroPayContent($fast_micro_pay);


    add_action('init', array($fast_micro_pay, 'get_post_types'), 20);
    // add_filter('the_content', array($fast_micro_pay_content, 'demo_notification'), 15);
    add_filter('the_content', array($fast_micro_pay_content, 'premium'), 15);
    add_filter('the_content', array($fast_micro_pay_content, 'render_post_protect_box'), 15);
    // add_filter('the_content', array($fast_micro_pay_content, 'render_post_set_protect_box'), 15);
    add_filter('the_content', array($fast_micro_pay_content, 'remove_deprecated_tags'), 15);
    add_action('wp_ajax_fmp_unlock', array($fast_micro_pay_content, 'ajax_unlock_post'));
    add_action('wp_ajax_nopriv_fmp_unlock', array($fast_micro_pay_content, 'ajax_unlock_post'));
    add_action('wp_ajax_fmp_unlock_set', array($fast_micro_pay_content, 'ajax_unlock_post_set'));
    add_action('wp_ajax_nopriv_fmp_unlock_set', array($fast_micro_pay_content, 'ajax_unlock_post_set'));
    add_action('wp_ajax_fmp_check_cache', array($fast_micro_pay_content, 'ajax_check_cache'));
    add_action('wp_ajax_nopriv_fmp_check_cache', array($fast_micro_pay_content, 'ajax_check_cache'));
    add_action('wp_ajax_fmp_dotpay_urlc', array($fast_micro_pay_content, 'ajax_dotpay_urlc'));
    add_action('wp_ajax_nopriv_fmp_dotpay_urlc', array($fast_micro_pay_content, 'ajax_dotpay_urlc'));
    add_action('wp_ajax_fmp_payu', array($fast_micro_pay_content, 'ajax_payu'));
    add_action('wp_ajax_nopriv_fmp_payu', array($fast_micro_pay_content, 'ajax_payu'));
    add_action('wp_ajax_fmp_tpay', array($fast_micro_pay_content, 'ajax_tpay'));
    add_action('wp_ajax_nopriv_fmp_tpay', array($fast_micro_pay_content, 'ajax_tpay'));
    add_action('wp_ajax_fmp_przelewy24', array($fast_micro_pay_content, 'ajax_przelewy24'));
    add_action('wp_ajax_nopriv_fmp_przelewy24', array($fast_micro_pay_content, 'ajax_przelewy24'));
    add_action('wp_mail_from_name', array($fast_micro_pay_content, 'custom_wp_mail_from_name'));
    add_action('fmp_clean', array($fast_micro_pay, 'clean'));


    if ($fast_micro_pay->check_type('webinar') or $fast_micro_pay->check_type('demo')) {
        $fast_micro_pay_webinar=new FastMicroPayWebinarClickMeeting($fast_micro_pay_content);
    }

    if ($fast_micro_pay->check_type('getresponse') or $fast_micro_pay->check_type('demo')) {
        $fast_micro_pay_getresponse=new FastMicroPayGetResponse($fast_micro_pay_content);
    }

    if ($fast_micro_pay->check_type('download') or $fast_micro_pay->check_type('demo')) {
        $fast_micro_pay_download=new FastMicroPayDownload($fast_micro_pay_content);
    }




    if (is_admin()) {
        include FMP_PLUGIN_PATH . 'fast-micro-pay-setup.php';
        include FMP_PLUGIN_PATH . 'fast-micro-pay-editor.php';
        $fast_micro_pay_editor = new FastMicroPayEditor($fast_micro_pay);
        include FMP_PLUGIN_PATH . 'fast-micro-pay-admin.php';
        $fast_micro_pay_admin  = new FastMicroPayAdmin($fast_micro_pay);
    }
} else {
    $fast_micro_pay_content = new FastMicroPayContent($fast_micro_pay);
    add_filter('the_content', array($fast_micro_pay_content, 'premium'), 15);
    add_filter('the_content', array($fast_micro_pay_content, 'render_post_protect_box'), 15);
    add_filter('the_content', array($fast_micro_pay_content, 'remove_deprecated_tags'), 15);


    if (is_admin()) {
        include FMP_PLUGIN_PATH . 'fast-micro-pay-setup.php';
        include FMP_PLUGIN_PATH . 'fast-micro-pay-admin.php';
        $fast_micro_pay_admin  = new FastMicroPayAdmin($fast_micro_pay);
    }
}
