function fast_micro_pay_check_cache(post_id) {
  if (
    post_id &&
    document.cookie.indexOf("fast_micro_pay_post_" + post_id) > -1 &&
    jQuery('.fmp-code[data-post-id="' + post_id + '"]').length > 0 &&
    (document.URL.match(/status=OK/g) || []).length == 0
  ) {
    jQuery('.fmp-status[data-post-id="' + post_id + '"]').text(
      "Sprawdzanie..."
    );
    jQuery.post(
      FastMicroPay.ajax,
      {
        action: "fmp_check_cache",
        post_id: post_id,
      },
      function (data, status) {
        fmp_redirect(data);
      },
      "json"
    );
  }
}

function get_cookie(i) {
  var name = i + "=";
  var ca = document.cookie.split(";");
  for (var i = 0; i < ca.length; i++) {
    var c = ca[i];
    while (c.charAt(0) == " ") {
      c = c.substring(1);
    }
    if (c.indexOf(name) == 0) {
      return c.substring(name.length, c.length);
    }
  }
  return "";
}

function fmp_redirect(data) {
  if (data.redirect) {
    if (document.URL == data.redirect) {
      location.assign(data.redirect + "#fmp-premium-content");
      window.location.reload();
    } else if (document.URL.indexOf("#fmp-premium-content") > 0) {
      window.location = data.redirect + "#fmp-premium-content";
      window.location.reload();
    } else {
      window.location = data.redirect + "#fmp-premium-content";
    }
  }
}

function fmp_report_ga_event(action, label) {
  if (typeof gtag != "undefined") {
    gtag("event", action, {
      event_category: "FMP",
      event_label: label,
    });
    return true;
  }

  if (typeof ga != "undefined" && typeof dataLayer != "undefined") {
    dataLayer.push({
      event: "fmpEvent",
      category: "FMP",
      action: action,
      label: label,
    });
    return true;
  }

  if (typeof ga != "undefined") {
    ga("send", "event", {
      eventCategory: "FMP",
      eventAction: action,
      eventLabel: label,
    });
    return true;
  }
  return false;
}

function save_fmp_ga_client_id() {
  if (typeof ga != "undefined") {
    try {
      var trackers = ga.getAll();
      var i, len;
      for (i = 0, len = trackers.length; i < len; i += 1) {
        document.cookie =
          "fmp_ga_client_id=" + trackers[i].get("clientId") + ";path=/";
        break;
      }
    } catch (e) {}
  }
}

function check_email() {
  var post_id = fast_micro_pay_post_id;
  var service_id = jQuery(
    '.fmp-protect-box[data-post-id="' + post_id + '"]'
  ).data("service-id");
  fast_micro_pay_service_id = get_cookie("fast_micro_pay_service_id");
  if (fast_micro_pay_service_id) {
    service_id = fast_micro_pay_service_id;
    fast_micro_pay_service_id =
      '[data-service-id="' + fast_micro_pay_service_id + '"]';
  }

  email = decodeURIComponent(get_cookie("fast_micro_pay_user_email"));

  jQuery(
    '.fmp-status[data-post-id="' + post_id + '"]' + fast_micro_pay_service_id
  ).text("Sprawdzanie...");

  jQuery.post(
    FastMicroPay.ajax,
    {
      action: "fmp_unlock",
      post_id: post_id,
      code: email,
      service_id: service_id,
      periodically: true,
    },
    function (data, status) {
      fmp_redirect(data);
      if (data.donation_message != undefined) {
        jQuery(
          '.fmp-protect-box[data-post-id="' +
            post_id +
            '"]' +
            fast_micro_pay_service_id
        ).removeClass("fmp-loading");
        jQuery(
          '.fmp-status[data-post-id="' +
            post_id +
            '"]' +
            fast_micro_pay_service_id
        )
          .removeClass("fmp-status-error")
          .removeClass("fmp-status-success")
          .addClass("fmp-donation-status-success")
          .html(data.donation_message);
      } else {
        jQuery(
          '.fmp-status[data-post-id="' +
            post_id +
            '"]' +
            fast_micro_pay_service_id
        )
          .removeClass("fmp-donation-status-success")
          .removeClass("fmp-status-success")
          .removeClass("fmp-status-error")
          .text("Trwa weryfikacja płatności w serwisie zewnętrznym");
        setTimeout(function () {
          check_email();
        }, 5000);
      }
    },
    "json"
  );
}

jQuery(document).ready(function () {
  jQuery.fn.fmp_switch_service = function (service_id) {
    var box = jQuery(this);
    if (
      !service_id ||
      box.find(
        '.fmp-set-labels .fmp-label-item[data-service-id="' + service_id + '"]'
      ).length == 0
    ) {
      return false;
    }
    box.attr("data-mode", "buy");
    service_id = service_id
      ? service_id
      : box.find(".fmp-set-labels .fmp-label-item:first").data("service-id");
    box.find(".fmp-set-labels .fmp-label-item").removeClass("fmp-active");
    box
      .find(
        '.fmp-set-labels .fmp-label-item[data-service-id="' + service_id + '"]'
      )
      .addClass("fmp-active");

    box.find(".fmp-set-box .fmp-box-item").removeClass("fmp-active");
    box
      .find('.fmp-set-box .fmp-box-item[data-service-id="' + service_id + '"]')
      .addClass("fmp-active");
  };

  jQuery(".fmp-label-item").on("click", function () {
    jQuery(this)
      .parents(".fmp-set-container")
      .fmp_switch_service(jQuery(this).data("service-id"));
    var set_id = jQuery(this).parents(".fmp-set-container").data("set-id");
    fmp_report_ga_event("pakiet-wybierz-usluge", "set-" + set_id);
  });

  jQuery(
    ".fmp-protect-box .fmp-submit:not(.fmp-submit-form), .fmp-promo-submit"
  ).on("click", function () {
    // jQuery(document).on('click', '.fmp-protect-box .fmp-submit:not(.fmp-submit-form), .fmp-promo-submit', function() {
    request_source = "submit";
    if (jQuery(this).hasClass("fmp-promo-submit")) {
      request_source = "promo";
    }
    jQuery(this)
      .parents(".fmp-protect-box")
      .find(".fmp-regulations-container")
      .removeClass("fmp-regulations-status-error");
    if (
      jQuery(this)
        .parents(".fmp-protect-box")
        .find(".fmp-regulations-container").length > 0 &&
      jQuery(this)
        .parents(".fmp-protect-box")
        .find(".fmp-regulations-container .fmp-regulations-option input")
        .is(":not(:checked)")
    ) {
      jQuery(this)
        .parents(".fmp-protect-box")
        .find(
          ".fmp-regulations-container:has(.fmp-regulations-option input:not(:checked))"
        )
        .addClass("fmp-regulations-status-error");
      return false;
    }
    post_id = jQuery(this).parents(".fmp-protect-box").data("post-id");
    service_id = jQuery(this).parents(".fmp-protect-box").data("service-id");
    jQuery(
      '.fmp-status[data-post-id="' +
        post_id +
        '"][data-service-id="' +
        service_id +
        '"]'
    ).text("Sprawdzanie...");
    code = jQuery(
      '.fmp-code[data-post-id="' +
        post_id +
        '"][data-service-id="' +
        service_id +
        '"]'
    ).val();
    donation = jQuery(
      '.fmp-donation[data-post-id="' +
        post_id +
        '"][data-service-id="' +
        service_id +
        '"]'
    ).val();
    promo = jQuery(
      '.fmp-promo[data-post-id="' +
        post_id +
        '"][data-service-id="' +
        service_id +
        '"]'
    ).val();
    firstname = jQuery(this)
      .parents("form")
      .find('.fmp-invoice-details input[name="invoice[firstname]"]')
      .val();
    lastname = jQuery(this)
      .parents("form")
      .find('.fmp-invoice-details input[name="invoice[lastname]"]')
      .val();
    street = jQuery(this)
      .parents("form")
      .find('.fmp-invoice-details input[name="invoice[street]"]')
      .val();
    street_n1 = jQuery(this)
      .parents("form")
      .find('.fmp-invoice-details input[name="invoice[street_n1]"]')
      .val();
    street_n2 = jQuery(this)
      .parents("form")
      .find('.fmp-invoice-details input[name="invoice[street_n2]"]')
      .val();
    postcode = jQuery(this)
      .parents("form")
      .find('.fmp-invoice-details input[name="invoice[postcode]"]')
      .val();
    city = jQuery(this)
      .parents("form")
      .find('.fmp-invoice-details input[name="invoice[city]"]')
      .val();
    nip = jQuery(this)
      .parents("form")
      .find('.fmp-invoice-details input[name="invoice[nip]"]')
      .val();
    step = jQuery(this)
      .parents("form")
      .find('.fmp-invoice-details input[name="step"]')
      .val();
    jQuery(
      '.fmp-status[data-post-id="' +
        post_id +
        '"][data-service-id="' +
        service_id +
        '"]'
    )
      .text("Sprawdzanie...")
      .removeClass("fmp-donation-status-success")
      .removeClass("fmp-status-success")
      .removeClass("fmp-status-error");
    jQuery(this)
      .parents(".fmp-protect-box")
      .find(".fmp-promo-container")
      .removeClass("fmp-promo-success")
      .removeClass("fmp-promo-error");
    fmp_report_ga_event("proba-odblokowania", "service-" + service_id);
    jQuery(this).parents(".fmp-protect-box").addClass("fmp-loading");
    jQuery.post(
      FastMicroPay.ajax,
      {
        action: "fmp_unlock",
        post_id: post_id,
        code: code,
        donation: donation,
        promo: promo,
        service_id: service_id,
        firstname: firstname,
        lastname: lastname,
        street: street,
        street_n1: street_n1,
        street_n2: street_n2,
        postcode: postcode,
        city: city,
        nip: nip,
        step: step,
        request_source: request_source,
      },
      function (data, status) {
        jQuery(".fmp-loading").removeClass("fmp-loading");
        // console.log(data);
        if (data.redirect) {
          fmp_report_ga_event("tresc-odblokowana", "service-" + service_id);
        } else if (data.status == "invalid-code") {
          fmp_report_ga_event("tresc-nieodblokowana", "service-" + service_id);
        }

        // jQuery('.fmp-protect-box[data-post-id="' + post_id + '"][data-service-id="' + service_id + '"] .fmp-regulations-container .fmp-regulations-option input').attr('disabled', true);
        fmp_redirect(data);
        if (data.message) {
          jQuery(
            '.fmp-status[data-post-id="' +
              post_id +
              '"][data-service-id="' +
              service_id +
              '"]'
          )
            .html(data.message)
            .addClass("fmp-status-" + data.type);
        }
        // jQuery('.fmp-protect-box[data-post-id="' + post_id + '"][data-service-id="' + service_id + '"] .fmp-code').prop('readonly', true);

        if (data.finalize || data.redirection) {
          jQuery.each(data.payment_data, function (i, v) {
            if (
              jQuery(
                '.fmp-protect-box[data-post-id="' +
                  post_id +
                  '"][data-service-id="' +
                  service_id +
                  '"] form input[name="' +
                  i +
                  '"]'
              ).length > 0
            ) {
              jQuery(
                '.fmp-protect-box[data-post-id="' +
                  post_id +
                  '"][data-service-id="' +
                  service_id +
                  '"] form input[name="' +
                  i +
                  '"]'
              ).val(v);
            } else {
              jQuery(
                '.fmp-protect-box[data-post-id="' +
                  post_id +
                  '"][data-service-id="' +
                  service_id +
                  '"] form'
              ).append(
                '<input type="hidden" name="' + i + '" value="' + v + '">'
              );
            }
          });
        }

        if (data.finalize) {
          jQuery(
            '.fmp-protect-box[data-post-id="' +
              post_id +
              '"][data-service-id="' +
              service_id +
              '"] .fmp-code'
          ).prop("disabled", true);
          jQuery(
            '.fmp-protect-box[data-post-id="' +
              post_id +
              '"][data-service-id="' +
              service_id +
              '"] .fmp-donation'
          ).prop("disabled", true);
          jQuery(
            '.fmp-protect-box[data-post-id="' +
              post_id +
              '"][data-service-id="' +
              service_id +
              '"] .fmp-submit'
          ).addClass("fmp-submit-form");
          jQuery(
            '.fmp-protect-box[data-post-id="' +
              post_id +
              '"][data-service-id="' +
              service_id +
              '"] .fmp-submit'
          ).text("Zapłać");
        }

        if (data.show_invoice) {
          jQuery(
            '.fmp-protect-box[data-post-id="' +
              post_id +
              '"][data-service-id="' +
              service_id +
              '"] .fmp-invoice-details'
          ).show();
          jQuery(
            '.fmp-protect-box[data-post-id="' +
              post_id +
              '"][data-service-id="' +
              service_id +
              '"] form input[name="step"]'
          ).val("2");
          if (data.status == "incomplete") {
            jQuery(
              '.fmp-protect-box[data-post-id="' +
                post_id +
                '"][data-service-id="' +
                service_id +
                '"] .fmp-invoice-details input.fmp-required'
            )
              .filter(function () {
                return !this.value;
              })
              .addClass("fmp-missing");
          }
        }
        if (data.show_promo) {
          jQuery(
            '.fmp-protect-box[data-post-id="' +
              post_id +
              '"][data-service-id="' +
              service_id +
              '"] .fmp-promo-container'
          ).show();
          if (data.promo_valid) {
            jQuery(
              '.fmp-protect-box[data-post-id="' +
                post_id +
                '"][data-service-id="' +
                service_id +
                '"] .fmp-promo-container'
            ).addClass("fmp-promo-success");
            jQuery(
              '.fmp-protect-box[data-post-id="' +
                post_id +
                '"][data-service-id="' +
                service_id +
                '"] .fmp-promo-container .fmp-promo'
            ).prop("readonly", true);
          } else if (
            jQuery(
              '.fmp-protect-box[data-post-id="' +
                post_id +
                '"][data-service-id="' +
                service_id +
                '"] .fmp-promo-container .fmp-promo'
            ).val().length > 0
          ) {
            jQuery(
              '.fmp-protect-box[data-post-id="' +
                post_id +
                '"][data-service-id="' +
                service_id +
                '"] .fmp-promo-container'
            ).addClass("fmp-promo-error");
          }
        }

        if (data.redirection) {
          if (data.request_source == "submit") {
            jQuery(
              '.fmp-protect-box[data-post-id="' +
                post_id +
                '"][data-service-id="' +
                service_id +
                '"] .fmp-invoice-details input'
            ).attr("disabled", true);
            jQuery(
              '.fmp-protect-box[data-post-id="' +
                post_id +
                '"][data-service-id="' +
                service_id +
                '"] form'
            ).submit();
          } else {
          }
        }
      },
      "json"
    );
  });

  jQuery(".fmp-set-container").on("click", ".fmp-set-submit", function () {
    var box = jQuery(this).parents(".fmp-set-container");
    post_id = box.data("post-id");
    set_id = box.data("set-id");
    code = box.find(".fmp-set-code").val();
    box
      .find(".fmp-set-status")
      .removeClass("fmp-donation-status-success")
      .removeClass("fmp-status-success")
      .removeClass("fmp-status-error")
      .text("Trwa weryfikacja dostępu");
    fmp_report_ga_event("pakiet-proba-odblokowania", "service-" + service_id);
    jQuery.post(
      FastMicroPay.ajax,
      {
        action: "fmp_unlock_set",
        post_id: post_id,
        set_id: set_id,
        code: code,
      },
      function (data, status) {
        fmp_redirect(data);
        if (data.message) {
          box
            .find(".fmp-set-status")
            .html(data.message)
            .addClass("fmp-status-" + data.type);
          if (data.type == "error") {
            // box.find('.fmp-set-code').val('');
            box.attr("data-mode", "unlock-denied");
            box.find('.fmp-code[data-type="email"]').val(code);
            fmp_report_ga_event("pakiet-tresc-nieodblokowana", "set-" + set_id);
          } else if (data.redirect) {
            fmp_report_ga_event("pakiet-tresc-odblokowana", "set-" + set_id);
          }
        }
      }
    );
  });
  jQuery(".fmp-set-container").on("click", ".fmp-set-unlock", function () {
    jQuery(this).parents(".fmp-set-container").attr("data-mode", "unlock");
    var set_id = jQuery(this).parents(".fmp-set-container").data("set-id");
    fmp_report_ga_event("pakiet-zaloguj-sie", "set-" + set_id);
  });
  jQuery(".fmp-set-container").on("click", ".fmp-set-buy", function () {
    jQuery(this)
      .parents(".fmp-set-container")
      .attr("data-mode", "buy")
      .find(".fmp-set-status")
      .removeClass("fmp-status-success")
      .removeClass("fmp-status-error")
      .text("");
    var set_id = jQuery(this).parents(".fmp-set-container").data("set-id");
    fmp_report_ga_event("pakiet-wykup", "set-" + set_id);
  });
  jQuery(".fmp-set-container").on("click", ".fmp-set-cancel", function () {
    jQuery(this)
      .parents(".fmp-set-container")
      .attr("data-mode", "start")
      .find(".fmp-set-status")
      .removeClass("fmp-status-success")
      .removeClass("fmp-status-error")
      .text("");
  });
  jQuery(".fmp-set-container").on(
    "keyup",
    '.fmp-code[data-type="email"]',
    function () {
      jQuery(this)
        .parents(".fmp-set-container")
        .find('.fmp-code[data-type="email"]')
        .not(jQuery(this))
        .val(jQuery(this).val());
    }
  );

  // $('input[name=myInput]').change(function() { ... });

  jQuery(".fmp-protect-box").on("click", ".fmp-submit-form", function () {
    service_id = jQuery(this).data("service-id");
    fmp_report_ga_event("przekierowanie-do-platnosci", "service-" + service_id);
    jQuery(this).parents("form").submit();
  });
  fast_micro_pay_service_id = get_cookie("fast_micro_pay_service_id");
  if (
    ((document.URL.match(/status=OK/g) || []).length > 0 ||
      ((document.URL.match(/payu_result=TRUE/g) || []).length > 0 &&
        (document.URL.match(/error=/g) || []).length == 0)) &&
    fast_micro_pay_post_id > 0 &&
    get_cookie("fast_micro_pay_user_email") != ""
  ) {
    // fast_micro_pay_service_id=get_cookie('fast_micro_pay_service_id');
    jQuery(".fmp-set-container").fmp_switch_service(
      fast_micro_pay_service_id ? fast_micro_pay_service_id : false
    );
    if (fast_micro_pay_service_id) {
      fast_micro_pay_service_id =
        '[data-service-id="' + fast_micro_pay_service_id + '"]';
    }
    jQuery(
      '.fmp-code[data-post-id="' +
        fast_micro_pay_post_id +
        '"]' +
        fast_micro_pay_service_id
    ).val(decodeURIComponent(get_cookie("fast_micro_pay_user_email")));
    jQuery(
      '.fmp-protect-box[data-post-id="' +
        fast_micro_pay_post_id +
        '"]' +
        fast_micro_pay_service_id +
        " .fmp-submit"
    ).prop("disabled", true);
    jQuery(
      '.fmp-protect-box[data-post-id="' +
        fast_micro_pay_post_id +
        '"]' +
        fast_micro_pay_service_id
    ).addClass("fmp-loading");
    var service_id = jQuery(
      '.fmp-status[data-post-id="' + fast_micro_pay_post_id + '"]'
    ).data("service-id");
    fmp_report_ga_event("platnosc-powiodla-sie", "service-" + service_id);
    check_email();
  }

  if (
    ((document.URL.match(/status=FAIL/g) || []).length > 0 ||
      ((document.URL.match(/payu_result=FALSE/g) || []).length > 0 &&
        (document.URL.match(/error=/g) || []).length > 0)) &&
    fast_micro_pay_post_id > 0 &&
    get_cookie("fast_micro_pay_user_email") != ""
  ) {
    jQuery(".fmp-set-container").fmp_switch_service(
      fast_micro_pay_service_id ? fast_micro_pay_service_id : false
    );
    jQuery('.fmp-code[data-post-id="' + fast_micro_pay_post_id + '"]').val(
      decodeURIComponent(get_cookie("fast_micro_pay_user_email"))
    );
    jQuery('.fmp-status[data-post-id="' + fast_micro_pay_post_id + '"]')
      .text("Płatność nie została zakończona")
      .removeClass("fmp-donation-status-success")
      .removeClass("fmp-status-success")
      .addClass("fmp-status-error");
    var service_id = jQuery(
      '.fmp-status[data-post-id="' + fast_micro_pay_post_id + '"]'
    ).data("service-id");
    fmp_report_ga_event("platnosc-nie-powiodla-sie", "service-" + service_id);
  }

  jQuery(".fmp-regulations-option input").on("change", function () {
    if (jQuery(this).checked);
    {
      jQuery(this)
        .parents(".fmp-regulations-container")
        .removeClass("fmp-regulations-status-error");
    }
  });

  jQuery(".fmp-protect-box form").on("submit", function () {
    if (
      jQuery(this)
        .parents(".fmp-protect-box")
        .find(".fmp-regulations-container").length == 1 &&
      !jQuery(this)
        .parents(".fmp-protect-box")
        .find(".fmp-regulations-container .fmp-regulations-option input")
        .is(":checked")
    ) {
      jQuery(this)
        .parents(".fmp-protect-box")
        .find(".fmp-regulations-container")
        .addClass("fmp-regulations-status-error");
      return false;
    }
  });
  save_fmp_ga_client_id();
});
jQuery(document).on("keypress", ".fmp-code", function (event) {
  if (event.keyCode == 13) {
    event.preventDefault();
  }
});
jQuery(document).on("keyup", ".fmp-required", function (event) {
  // console.log(jQuery(this).val());

  if (jQuery(this).val() != "") {
    // console.log('USUN');
    jQuery(this).removeClass("fmp-missing");
  }
});

jQuery(window).on("load", function () {
  save_fmp_ga_client_id();
});
