function substr_count(haystack, needle, offset, length) {
  var cnt = 0;

  haystack += '';
  needle += '';
  if (isNaN(offset)) {
    offset = 0;
  }
  if (isNaN(length)) {
    length = 0;
  }
  if (needle.length == 0) {
    return false;
  }
  offset--;

  while ((offset = haystack.indexOf(needle, offset + 1)) != -1) {
    if (length > 0 && (offset + needle.length) > length) {
      return false;
    }
    cnt++;
  }

  return cnt;
}



(function() {
    tinymce.PluginManager.add('fmp_editor_button', function(editor, url) {
        editor.addButton('fmp_editor_button', {
            text: ' Mikropłatności',
            icon: 'fmp',
            onclick: function(event) {
                selection=tinymce.activeEditor.selection.getContent();
                if(selection.length > 0)
                {
                    if(selection.indexOf('[FMP]') > -1 && selection.indexOf('[/FMP]') > -1)
                    {
                        insert_content=selection.replace(/\[FMP\]/g, '').replace(/\[\/FMP\]/g, '');
                    }
                    else
                    {
                        insert_content='[FMP]' + selection + '<br />[/FMP]';
                    }

                }
                else
                {
                    content=tinyMCE.activeEditor.getContent();
                    if(substr_count(content, '[FMP]') <= substr_count(content, '[/FMP]'))
                    {
                        insert_content='[FMP]';
                    }
                    else
                    {
                        insert_content='[/FMP]';
                    }
                }
                tinymce.activeEditor.execCommand('mceInsertContent', 0, insert_content);
            }
        });


        editor.addButton('fmp_clickwebinar_editor_button', {
            text: ' Clickwebinar',
            icon: 'fmp-clickwebinar',
            onclick: function(event) {
                selection=tinymce.activeEditor.selection.getContent();
                insert_content='[CLICKWEBINAR api_key="" room_id="" url="" name="" time=""]';
                tinymce.activeEditor.execCommand('mceInsertContent', 0, insert_content);
            }
        });

        editor.addButton('fmp_getresponse_editor_button', {
            text: ' GetResponse',
            icon: 'fmp-getresponse',
            onclick: function(event) {
                selection=tinymce.activeEditor.selection.getContent();
                insert_content='[GETRESPONSE api_key="" token=""]';
                tinymce.activeEditor.execCommand('mceInsertContent', 0, insert_content);
            }
        });


        editor.addButton('fmp_download_editor_button', {
            text: ' Download',
            icon: 'fmp-download',
            onclick: function(event) {
                selection=tinymce.activeEditor.selection.getContent();
                insert_content='[DOWNLOAD file="" name=""]';
                tinymce.activeEditor.execCommand('mceInsertContent', 0, insert_content);
            }
        });


                editor.on('BeforeSetcontent', function(event){
                });

                editor.on('PostProcess', function(event){
                });
    });
})();
