<?php

class FastMicroPayProviderPayU
{
    public function generate_info_box($post_id, $service_id, $service)
    {
        $parameters = $this->generate_parameters($post_id, $service_id, $service);
        $submit_url = 'https://secure.payu.com/api/v2_1/orders';
        $template = str_replace('{code}', '<input type="text" class="fmp-code" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'" placeholder="Podaj email" data-type="email">', $service['info_box']);
        for($i=1;$i<=5;$i++)
        {
            if(!empty($service['regulations_text' . (($i==1) ? '' : '_' . $i)]))
            {
                $template.='<span class="fmp-regulations-container"><label class="fmp-regulations-option"><input type="checkbox" value="1"><span>Akceptuj</span></label><span class="fmp-regulations-text"><span>' . $service['regulations_text' . (($i==1) ? '' : '_' . $i)] . '</span></span></span>';
            }
        }
	    $template = str_replace('{submit}', '<span class="fmp-submit" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'">'.(!empty($service['button']) ? $service['button'] : 'Odblokuj').'</span>', $template);
	    if(! empty($service['donation']))
	    {
	        $template = str_replace('{donation}', '<input type="text" class="fmp-donation" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'" placeholder="Podaj kwotę darowizny" value="' . ((empty($service['price'])) ? '' : number_format($service['price'], 2)) . '">', $template);
        }
	    $template = str_replace('{promo}', '<div class="fmp-promo-container"><input type="text" class="fmp-promo" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'" placeholder="Kod rabatowy" value=""><span class="fmp-promo-submit"><span>Sprawdź</span></span></div>', $template);
	    $template = str_replace('{invoice-info}', '
            <div class="fmp-invoice-details">
                <div class="fmp-invoice-data-info"><input type="text" placeholder="Imię" name="invoice[firstname]" class="fmp-required"><input type="text" placeholder="Nazwisko" name="invoice[lastname]" class="fmp-required"></div>
                <div class="fmp-invoice-data-info"><input type="text" placeholder="Ulica" name="invoice[street]" class="fmp-required"><input type="text" name="invoice[street_n1]" class="fmp-required"><span class="fmp-separator">/</span><input type="text" name="invoice[street_n2]"></div>
                <div class="fmp-invoice-data-info"><input type="text" placeholder="Miasto" name="invoice[city]" class="fmp-required"><input type="text" placeholder="Kod pocztowy" name="invoice[postcode]" class="fmp-required"></div>
                <div class="fmp-invoice-data-info"><input type="text" placeholder="NIP" name="invoice[nip]"></div>                
                <input type="hidden" name="step" value="1" />
            </div>
        ', $template);
	    $template = '<form action="'.$submit_url.'" method="post">'.$template;
        $template .= '</form>';
        return $template;
    }

    public function check_access($service, $sms_code)
    {
        return false;
    }

    public function generate_parameters($post_id, $code_id, $service)
    {
        $post_url = get_permalink($post_id);
        $parameters = array(
            'customerIp' => $this->user_ip(),
            'merchantPosId' => $service['external_id'],
            'description' => $service['description'],
            'totalAmount' => floor((float) $service['price'] * 100),
            'currencyCode' => 'PLN',
            'products[0].name' => $service['description'],
            'products[0].unitPrice' => floor((float) $service['price'] * 100),
            'products[0].quantity' => '1',
            'notifyUrl' => admin_url('admin-ajax.php?action=fmp_payu&code_id='.$code_id),
//            'notifyUrl' => admin_url('admin-ajax.php?action=fmp_payu&code_id='.$post_id.'&service_id=23'),
            'continueUrl' => $post_url.((substr_count($post_url, '?') > 0) ? '&' : '?').'payu_result=TRUE',
        );

        return $parameters;
    }

    public function user_ip()
    {
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            $ip = $_SERVER['REMOTE_ADDR'];
        }

        return $ip;
    }

    public function generate_signature($parameters, $second_key)
    {
        ksort($parameters);
        $content = '';
        foreach ($parameters as $k => $v) {
            $content .= $k.'='.urlencode($v).'&';
        }
        $content .= $second_key;
        // var_dump($content);
        return hash('sha512', $content);
    }

    public function generate_hash($string, $method)
    {
        switch ($method) {
            case 'MD5':
                return md5($string);
                break;
            case 'SHA-256':
                return hash('sha256', $string);
                break;
            case 'SHA-384':
                return hash('sha384', $string);
                break;
            case 'SHA-512':
                return hash('sha512', $string);
                break;
            default:
                return md5($string);
        }
    }

}
