<?php

class FastMicroPayProviderTpayOnline
{
    public function generate_info_box($post_id, $service_id, $service)
    {
        $parameters = $this->generate_parameters($post_id, $service_id, $service);
        $submit_url = 'https://secure.transferuj.pl';
        $template = str_replace('{code}', '<input type="text" class="fmp-code" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'" placeholder="Podaj email" data-type="email">', $service['info_box']);
        $template = str_replace('{submit}', '<span class="fmp-submit" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'">'.(!empty($service['button']) ? $service['button'] : 'Odblokuj').'</span>', $template);
	    if(! empty($service['donation']))
	    {
		    $template = str_replace('{donation}', '<input type="text" class="fmp-donation" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'" placeholder="Podaj kwotę dotacji" value="' . ((empty($service['price'])) ? '' : number_format($service['price'], 2)) . '">', $template);
	    }
        for($i=1;$i<=5;$i++)
        {
            if(!empty($service['regulations_text' . (($i==1) ? '' : '_' . $i)]))
            {
                $template.='<span class="fmp-regulations-container"><label class="fmp-regulations-option"><input type="checkbox" value="1"><span>Akceptuj</span></label><span class="fmp-regulations-text"><span>' . $service['regulations_text' . (($i==1) ? '' : '_' . $i)] . '</span></span></span>';
            }
        }
        if(! empty($service['donation']))
        {
            $template = str_replace('{donation}', '<input type="text" class="fmp-donation" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'" placeholder="Podaj kwotę darowizny" value="' . ((empty($service['price'])) ? '' : number_format($service['price'], 2)) . '">', $template);
        }
	    $template = str_replace('{promo}', '<div class="fmp-promo-container"><input type="text" class="fmp-promo" data-post-id="'.$post_id.'" data-service-id="'.$service_id.'" placeholder="Kod rabatowy" value=""><span class="fmp-promo-submit"><span>Sprawdź</span></span></div>', $template);
	    $template = str_replace('{invoice-info}', '
            <div class="fmp-invoice-details">
                <div class="fmp-invoice-data-info"><input type="text" placeholder="Imię" name="invoice[firstname]" class="fmp-required"><input type="text" placeholder="Nazwisko" name="invoice[lastname]" class="fmp-required"></div>
                <div class="fmp-invoice-data-info"><input type="text" placeholder="Ulica" name="invoice[street]" class="fmp-required"><input type="text" name="invoice[street_n1]" class="fmp-required"><span class="fmp-separator">/</span><input type="text" name="invoice[street_n2]"></div>
                <div class="fmp-invoice-data-info"><input type="text" placeholder="Miasto" name="invoice[city]" class="fmp-required"><input type="text" placeholder="Kod pocztowy" name="invoice[postcode]" class="fmp-required"></div>
                <div class="fmp-invoice-data-info"><input type="text" placeholder="NIP" name="invoice[nip]"></div>
                <input type="hidden" name="step" value="1" />
            </div>
        ', $template);
        $template = '<form action="'.$submit_url.'" method="post">'.$template;
        $template .= '</form>';

        return $template;
    }

    public function check_access($service, $sms_code)
    {
        return false;
    }

    public function generate_parameters($post_id, $code_id, $service)
    {
        $post_url = get_permalink($post_id);
        $parameters = array(
            'id' => $service['external_id'],
            'opis' => $service['description'],
            'kwota' => $service['price'],
            'online' => '1',
            'wyn_url' => admin_url('admin-ajax.php?action=fmp_tpay&code_id='.$code_id),
            'pow_url' => $post_url.((substr_count($post_url, '?') > 0) ? '&' : '?').'status=OK',
            'pow_url_blad' => $post_url.((substr_count($post_url, '?') > 0) ? '&' : '?').'status=FAIL',
        );

        return $parameters;
    }


    public function generate_md5sum($parameters, $key)
    {
        return md5($parameters['id'] . '&' . $parameters['kwota'] . '&' . $parameters['crc'] . '&' . $key);
    }

    public function generate_md5sum_transaction($post, $key)
    {
        return md5($post['id'] . $post['tr_id'] . $post['tr_amount'] . $post['tr_crc'] . $key);
    }
	public static function user_ip()
	{
		if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
			$ip = $_SERVER['HTTP_CLIENT_IP'];
		} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
			$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
		} else {
			$ip = $_SERVER['REMOTE_ADDR'];
		}

		return $ip;
	}
}
